<?php
/*
 * This file is part of XBE Enterprise.
 * (c) 2007-2008 Exbridge,inc. <info@exbridge.jp>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

/**
 * XBE Enterpriseとして、製品共通として使用されるパラメータを設定する。
 * 
 */

//=================================================================================
//フレームワーク設定
//=================================================================================
define('PW_DEBUG',                  false);
define('PW_ERROR_MAIL_SENDER',      false);
define('PW_DISABLE_SESSION',        true);
define('PW_SESSION',                'php');
define('PW_SESSION_NAME',           'symfony');
define('PW_LANGUAGE',               'ja');
define('PW_HTML_META_CHARSET',      'UTF-8');
define('PW_ENCODE',                 'UTF-8');
define('PW_CSV_ENCODE',             'SJIS-win');
define('PW_DYNAMIC_VALUE_OBJECT',   true);
define('PW_VALUE_OBJECT_CACHE_DIR', PW_ROOT_DIR . DS .'app' . DS . 'values');

//=================================================================================
//log infomation
// log level 1:DEBUG 2:INFO 3:WARN 4:ERROR 5:FATAL
//=================================================================================
define('LOGGER_DIR', PW_ROOT_DIR . DS . 'log');
define('LOGGER_LEVEL', 1);
define('LOGGER_MAX_SIZE', 5242880); //1024*1024*5
define('LOGGER_MAX_ROTATION', 10);

//=================================================================================
//copylight
//=================================================================================
define('COPYRIGHT',  '&copy;2008 EXBRIDGE,Inc.');
define('EXBRIDE_URL','http://exbridge.jp');

//=================================================================================
//基本導入システム
// aurora
// helios_portal
// helios_cotv
// selene_xms
// selene_work
// eg3_bo
//=================================================================================
define('XBE_PRODUCT_AURORA',        'aurora');
define('XBE_PRODUCT_HELIOS_PORTAL', 'helios_portal');
define('XBE_PRODUCT_HELIOS_COTV',   'helios_cotv');
define('XBE_PRODUCT_HELIOS_PETIT_MAIL',   'helios_petit_mail');
define('XBE_PRODUCT_SELENE_XMS',    'selene_xms');
define('XBE_PRODUCT_SELENE_WORK',   'selene_work');
define('XBE_PRODUCT_EG3_BO',        'eg3_bo');

//=================================================================================
//利用会社ＩＤ
//=================================================================================
define('USER_COMPANY_ID','1');

//=================================================================================
//権限情報
//=================================================================================
define('CREDENTIAL_SUPER',       '0');
define('CREDENTIAL_ADMIN',       '1');
define('CREDENTIAL_ADMIN_KEIRI', '10');
define('CREDENTIAL_ADMIN_SOMU',  '11');
define('CREDENTIAL_ADMIN_SOKO',  '12');
define('CREDENTIAL_ADMIN_EIGYO', '13');
define('CREDENTIAL_KEIRI'      , '20');
define('CREDENTIAL_SOMU',        '21');
define('CREDENTIAL_SOKO',        '22');
define('CREDENTIAL_EIGYO',       '23');
define('CREDENTIAL_COOPERATION', '96');
define('CREDENTIAL_IN_ACTIVE',   '97');
define('CREDENTIAL_NORMAL',      '98');
define('CREDENTIAL_GUEST',       '99');

//=================================================================================
//リターンコード
//=================================================================================
define('R_SUCCESS',             0);
define('R_SUCCESS_INSERT',      1);
define('R_SUCCESS_UPDATE',      2);
define('R_SUCCESS_DELETE',      3);
define('R_SUCCESS_NODATA',      4);  //正常処理（ただし戻りのデータなし）
define('R_SUCCESS_OVER_STS',    5);//正常処理（状況が進んでいる為、スキップしたものがある）
define('R_SUCCESS_DESTROY',     1);
define('R_ERROR_BASE',          0);  //エラー基準値（この値未満が例外となる）
define('R_ERROR',               -1);
define('R_ERROR_NOARG',         -2);
define('R_ERROR_NULL',          -3);
define('R_ERROR_DUPL',          -4);
define('R_ERROR_CMD',           -5);//コマンド実行失敗　リポジトリマスタなどで使用
define('R_ERROR_HAN_SEIKYU',    -6);//締請求先エラー
define('R_ERROR_HAN_NYUKIN',    -7);//入金済エラー
define('R_ERROR_KOU_SIHARAI',   -6);//締支払先エラー
define('R_ERROR_KOU_SYUKIN',    -7);//出金済エラー
define('R_ERROR_DUPL_MAIL',     -8);
define('R_ERROR_FILESIZE',      -10);//ファイルサイズエラー
define('R_ERROR_EXTENSION',     -11);//拡張子エラー
define('R_ERROR_UPLOAD',        -12);//アップロードエラー
define('R_ERROR_POST_BLOG',     -13);//ブログ投稿エラー
define('R_ERROR_NODATA',        -14);   //データがなくてエラー
define('R_ERROR_DUPL_STAFFCD',  -15);
define('R_ERROR_DUPL_USERCD',   -16);

//=================================================================================
//分類体系
//=================================================================================
define('BUNRUIKB_00','0');//分類マスタ（デフォルト）
define('BUNRUIKB_01','1');//文書管理用分類マスタ
define('BUNRUIKB_02','2');//備品管理用分類マスタ
define('BUNRUIKB_03','3');//在庫管理用分類マスタ
define('BUNRUIKB_04','4');//未使用
define('BUNRUIKB_05','5');//グループ／プロジェクトマスタ
define('BUNRUIKB_06','6');//所属
define('BUNRUIKB_07','7');//カテゴリー(COTV)
define('BUNRUIKB_08','8');//カテゴリー(eg3 新着情報)
define('BUNRUIKB_09','9');//地域
define('BUNRUIKB_10','10');//アップロードファイル
define('BUNRUIKB_11','11');//職種 カテゴリ(SELENE.work)

//=================================================================================
//コードマスタキー
//=================================================================================
define('CODEKB_00','0');
define('CODEKB_01','1');
define('CODEKB_02','2');
define('CODEKB_03','3');
define('CODEKB_04','4');
define('CODEKB_05','5');
define('CODEKB_06','6');
define('CODEKB_07','7');
define('CODEKB_08','8');
define('CODEKB_09','9');
define('CODEKB_10','10');
define('CODEKB_11','11');
define('CODEKB_12','12');
define('CODEKB_13','13');
define('CODEKB_14','14');
define('CODEKB_15','15');
define('CODEKB_16','16');
define('CODEKB_17','17');
define('CODEKB_18','18');
define('CODEKB_19','19');
define('CODEKB_20','20');
define('CODEKB_21','21');
define('CODEKB_22','22');
define('CODEKB_23','23');
define('CODEKB_24','24');
define('CODEKB_25','25');
define('CODEKB_26','26');
define('CODEKB_27','27');
define('CODEKB_28','28');
define('CODEKB_29','29');
define('CODEKB_30','30');
define('CODEKB_31','31');
define('CODEKB_32','32');
define('CODEKB_33','33');
define('CODEKB_34','34');
define('CODEKB_35','35');
define('CODEKB_36','36');
define('CODEKB_37','37');
define('CODEKB_38','38');
define('CODEKB_39','39');
define('CODEKB_40','40');
define('CODEKB_41','41');
define('CODEKB_42','42');
define('CODEKB_43','43');
define('CODEKB_61','61');
define('CODEKB_81','81');
define('CODEKB_121','121');
define('CODEKB_161','161');
define('CODEKB_181','181');
define('CODEKB_201','201');
define('CODEKB_202','202');
define('CODEKB_203','203');
define('CODEKB_221','221');
define('CODEKB_222','222');
define('CODEKB_223','223');
define('CODEKB_224','224');
define('CODEKB_225','225');
define('CODEKB_226','226');
define('CODEKB_227','227');
define('CODEKB_241','241');
define('CODEKB_261','261');     //承認区分
define('CODEKB_500','500');
define('CODEKB_501','501');
define('CODEKB_502','502');
define('CODEKB_503','503');
define('CODEKB_504','504');
define('CODEKB_505','505');
define('CODEKB_506','506');
define('CODEKB_507','507');
define('CODEKB_508','508');
define('CODEKB_600','600');     //ガジェットタイプ
define('CODEKB_700','700');
define('CODEKB_701','701');
define('CODEKB_702','702');
define('CODEKB_703','703');
define('CODEKB_710','710');
define('CODEKB_711','711');
define('CODEKB_720','720');
define('CODEKB_721','721');
define('CODEKB_722','722');
define('CODEKB_723','723');
define('CODEKB_724','724');
define('CODEKB_730','730');
define('CODEKB_731','731');
define('CODEKB_740','740');
define('CODEKB_800','800');
define('CODEKB_900','900');
define('CODEKB_901','901');

//=================================================================================
//データ状態
//=================================================================================
define('DB_ENABLE','0');//有効
define('DB_DELETE','1');//削除状態

//=================================================================================
//１ページ最大行数
//=================================================================================
define('PAGEMAX', 100);

//=================================================================================
//年月リストボックス範囲
//=================================================================================
define('MIN_DISP_YEAR',3);
define('MAX_DISP_YEAR',1);

//=================================================================================
//メニューのタイプ
//=================================================================================
define('MENU_TYPE','2');//0:バー 1:onContextMenu 2:カテゴリー別

//=================================================================================
//WebService Super Magic Keyword
//=================================================================================
define ('AUTH_MAGIC_ENABLED', false);
define ('AUTH_MAGIC',         '31eafcbd7a81d7b401a7fdc12bba047c02d1fae6');
define ('ONETIMEPASSWORD',    false);

//=================================================================================
//セッション
//=================================================================================
//旧AURORA(xbrg_aurora_srcリポジトリ)との情報共有のためのdefine値
define('SESSION_AURORA_USER_MANAGER',    'aurora.user.manager');
define('SESSION_AURORA_USER_COMPANY_ID', 'aurora.user.usercompanyid');
define('SESSION_AURORA_COMMON_RESULT',   'aurora.common.result');
define('SESSION_ADMIN_MODE',             'aurora.admin.mode');
define('SESSION_REQURI',                 'aurora.request.uri');

define('SESSION_OID',                    'common.object_id');
define('SESSION_LOGON_USER_COMPANY_ID',  'logon_user_company_id');
define('SESSION_LOGON_USER_CD',          'logon_user_cd');
define('SESSION_LOGON_USER_NM',          'logon_user_nm');
define('SESSION_LOGON_PERSONAL_ID',      'logon_personal_id');
define('SESSION_LOGON_MAIL',             'logon_mail');
define('SESSION_LOGON_SEC_LEVEL',        'logon_sec_level');
define('SESSION_LOGON_STORE_ID',         'logon_store_id');//@todo 利用側で複数店舗処理が実装されたら消去対象となります
define('SESSION_LOGON_STORE_LIST',       'logon_store_list');
define('SESSION_HASH',                   'hash');
define('SESSION_LOGON_PROJECT_FROM',     'logon_project_from');

//=================================================================================
//クッキー
//=================================================================================
define('COOKIE_USER_COMPANY_ID',         'cookie_user_company_id');
define('COOKIE_USER_CD',                 'cookie_user_cd');
define('COOKIE_USER_INFO',               'cookie_user_info');
define('COOKIE_SECURITY_KEY',            'core');
define('COOKIE_KEEP_LOGGED_IN_FOR',      60*60*24*100);//クッキー保存日数(100日==60*60*24*100)
define('COOKIE_PATH',                    '/');

