<?php
/*
 * This file is part of HELIOS.PetitMail
 * (c) 2007-2008 Exbridge,inc. <info@exbridge.jp>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

/**
 * Heliosメール　画面インターフェース
 *
 * @copyright 2008- EXBRIDGE,Inc. All Rights Reserved.
 * @link      http://exbridge.jp/
 * @package   HELIOS.PetitMail
 * @version   svn:$Id: iMailController.php 8524 2008-09-27 08:27:02Z shimizu $
 */
class iMailController extends xbeHeliosPetitMailController {

    var $_display_name  = T_MAIL; //画面名

    /**
     * 初期処理
     *
     * コントローラー初期処理
     *
     */
    function init(){
        //メール送信方法　flg_send_each
        //1:複数宛先指定時でも個別にメールを送る(デフォルト)
        //0:複数宛先指定時にまとめてメールを送る
        $this->flg_send_each   = (isNULL($this->flg_send_each))?1:$this->flg_send_each;
        //編集フラグ　デフォルト:true
        $this->flg_editable   = true;
        $this->from_mail      = MAIL_FROM;
    }

    /**
     * デフォルト呼出
     */
    function executeDefault() {
        $mail_info_list = array();
        foreach ($this->id_list as $id) {
            $mail_info = array();
            $key_name = 'name_' . $id;
            $key_mail = 'mail_' . $id;

            $mail_info['name'] = mb_convert_encoding($this->$key_name, PW_ENCODE, 'auto');
            $mail_info['mail'] = mb_convert_encoding($this->$key_mail, PW_ENCODE, 'auto');
            if(isNULL($mail_info['mail'])) {
                //値が空の場合は処理を飛ばす
                continue;
            }
            $mail_info_list[] = $mail_info;
        }
        $this->mail_info_list = $mail_info_list;
        $this->forward('Show');
    }

    /**
     * 画面表示
     */
    function executeShow() {
        $send_mail_id = $this->send_mail_id;
        if(!isNULL($send_mail_id)) {
            $url = HELIOS_PETITMAIL_URL . 'web.php?action=RequestSendMailHistory&send_mail_id=' . $send_mail_id;
            //メール履歴情報の取得
            $data = get_url_contents($url);
            $send_mail_history = json_decode($data, true);
            $this->subject          = $send_mail_history['subject'];
            $this->body             = $send_mail_history['body'];
            $this->mail_info_list   = $send_mail_history['mail_info_list'];

            $to_mail_list     = $send_mail_history['to_mail_list'];
            $cc_mail_list     = $send_mail_history['cc_mail_list'];
            $bcc_mail_list    = $send_mail_history['bcc_mail_list'];

            $this->to_mail_str     = implode(',', $to_mail_list);
            $this->cc_mail_str     = implode(',', $cc_mail_list);
            $this->bcc_mail_str    = implode(',', $bcc_mail_list);

            $this->status_kb        = $send_mail_history['status_kb'];
            $this->send_date        = $send_mail_history['send_date'];
            $this->send_each_flg    = $send_mail_history['send_each_flg'];
            if($this->status_kb == MAILSTATUS_SEND) {
                //編集付加
                $this->flg_editable  = false;
            }
        }

        $this->render('interface/mail');
    }
}
?>
