<?php
/*
 * This file is part of HELIOS.PetitMail
 * (c) 2007-2008 Exbridge,inc. <info@exbridge.jp>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

/**
 * webサービス
 *
 * @copyright 2008- EXBRIDGE,Inc. All Rights Reserved.
 * @link      http://exbridge.jp/
 * @package   HELIOS.PetitMail
 * @version   svn:$Id: webController.php 8738 2008-10-03 00:58:17Z shimizu $
 */
class webController extends xbpwController {

    /**
     * 初期処理
     *
     * コントローラー初期処理
     *
     */
    function init(){
        if(isNULL($this->user_company_id)) {
            $this->user_company_id = USER_COMPANY_ID;
        }
    }

    /**
     * メール送信履歴一覧取得
     */
    function executeRequestSendMailHistoryList(){
        //サービス取得(メール情報管理)
        $sv = & xbpwContext::getService('mail');
        //基本ValueObject生成
        $vo = $sv->getValueObject();

        $vo->user_company_id = $this->user_company_id;

        if(!isNULL($this->send_date_from)) {
            $vo->send_date_from    = formatYmdHmsWriter($this->send_date_from . '000000');
        }
        if(!isNULL($this->send_date_to)) {
            $vo->send_date_to      = formatYmdHmsWriter($this->send_date_to . '235959');
        }

        $vo->subject        = $this->subject;
        $vo->body           = $this->body;
        $vo->status_kb_list = $this->status_kb_list;
        $vo->to_mail        = $this->to_mail;

        $sv->getSendMailHistoryList($vo);
        echo json_encode($vo->send_mail_history_list);
        return PW_TERMINATE_PROCESS;
    }

    /**
     * メール送信履歴取得
     */
    function executeRequestSendMailHistory(){
        //サービス取得(メール情報管理)
        $sv = & xbpwContext::getService('mail');
        //基本ValueObject生成
        $vo = $sv->getValueObject();

        $vo->user_company_id = $this->user_company_id;
        $vo->send_mail_id    = $this->send_mail_id;

        $sv->getSendMailHistory($vo);
        echo json_encode($vo->send_mail_history);
        return PW_TERMINATE_PROCESS;
    }

    /**
     * メール送信
     */
    function executeRequestSend(){
        //サービス取得(メール送信)
        $sv_send = & xbpwContext::getService('sendMail');
        //基本ValueObject生成
        $vo_send = $sv_send->getValueObject();

        //サービス取得(メール情報管理)
        $sv_mail = & xbpwContext::getService('mail');
        //基本ValueObject生成
        $vo_mail = $sv_mail->getValueObject();

        //必須パラメータ
        $to_mail_list    = $this->to_mail_list;
        $from_mail       = $this->from_mail;
        $cc_mail_list    = $this->cc_mail_list;
        $bcc_mail_list   = $this->bcc_mail_list;

        //メール送信方法　flg_send_each
        //1:複数宛先指定時でも個別にメールを送る(デフォルト)
        //0:複数宛先指定時にまとめてメールを送る
        $this->flg_send_each   = (isNULL($this->flg_send_each))?1:$this->flg_send_each;

        //表示名・メールアドレスの分別＆チェック

        if(isNULL($to_mail_list)) {
            $to_mail_list = null;
        }
        else if(is_array($to_mail_list)) {
            foreach($to_mail_list as $to_mail) {
                if(isNULL($to_mail)){
                    continue;
                }
                $to_mail_info    = $this->getMailInfo($to_mail);
                $vo_send->to_mail_info_list[]    = $to_mail_info;
                $this->to_mail_info_list[]  = $to_mail_info;
            }
        }
        else {
            $to_mail_info    = $this->getMailInfo($to_mail_list);
            $vo_send->to_mail_info_list[]    = $to_mail_info;
            $this->to_mail_info_list[]  = $to_mail_info;
        }

        $from_mail_info = $this->getMailInfo($from_mail);
        $this->from_mail_info           = $from_mail_info;
        $vo_send->from_mail_info             = $from_mail_info;

        if(is_array($cc_mail_list)) {
            foreach($cc_mail_list as $cc_mail) {
                if(isNULL($cc_mail)){
                    continue;
                }
                $cc_mail_info    = $this->getMailInfo($cc_mail);
                $vo_send->cc_mail_info_list[]    = $cc_mail_info;
                $this->cc_mail_info_list[]  = $cc_mail_info;
            }
        }
        else {
            $cc_mail_info    = $this->getMailInfo($cc_mail_list);
            $vo_send->cc_mail_info_list[]    = $cc_mail_info;
            $this->cc_mail_info_list[]  = $cc_mail_info;
        }

        if(is_array($bcc_mail_list)) {
            foreach($bcc_mail_list as $bcc_mail) {
                if(isNULL($bcc_mail)){
                    continue;
                }
                $bcc_mail_info    = $this->getMailInfo($bcc_mail);
                $vo_send->bcc_mail_info_list[]    = $bcc_mail_info;
                $this->bcc_mail_info_list[]  = $bcc_mail_info;
            }
        }
        else {
            $bcc_mail_info    = $this->getMailInfo($bcc_mail_list);
            $vo_send->bcc_mail_info_list[]    = $bcc_mail_info;
            $this->bcc_mail_info_list[]  = $bcc_mail_info;
        }

        //-----------------------------------------------------
        //チェック
        //-----------------------------------------------------
        if (!$this->validate()) {
            $errors = $this->getErrors();
            $error_json  = json_encode($errors);
            echo $error_json;
            return PW_TERMINATE_PROCESS;
        }

        //-----------------------------------------------------
        //１．メール情報・履歴の保存
        //-----------------------------------------------------
        $vo_mail->user_company_id    = $this->user_company_id;
        $vo_mail->send_mail_id       = $this->send_mail_id;
        $vo_mail->to_mail_list       = $to_mail_list;
        $vo_mail->from_mail          = $from_mail;
        $vo_mail->cc_mail_list       = $cc_mail_list;
        $vo_mail->bcc_mail_list      = $bcc_mail_list;
        $vo_mail->send_each_flg      = $this->flg_send_each;
        $vo_mail->subject            = $this->subject;
        $vo_mail->body               = $this->body;
        //ステータスが【送信済み】以外の場合
        if($this->status_kb != MAILSTATUS_SEND) {
            $vo_mail->status_kb          = $this->status_kb;
        }
        if($this->status_kb != MAILSTATUS_RESERVE) {
            $vo_mail->send_date = getTimestamp();
        }
        $result = $sv_mail->saveSendMail($vo_mail);
        if($result == R_ERROR) {
            $errors = array();
            $errors['unknown'] = E_UNKNOWN;
            $error_json        = json_encode($errors);
            echo $error_json;
            return PW_TERMINATE_PROCESS;
        }

        //ステータスが【送信済み】の場合
        if($this->status_kb == MAILSTATUS_SEND) {
            //-----------------------------------------------------
            //２．メールの送信
            //-----------------------------------------------------
            $vo_send->subject         = $this->subject;
            $vo_send->body            = $this->body;

            if($this->flg_send_each){
                //宛先それぞれに分けてメールを送信する
                $result_info = $sv_send->sendEach($vo_send);
            }
            else {
                $result_info = $sv_send->send($vo_send);
            }
            if (is_array($result_info)) {
                $errors = array();
                $errors['error_send_mail'] = E_SEND_MAIL . "\n" . $result_info['r_message'];
                $error_json        = json_encode($errors);
                echo $error_json;
                return PW_TERMINATE_PROCESS;
            }

            //-----------------------------------------------------
            //3．メール送信ステータスの更新(送信済みにする)
            //-----------------------------------------------------
            $vo_mail->status_kb          = $this->status_kb;
            $result = $sv_mail->updateSendMailStatus($vo_mail);
        }

        echo R_SUCCESS;
        return PW_TERMINATE_PROCESS;
    }

    /**
     * メール情報取得
     */
    private function getMailInfo($mail){
        //----------------------------------------------------------
        //メールアドレスの形式
        //  1.demo@exbridge.jp
        //  2. 山田　デモ太郎 <demo@exbridge.jp>
        //  3. "山田　デモ太郎" <demo@exbridge.jp>
        //----------------------------------------------------------
        //ダブルクォーテーションの削除
        $mail = str_replace("\"", "", $mail);
        //パターン
        $pattern = '/^\s*([^<>]*)\s*<([^<>]*)>$/i';
        preg_match($pattern, $mail, $matches);

        if(!isNULL($matches[2])) {
            $mail_info['name'] = $matches[1];
            $mail_info['mail'] = $matches[2];
        }
        else {
            $mail_info = $mail;
        }
        return $mail_info;
    }
}

?>
