<?php
/**
 * common controller class.
 *
 * @author    S.Tajima <tajima@exbridge.jp> 2008/08/25
 * @copyright 2007- EXBRIDGE,Inc. All Rights Reserved.
 * @link      http://exbridge.jp/
 */
class xbeCommonController extends xbpwController {

    var $_pw_layout_template = 'default';

    var $_function_name = T_SITE_FUNCTION;

    var $_project_from;
    var $_hash;


    var $_pw_css     = array('css/blueprint/screen.css', 
                             'css/blueprint/print.css', 
                             'css/tab/tabs.css', 
                             'css/tab/tabs-ie.css'); //CSS

    var $_pw_jscript = array('js/ext/jquery/jquery.js',
                             'js/interface.js',
                             'js/jquery.tabs.pack.js',
                             'js/xbeJquery.js',
                             'js/validation.js',
                             'js/ext/jquery/jquery.page-scroller.js',
                             'js/ext/jquery/jquery.tooltip.js',
                             'js/ext/jquery/jquery.bgiframe.js',
                             'js/ext/jquery/jquery.dimensions.js',
                             'js/ext/jquery/ui/ui.mouse.js',
                             'js/ext/jquery/ui/ui.draggable.js',
                             'js/ext/jquery/ui/ui.draggable.ext.js',
                             'js/ext/jquery/ui/ui.mouse.js',
                             'js/ext/jquery/ui/ui.draggable.js',
                             'js/ext/jquery/ui/ui.draggable.ext.js',
                             'js/date.js',
                             'js/jquery.datePicker.js',
                             'js/xbJquery.js',
                             'js/pwlib.js',
                             'js/xbJscript.js',
                             'js/menuControl.js'); //Jscript

    var $base_project = CORE_BASE_APPLICATION;
    var $relay_url = '';
    var $home_url = '';
    var $top_url  = '';
    var $authenticated;
    var $user_company_id = CORE_USER_COMPANY_ID;
    var $user_store_id;

    /**
     * 初期処理
     *
     * コントローラー初期処理
     */
    function init() {
        require_once(PW_ROOT_DIR . '/app/config/core/application.php');

        coreUtil::load_service();
        coreUtil::load_app('uam');
        coreUtil::load_view('User', 'common');
        coreUtil::load_view('UserLogon', 'xbrg_uam');

        //session start
        if(session_name() != PW_SESSION_NAME){
            session_name(PW_SESSION_NAME);
        }
        if (!isNULL($this->oid)) {
            session_id($this->oid);
        }
        session_start();

        $user = & xbpwContext::getUser();
        if (isNULL($user->getUserParameter(SESSION_AURORA_USER_MANAGER))) {
            $user->setUserParameter(SESSION_AURORA_USER_MANAGER, new xbUserSession());
        }
        xbpwContext::setUser($user);

        if (!(isNULL($this->user_cd)) && !(isNULL($this->hash))) {
            $this->_hash = $this->hash;
            $this->_project_from = $this->project_from;
            $user_info = array();
            $data = array();
            $this->logon($this->user_company_id, $this->user_cd, true, $data, $user_info);
            $this->_signIn($user_info);
        }
        else {
            $this->_project_from = $this->project;
        }
        $this->_loadLogonUserInfo();

        //-------------------------------------------------------
        //基本プロダクトより
        //-------------------------------------------------------
        switch ($this->base_project) {
            case XBE_PRODUCT_AURORA:
                $this->home_url = CORE_RELAY_URL . '?oid=' . session_id() . '&logon=' . CORE_AURORA_URL . 'core/logon.php&url=' . CORE_AURORA_HOME;
                break;
            case XBE_PRODUCT_HELIOS_PORTAL:
                $this->home_url = CORE_RELAY_URL . '?oid=' . session_id() . '&logon=' . CORE_HELIOS_PORTAL_URL . 'core/logon.php&url=' . CORE_HELIOS_PORTAL_HOME;
                break;
            case XBE_PRODUCT_HELIOS_COTV:
                $this->home_url = CORE_RELAY_URL . '?oid=' . session_id() . '&logon=' . CORE_HELIOS_COTV_URL . 'core/logon.php&url=' . CORE_HELIOS_COTV_HOME;
                break;
            case XBE_PRODUCT_SELENE_XMS:
                $this->home_url = CORE_RELAY_URL . '?oid=' . session_id() . '&logon=' . CORE_SELENE_XMS_URL . 'core/logon.php&url=' . CORE_SELENE_XMS_HOME;
                break;
            case XBE_PRODUCT_SELENE_WORK:
                $this->home_url = CORE_RELAY_URL . '?oid=' . session_id() . '&logon=' . CORE_SELENE_WORK_URL . 'core/logon.php&url=' . CORE_SELENE_WORK_HOME;
                break;
            case XBE_PRODUCT_EG3_BO:
                $this->home_url = CORE_RELAY_URL . '?oid=' . session_id() . '&logon=' . CORE_EG3_BO_URL . 'core/logon.php&url=' . CORE_EG3_BO_HOME;
                break;
            default:
                $this->home_url = CORE_RELAY_URL . '?oid=' . session_id() . '&logon=' . CORE_AURORA_URL . 'core/logon.php&url=' . CORE_AURORA_HOME;
                break;
        }

        //-------------------------------------------------------
        //ログオン先より
        //-------------------------------------------------------
        if (isNULL($this->project)) {
            $this->project = $this->base_project;
        }
        switch ($this->project) {
            case XBE_PRODUCT_AURORA:
                $this->top_url = CORE_RELAY_URL . '?oid=' . session_id() . '&logon=' . CORE_AURORA_URL . 'core/logon.php&url=' . CORE_AURORA_TOP;
                break;
            case XBE_PRODUCT_HELIOS_PORTAL:
                $this->top_url = CORE_RELAY_URL . '?oid=' . session_id() . '&logon=' . CORE_HELIOS_PORTAL_URL . 'core/logon.php&url=' . CORE_HELIOS_PORTAL_TOP;
                break;
            case XBE_PRODUCT_HELIOS_COTV:
                $this->top_url = CORE_RELAY_URL . '?oid=' . session_id() . '&logon=' . CORE_HELIOS_COTV_URL . 'core/logon.php&url=' . CORE_HELIOS_COTV_TOP;
                break;
            case XBE_PRODUCT_SELENE_XMS:
                $this->top_url = CORE_RELAY_URL . '?oid=' . session_id() . '&logon=' . CORE_SELENE_XMS_URL . 'core/logon.php&url=' . CORE_SELENE_XMS_TOP;
                break;
            case XBE_PRODUCT_SELENE_WORK:
                $this->top_url = CORE_RELAY_URL . '?oid=' . session_id() . '&logon=' . CORE_SELENE_WORK_URL . 'core/logon.php&url=' . CORE_SELENE_WORK_TOP;
                break;
            case XBE_PRODUCT_EG3_BO:
                $this->top_url = CORE_RELAY_URL . '?oid=' . session_id() . '&logon=' . CORE_EG3_BO_URL . 'core/logon.php&url=' . CORE_EG3_BO_TOP;
                break;
            default:
                $this->top_url = CORE_RELAY_URL . '?oid=' . session_id() . '&logon=' . CORE_AURORA_URL . 'core/logon.php&url=' . CORE_AURORA_TOP;
                break;
        }
    }

    /**
     * サインイン処理
     *
     */
    function _signIn($user_info){
        //認証ＯＫ -> ＴＯＰ画面へ遷移
        $user = & xbpwContext::getUser();
        $user->setUserParameter(SESSION_OID, session_id());
        $user->setUserParameter(SESSION_LOGON_USER_COMPANY_ID, $user_info['user_company_id']);
        $user->setUserParameter(SESSION_LOGON_PERSONAL_ID, $user_info['personal_id']);
        $user->setUserParameter(SESSION_LOGON_USER_CD, $user_info['user_cd']);
        $user->setUserParameter(SESSION_LOGON_USER_NM, $user_info['user_nm']);
        $user->setUserParameter(SESSION_LOGON_SEC_LEVEL, $user_info['sec_level']);
        $user->setUserParameter(SESSION_LOGON_MAIL, $user_info['mail']);
        $user->setUserParameter(SESSION_LOGON_STORE_ID, $user_info['store_id']);//@todo 利用側で複数店舗処理が実装されたら消去対象となります
        $user->setUserParameter(SESSION_LOGON_STORE_LIST, $user_info['store_list']);
        $user->setUserParameter(SESSION_HASH, $user_info['hash']);
        //別システムからの利用
        $user->setUserParameter(SESSION_LOGON_PROJECT_FROM, $user_info['project_from']);
        //ログオン完了
        $user->setAuthenticated(true);
        xbpwContext::setUser($user);
        $this->authenticated = true;
    }

    /**
     * サインアウト処理
     *
     */
    function signOut(){
        //クッキー削除
        setcookie(COOKIE_USER_COMPANY_ID, $user_company_id, time() - COOKIE_KEEP_LOGGED_IN_FOR, COOKIE_PATH);
        setcookie(COOKIE_USER_CD, '', time() - COOKIE_KEEP_LOGGED_IN_FOR, COOKIE_PATH);
        setcookie(COOKIE_USER_INFO, '', time() - COOKIE_KEEP_LOGGED_IN_FOR, COOKIE_PATH);
        $user = & xbpwContext::getUser();
        $user->setAuthenticated(false);
        xbpwContext::setUser($user);
        $this->authenticated = false;
    }

    /**
     * ログオンユーザー情報取得
     *
     */
    function _loadLogonUserInfo() {
        $user = &xbpwContext::getUser();
        $this->authenticated = $user->isAuthenticated();
        if ($user->isAuthenticated()) {
            $this->oid                   = $user->getUserParameter(SESSION_OID);
            $this->user_company_id       = $user->getUserParameter(SESSION_LOGON_USER_COMPANY_ID);
            $this->logon_user_company_id = $user->getUserParameter(SESSION_LOGON_USER_COMPANY_ID);
            $this->logon_user_cd         = $user->getUserParameter(SESSION_LOGON_USER_CD);
            $this->logon_user_nm         = $user->getUserParameter(SESSION_LOGON_USER_NM);
            $this->logon_personal_id     = $user->getUserParameter(SESSION_LOGON_PERSONAL_ID);
            $this->logon_mail            = $user->getUserParameter(SESSION_LOGON_MAIL);
            $this->logon_sec_level       = $user->getUserParameter(SESSION_LOGON_SEC_LEVEL);
            $this->user_store_id         = $user->getUserParameter(SESSION_LOGON_STORE_ID);//@todo 利用側で複数店舗処理が実装されたら消去対象となります
            $this->logon_store_list      = $user->getUserParameter(SESSION_LOGON_STORE_LIST);
            $this->hash                  = $user->getUserParameter(SESSION_HASH);
            $this->logon_project_from    = $user->getUserParameter(SESSION_LOGON_PROJECT_FROM);
            if ($this->logon_sec_level!=AuthService::SUPER && $this->logon_sec_level!=AuthService::ADMIN) {
                $this->cp_store_id       = $this->user_store_id;
            }
        }
        else {
            global $global_exclusion_url;
            foreach ($global_exclusion_url as $url) {
                if (preg_match($url, $_SERVER['REQUEST_URI'])) {
                    return;
                }
            }
            if (!preg_match('/logon\.php/i', $_SERVER['REQUEST_URI'])) {
                if (isset($this->admin) && $this->admin==1) {
                    $this->redirectToUrl(CORE_LOGON . '?admin=' . $this->admin);
                    exit();
                }
                else {
                    $url = 'http://' . $_SERVER["HTTP_HOST"] . $_SERVER['REQUEST_URI'];
                    $this->redirectToUrl(CORE_LOGON . '?redirect_url=' . $url);
                    exit();
                }
            }
        }
    }

    /**
     * 自動ログオン設定
     * クッキーにログオン情報を取得します
     *
     */
    function setAutoLogon($user_company_id, $user_cd, $password) {
        //クッキーにログオン情報を保存
        if (AUTH_MAGIC_ENABLED) {
            $magic_password = sha1($password . ':' . AUTH_MAGIC);
        }
        else {
            $magic_password = $password;
        }
        setcookie(COOKIE_USER_INFO, md5(COOKIE_SECURITY_KEY . $_SERVIER['REMOTE_ADDR'] . $magic_password . $_SERVER['HTTP_USER_AGENT']), time() + COOKIE_KEEP_LOGGED_IN_FOR, COOKIE_PATH);
        setcookie(COOKIE_USER_COMPANY_ID, $user_company_id, time() + COOKIE_KEEP_LOGGED_IN_FOR, COOKIE_PATH);
        setcookie(COOKIE_USER_CD, $user_cd, time() + COOKIE_KEEP_LOGGED_IN_FOR, COOKIE_PATH);
    }

    /**
     * 自動ログオン
     * クッキーよりログオン情報を取得して自動ログオンします
     * return true(成功)/false(失敗)
     *
     */
    function autoLogon() {
        if ($this->authenticated) {
            return true;
        }
        //クッキーが存在する場合
        if (!isNULL($_COOKIE[COOKIE_USER_INFO])) {
            $user_company_id = $_COOKIE[COOKIE_USER_COMPANY_ID];
            $user_cd = $_COOKIE[COOKIE_USER_CD];
            $data = null;
            $user_info = null;
            $results = $this->logon($user_company_id, $user_cd, false, $data, $user_info);

            //認証OK
            if ($results) {
                //クッキー認証
                if ($_COOKIE[COOKIE_USER_INFO] == md5(COOKIE_SECURITY_KEY . $_SERVIER['REMOTE_ADDR'] . $user_info['password'] . $_SERVER['HTTP_USER_AGENT'])) {
                    $this->_signIn($user_info);
                    $this->_loadLogonUserInfo();
                    return true;
                }
            }
        }
        return false;
    }

    /**
     * ログオン
     * return true(成功)/false(失敗)
     *
     */
    function logon($user_company_id, $user_cd, $password=false, & $data, & $user_info) {
        $project_from = $this->_project_from;
        if (!isNULL($this->_hash)) {
            //外部システムからのログイン要求
            $status = 'OK';
            $hash = $this->_hash;
            debugLog("exist hash from other system. ", __CLASS__, __FILE__, __LINE__);
        }
        else {
            //AURORAのユーザー認証を行う
            if ($password === false) {
                $request_url = CORE_AURORA_URL . 'xbeWebLogon.php?action=RequestLogon&user_company_id=' . $user_company_id . '&user_cd=' . $user_cd . '&remember=1';
                debugLog("request url [remember][$request_url]", __CLASS__, __FILE__, __LINE__);
            }
            else {
                $request_url = CORE_AURORA_URL . 'xbeWebLogon.php?action=RequestLogon&user_company_id=' . $user_company_id . '&user_cd=' . $user_cd . '&user_pw=' . $password;
                debugLog("request url [logon][$request_url]", __CLASS__, __FILE__, __LINE__);
            }
            $data = get_url_contents($request_url);
            list($status, $user_cd, $hash) = explode(",", $data);
        }
        debugLog($status, __CLASS__, __FILE__, __LINE__);

        //認証OK
        if($status == 'OK') {

            //ユーザー情報を取得
            $request_user_url = CORE_AURORA_URL . 'xbeWebLogon.php?action=RequestUserInfo&user_company_id=' . $user_company_id . '&user_cd=' . $user_cd . '&hash=' . $hash;
            debugLog("request url [info][$request_user_url]", __CLASS__, __FILE__, __LINE__);
            $user_data = get_url_contents($request_user_url);
            debugLog($user_data, __CLASS__, __FILE__, __LINE__);

            list($user_cd,
                 $personal_id,
                 $hash,
                 $user_nm,
                 $mail,
                 $sec_level,
                 $ical_file,
                 $password) = explode(',', $user_data);

            //店舗管理情報を取得
            $request_store_admin_url = CORE_AURORA_URL . 'xbeWebMaster.php?action=RequestStoreAdminList&user_company_id=' . $user_company_id . '&personal_id=' . $personal_id;
            debugLog("request url [store][$request_store_admin_url]", __CLASS__, __FILE__, __LINE__);
            $store_admin_data = get_url_contents($request_store_admin_url);
            $store_admin_list = json_decode($store_admin_data, true);
            debugLog($store_admin_list, __CLASS__, __FILE__, __LINE__);

            foreach ($store_admin_list as $store_admin) {
                $store_id = $store_admin['store_id'];
                break;
            }

            $user_info = array();
            $user_info['user_company_id'] = $user_company_id;
            $user_info['personal_id']     = $personal_id;
            $user_info['user_cd']         = $user_cd;
            $user_info['user_nm']         = $user_nm;
            $user_info['password']        = $password;
            $user_info['mail']            = $mail;
            $user_info['sec_level']       = $sec_level;
            $user_info['ical_file']       = $ical_file;
            $user_info['hash']            = $hash;
            $user_info['store_id']        = $store_id;//@todo 利用側で複数店舗処理が実装されたら消去対象となります
            $user_info['store_list']      = $store_admin_list;
            $user_info['project_from']    = $project_from;
            //セッションにログイン情報を保存
            $this->_signIn($user_info);

            $_SESSION[SESSION_AURORA_USER_COMPANY_ID] = $user_company_id;
            $userVeiw = UserView::getInstance();
            $userVeiw->userCompanyId      = $user_company_id;
            $userVeiw->personalId         = $user_info['personal_id'];
            $userVeiw->userCd             = $user_info['user_cd'];
            $userVeiw->userNm             = $user_info['user_nm'];
            $userVeiw->passwd             = $user_info['password'];
            $userVeiw->mail               = $user_info['mail'];
            //$userVeiw->staffCd            = $user_info['staff_cd'];
            //$userVeiw->userOrganizationId = $user_info['organization_id'];
            //$userVeiw->userOrganization   = $user_info['organization'];
            //$userVeiw->companyNm          = $user_info['company_nm'];
            $userVeiw->authGroupId        = $user_info['sec_level'];
            $userVeiw->icalFile           = $user_info['ical_file'];
            $userVeiw->hash               = $user_info['hash'];
            $userVeiw->projectFrom        = $user_info['project_from'];

            $pw_user = & xbpwContext::getUser();
            $user = $pw_user->getUserParameter(SESSION_AURORA_USER_MANAGER);
            $user->signIn($userVeiw);
            $pw_user->setAuthenticated(true);
            debugLog('Authenticated:TRUE');
            return true;
        }
        debugLog('Authenticated:FALSE');
        return false;
    }
}
