<?php
/*
 * This file is part of HELIOS.PetitMail
 * (c) 2007-2008 Exbridge,inc. <info@exbridge.jp>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

/**
 * HELIOS.PetitMail　コンフィグ
 *
 * @copyright 2008- EXBRIDGE,Inc. All Rights Reserved.
 * @link      http://exbridge.jp/
 * @package   HELIOS.PetitMail
 * @version   svn:$Id: heliosPetitMailConfig.class.php 8526 2008-09-27 08:27:55Z shimizu $
 */
class heliosPetitMailConfig
{
    /**
     * メール送信ステータスを取得
     *
     * @return  メール送信ステータスを取得
     */
    public static function getSendMailStatus(){
        /* AURORAのシステムを利用する場合コードマスタから取得
        $list = get_code_list(CODEKB_900);
        $code_list = array();
        foreach($list as $item){
            $code_list[$item['code']] = $item['code_nm'];
        }
        */
        $code_list = array();
        $code_list[MAILSTATUS_SEND]        = TXT_MAILSTATUS_SEND;
        $code_list[MAILSTATUS_DRAFT]   = TXT_MAILSTATUS_DRAFT;
        //$code_list[MAILSTATUS_RESERVE] = TXT_MAILSTATUS_RESERVE;
        return $code_list;
    }

    /**
     * メール送信ステータスを取得
     *
     * @return  メール送信ステータスを取得(現在の状態)
     */
    public static function getSendMailCurrentStatus(){
        /* AURORAのシステムを利用する場合コードマスタから取得
        $list = get_code_list(CODEKB_901);
        $code_list = array();
        foreach($list as $item){
            $code_list[$item['code']] = $item['code_nm'];
        }
        */
        $code_list = array();
        //送信済み
        $code_list[MAILSTATUS_SEND]        = TXT_MAILSTATUS_SENT;
        $code_list[MAILSTATUS_DRAFT]   = TXT_MAILSTATUS_DRAFT;
        $code_list[MAILSTATUS_NONE]        = TXT_MAILSTATUS_NONE;
        //$code_list[MAILSTATUS_RESERVE] = TXT_MAILSTATUS_RESERVE;
        return $code_list;
    }

}
?>