<?php
/*
 * This file is part of HELIOS.
 * (c) 2007-2008 Exbridge,inc. <info@exbridge.jp>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

/**
 * メール情報管理サービス
 *
 * @copyright 2008- EXBRIDGE,Inc. All Rights Reserved.
 * @link      http://exbridge.jp/
 * @package   HELIOS
 * @version   svn:$Id: mailService.php 8740 2008-10-03 00:58:33Z shimizu $
 */
class mailService extends xbpwService {

    /**
     * メールの送信履歴一覧取得
     *
     * @access public
     * @param  $vo
     * @return
     */
    public function getSendMailHistoryList(& $vo){
        //--------------------------------------------------------------
        //呼出ログ出力
        //--------------------------------------------------------------
        debugLog('called ' . __METHOD__, __CLASS__, __FILE__, __LINE__);

        //--------------------------------------------------------------
        //引数存在チェック
        //--------------------------------------------------------------
        if (isNULL($vo)) {
            throw new xbpwException(E_USER_ERROR, sprintf(F_NM_02, 'vo'));
        }

        //--------------------------------------------------------------
        //引数パラメータ必須チェック
        //--------------------------------------------------------------
        if (!$this->assert(array('user_company_id'), & $vo)) {
            throw new xbpwException(E_USER_ERROR, sprintf(F_NM_03, 'vo'));
        }

        try {
            //--------------------------------------------------------------
            //テーブル情報の取得
            //--------------------------------------------------------------
            $somfa = $this->getDatabase();

            $keys = array();

            $vals = array();

            $keys[] = ' a.user_company_id = ? ';
            $vals[] = $vo->user_company_id;

            $keys[] = ' a.del_flg = ? ';
            $vals[] = DB_ENABLE;

            //タイトル検索
            if (!isNULL($vo->subject)){
                $keys[] = 'a.subject like ?';
                $vals[] = '%' . $vo->subject . '%';
            }

            //本文検索
            if (!isNULL($vo->body)){
                $keys[] = 'a.body like ?';
                $vals[] = '%' . $vo->body . '%';
            }

            //メール送信ステータス
            if (!isNULL($vo->status_kb_list)){
                $status_kb_list_str = "'" . implode("','", $vo->status_kb_list) . "'";

                //--------------------------------------------------------------
                //ステータス「なし」の指定
                //--------------------------------------------------------------
                $status_kb_list_flip = array_flip($vo->status_kb_list);
                $option = (isNULL($status_kb_list_flip[MAILSTATUS_NONE]))?null:' or a.status_kb is null ';

                $keys[] = " ( a.status_kb in ($status_kb_list_str) $option )";
            }

            //日付検索 from 
            if (!isNULL($vo->send_date_from)){
                $keys[] = 'a.send_date >= ?';
                $vals[] = $vo->send_date_from;
            }

            //日付検索 to 
            if (!isNULL($vo->send_date_to)){
                $keys[] = 'a.send_date <= ?';
                $vals[] = $vo->send_date_to;
            }

            //宛先検索
            if (!isNULL($vo->to_mail)){
                //履歴から検索
                $to_mail_str = '%' . $vo->to_mail . '%';
                $tmp_rs = $somfa->select('tbt_send_mail_history',
                                         'send_mail_id',
                                         'user_company_id = ? and mail_kb = ? and mail like ? and del_flg=?',
                                         array($vo->user_company_id, MAILKB_TO, $to_mail_str, DB_ENABLE)
                                        );
                $mail_id_list = array();
                foreach($tmp_rs as $item) {
                    $mail_id_list[] = $item['send_mail_id'];
                }
                if(count($mail_id_list)) {
                    $mail_id_str = implode(',', $mail_id_list);
                    $keys[] = "a.send_mail_id in ($mail_id_str)";
                }
                else{
                    //結果0件の場合はリターン
                    $vo->send_mail_history_list = $rs;

                    return R_SUCCESS;
                }
            }

            if(count($keys) > 0) {
                $keys_str = implode(' and ', $keys);
            }

            $rs = $somfa->execute("select 
                                    a.user_company_id as user_company_id,
                                    a.send_mail_id as send_mail_id,
                                    a.personal_id as personal_id,
                                    a.subject as subject,
                                    a.body as body,
                                    a.send_each_flg as send_each_flg,
                                    a.send_date as send_date,
                                    a.status_kb as status_kb,
                                    (
                                        select min(mail) from tbt_send_mail_history 
                                        where 
                                        a.user_company_id=user_company_id 
                                        and a.send_mail_id = send_mail_id 
                                        and mail_kb = '" . MAILKB_TO . "' and del_flg = '" . DB_ENABLE . "'
                                        group by send_mail_id
                                    ) as mail,
                                    (
                                        select count(*) from tbt_send_mail_history 
                                        where 
                                        a.user_company_id=user_company_id 
                                        and a.send_mail_id = send_mail_id 
                                        and mail_kb = '" . MAILKB_TO . "' and del_flg = '" . DB_ENABLE . "'
                                    ) as to_mail_count
                                from 
                                tbt_send_mail a
                                where $keys_str
                                order by a.send_date desc",
                                $vals);

            $vo->send_mail_history_list = $rs;

            return R_SUCCESS;
        }
        catch (xbpwException $e) {
            throw $e;
        }
        catch (Exception $e) {
            throw new xbpwException(E_USER_ERROR, sprintf(F_NM_01, $e->getMessage()));
        }
    }

    /**
     * メールの送信履歴取得
     *
     * @access public
     * @param  $vo
     * @return
     */
    public function getSendMailHistory(& $vo){
        //--------------------------------------------------------------
        //呼出ログ出力
        //--------------------------------------------------------------
        debugLog('called ' . __METHOD__, __CLASS__, __FILE__, __LINE__);

        //--------------------------------------------------------------
        //引数存在チェック
        //--------------------------------------------------------------
        if (isNULL($vo)) {
            throw new xbpwException(E_USER_ERROR, sprintf(F_NM_02, 'vo'));
        }

        //--------------------------------------------------------------
        //引数パラメータ必須チェック
        //--------------------------------------------------------------
        if (!$this->assert(array('user_company_id', 'send_mail_id'), & $vo)) {
            throw new xbpwException(E_USER_ERROR, sprintf(F_NM_03, 'vo'));
        }

        try {
            //--------------------------------------------------------------
            //テーブル情報の取得
            //--------------------------------------------------------------
            $somfa = $this->getDatabase();

            $rs = $somfa->select('tbt_send_mail',
                                     '*',
                                     'user_company_id = ? and send_mail_id = ? and del_flg = ?',
                                     array($vo->user_company_id, $vo->send_mail_id, DB_ENABLE)
                                    );

            $vo->send_mail_history = $rs[0];
            $history_rs = $somfa->select('tbt_send_mail_history',
                                         '*',
                                         'user_company_id = ? and send_mail_id = ? and del_flg = ?',
                                         array($vo->user_company_id, $vo->send_mail_id, DB_ENABLE),
                                         'mail_kb, mail'
                                    );

            $mail_info_list = array();

            $to_mail_list = array();
            $cc_mail_list = array();
            $bcc_mail_list = array();
            foreach($history_rs as $item){
                $mail = $item['mail'];

                switch($item['mail_kb']) {
                    case MAILKB_TO :
                        $to_mail_list[] = $mail;
                        break;
                    case MAILKB_CC :
                        $cc_mail_list[] = $mail;
                        break;
                    case MAILKB_BCC :
                        $bcc_mail_list[] = $mail;
                        break;
                }

                //----------------------------------------------------------
                //メールアドレスの形式
                //  1.demo@exbridge.jp
                //  2. 山田　デモ太郎 <demo@exbridge.jp>
                //----------------------------------------------------------
                //パターン
                $pattern = '/^\s*([^<>]*)\s*<([^<>]*)>$/i';
                preg_match($pattern, $mail, $matches);        

                if(!isNULL($matches[2])) {
                    $mail_info['name'] = $matches[1];
                    $mail_info['mail'] = $matches[2];
                }
                else{
                    $mail_info['name'] = $mail;
                    $mail_info['mail'] = $mail;
                }
                $vo->send_mail_history['mail_info_list'][] = $mail_info;
            }
            $vo->send_mail_history['to_mail_list'] = $to_mail_list;
            $vo->send_mail_history['cc_mail_list'] = $cc_mail_list;
            $vo->send_mail_history['bcc_mail_list'] = $bcc_mail_list;

            return R_SUCCESS;
        }
        catch (xbpwException $e) {
            throw $e;
        }
        catch (Exception $e) {
            throw new xbpwException(E_USER_ERROR, sprintf(F_NM_01, $e->getMessage()));
        }
    }

    /**
     * メールの登録・更新
     *
     * @access public
     * @param  $vo
     * @return
     */
    public function saveSendMail(& $vo){

        //--------------------------------------------------------------
        //呼出ログ出力
        //--------------------------------------------------------------
        debugLog('called ' . __METHOD__, __CLASS__, __FILE__, __LINE__);

        //--------------------------------------------------------------
        //引数存在チェック
        //--------------------------------------------------------------
        if (isNULL($vo)) {
            throw new xbpwException(E_USER_ERROR, sprintf(F_NM_02, 'vo'));
        }

        //--------------------------------------------------------------
        //引数パラメータ必須チェック
        //--------------------------------------------------------------
        if (!$this->assert(array('user_company_id'), & $vo)) {
            throw new xbpwException(E_USER_ERROR, sprintf(F_NM_03, 'vo'));
        }

        try {
            //--------------------------------------------------------------
            //テーブル情報の取得
            //--------------------------------------------------------------
            $somfa = $this->getDatabase();

            $somfa->begin();
            //--------------------------------------------------------------
            //採番
            //--------------------------------------------------------------
            if (isNULL($vo->send_mail_id)) {

                //テーブルロック
                $rs_lock = $somfa->select('tbt_send_mail',
                                          '*',
                                          'user_company_id = ? for update',
                                          $vo->user_company_id);

                $rs = $somfa->select('tbt_send_mail',
                                     'case when max(send_mail_id) is null then 1 else max(send_mail_id) + 1 end as send_mail_id',
                                     'user_company_id=?',
                                     array($vo->user_company_id));

                $vo->send_mail_id = $rs[0]['send_mail_id'];
            }

            $old = $somfa->retrieveByPK('tbt_send_mail',
                                        array('user_company_id' => $vo->user_company_id,
                                              'send_mail_id'    => $vo->send_mail_id));

            //--------------------------------------------------------------
            //登録用情報生成
            //--------------------------------------------------------------
            $update_time = getTimestamp();

            $data = array();
            $data['user_company_id'] = $vo->user_company_id;
            $data['send_mail_id']    = $vo->send_mail_id;
            $data['personal_id']     = $vo->personal_id;
            $data['subject']         = $vo->subject;
            $data['body']            = $vo->body;
            $data['send_each_flg']   = $vo->send_each_flg;
            $data['send_date']       = $vo->send_date;
            $data['status_kb']       = $vo->status_kb;
            $data['del_flg']         = DB_ENABLE;
            $data['add_date']        = is_array($old)?$old['add_date']:$update_time;
            $data['add_pgid']        = is_array($old)?$old['add_pgid']:__METHOD__;
            $data['add_user_cd']     = is_array($old)?$old['add_user_cd']:$vo->logon_user_cd;
            $data['upd_date']        = $update_time;
            $data['upd_pgid']        = __METHOD__;
            $data['upd_user_cd']     = $vo->logon_user_cd;

            //--------------------------------------------------------------
            //登録／更新実行
            //--------------------------------------------------------------
            $result = $somfa->save('tbt_send_mail', $data);

            //--------------------------------------------------------------
            //履歴の削除
            //--------------------------------------------------------------
            if ($result == R_SUCCESS_INSERT || $result == R_SUCCESS_UPDATE) {
                $del_data = array();
                $del_data['user_company_id'] = $vo->user_company_id;
                $del_data['send_mail_id']    = $vo->send_mail_id;
                //--------------------------------------------------------------
                //更新実行
                //--------------------------------------------------------------
                $result = $somfa->delete('tbt_send_mail_history', $del_data);
            }
            else {
                return R_ERROR;
            }
            if ($result == R_SUCCESS_INSERT || $result == R_SUCCESS_UPDATE || $result == R_SUCCESS_DESTOROY) {
                //----------------------------------------------------
                //宛先
                //----------------------------------------------------
                foreach ($vo->to_mail_list as $to_mail) {
                    if(isNULL($to_mail)){
                        continue;
                    }
                    $history_vo = $this->getValueObject();

                    $history_vo->user_company_id = $vo->user_company_id;
                    $history_vo->send_mail_id    = $vo->send_mail_id;
                    $history_vo->mail_kb         = MAILKB_TO;
                    $history_vo->mail            = $to_mail;

                    $result =$this->saveSendMailHistory($history_vo);
                    if ($result != R_SUCCESS_INSERT && $result != R_SUCCESS_UPDATE) {
                        return R_ERROR;
                    }
                }
                //----------------------------------------------------
                //CC
                //----------------------------------------------------
                foreach ($vo->cc_mail_list as $cc_mail) {
                    if(isNULL($cc_mail)){
                        continue;
                    }
                    $history_vo = $this->getValueObject();

                    $history_vo->user_company_id = $vo->user_company_id;
                    $history_vo->send_mail_id    = $vo->send_mail_id;
                    $history_vo->mail_kb         = MAILKB_CC;
                    $history_vo->mail            = $cc_mail;

                    $result =$this->saveSendMailHistory($history_vo);
                    if ($result != R_SUCCESS_INSERT && $result != R_SUCCESS_UPDATE) {
                        return R_ERROR;
                    }
                }
                //----------------------------------------------------
                //BCC
                //----------------------------------------------------
                foreach ($vo->bcc_mail_list as $bcc_mail) {
                    if(isNULL($bcc_mail)){
                        continue;
                    }
                    $history_vo = $this->getValueObject();

                    $history_vo->user_company_id = $vo->user_company_id;
                    $history_vo->send_mail_id    = $vo->send_mail_id;
                    $history_vo->mail_kb         = MAILKB_BCC;
                    $history_vo->mail            = $bcc_mail;

                    $result =$this->saveSendMailHistory($history_vo);
                    if ($result != R_SUCCESS_INSERT && $result != R_SUCCESS_UPDATE) {
                        return R_ERROR;
                    }
                }
                $somfa->commit();
            }

            return $result;
        }
        catch (xbpwException $e) {
            throw $e;
        }
        catch (Exception $e) {
            throw new xbpwException(E_USER_ERROR, sprintf(F_NM_01, $e->getMessage()));
        }
    }

    /**
     * 送信メール履歴の登録
     *
     * @access public
     * @param  $vo
     * @return
     */
    public function saveSendMailHistory(& $vo){

        //--------------------------------------------------------------
        //呼出ログ出力
        //--------------------------------------------------------------
        debugLog('called ' . __METHOD__, __CLASS__, __FILE__, __LINE__);

        //--------------------------------------------------------------
        //引数存在チェック
        //--------------------------------------------------------------
        if (isNULL($vo)) {
            throw new xbpwException(E_USER_ERROR, sprintf(F_NM_02, 'vo'));
        }

        //--------------------------------------------------------------
        //引数パラメータ必須チェック
        //--------------------------------------------------------------
        if (!$this->assert(array('user_company_id', 'send_mail_id'), & $vo)) {
            throw new xbpwException(E_USER_ERROR, sprintf(F_NM_03, 'vo'));
        }

        try {
            //--------------------------------------------------------------
            //テーブル情報の取得
            //--------------------------------------------------------------
            $somfa = $this->getDatabase();

            $somfa->begin();

            //--------------------------------------------------------------
            //採番
            //--------------------------------------------------------------
            //テーブルロック
            $rs_lock = $somfa->select('tbt_send_mail_history',
                                      '*',
                                      'user_company_id = ? for update',
                                      $vo->user_company_id);

            $rs = $somfa->select('tbt_send_mail_history',
                                 'case when max(send_mail_history_id) is null then 1 else max(send_mail_history_id) + 1 end as send_mail_history_id',
                                 'user_company_id=?',
                                 array($vo->user_company_id));

            $vo->send_mail_history_id = $rs[0]['send_mail_history_id'];

            //--------------------------------------------------------------
            //登録用情報生成
            //--------------------------------------------------------------
            $update_time = getTimestamp();

            $data = array();
            $data['user_company_id']        = $vo->user_company_id;
            $data['send_mail_history_id']   = $vo->send_mail_history_id;
            $data['send_mail_id']           = $vo->send_mail_id;
            $data['mail_kb']                = $vo->mail_kb;
            $data['mail']                   = $vo->mail;
            $data['group_id']               = $vo->group_id;
            $data['personal_id']            = $vo->personal_id;

            $data['del_flg']         = DB_ENABLE;
            $data['add_date']        = $update_time;
            $data['add_pgid']        = __METHOD__;
            $data['add_user_cd']     = $vo->logon_user_cd;
            $data['upd_date']        = $update_time;
            $data['upd_pgid']        = __METHOD__;
            $data['upd_user_cd']     = $vo->logon_user_cd;

            //--------------------------------------------------------------
            //登録／更新実行
            //--------------------------------------------------------------
            $result = $somfa->save('tbt_send_mail_history', $data);

            if ($result == R_SUCCESS_INSERT || $result == R_SUCCESS_UPDATE) {
                $somfa->commit();
            }

            return $result;
        }
        catch (xbpwException $e) {
            throw $e;
        }
        catch (Exception $e) {
            throw new xbpwException(E_USER_ERROR, sprintf(F_NM_01, $e->getMessage()));
        }
    }

    /**
     * 送信メールのステータス更新
     *
     * @access public
     * @param  $vo
     * @return
     */
    public function updateSendMailStatus(& $vo){

        //--------------------------------------------------------------
        //呼出ログ出力
        //--------------------------------------------------------------
        debugLog('called ' . __METHOD__, __CLASS__, __FILE__, __LINE__);

        //--------------------------------------------------------------
        //引数存在チェック
        //--------------------------------------------------------------
        if (isNULL($vo)) {
            throw new xbpwException(E_USER_ERROR, sprintf(F_NM_02, 'vo'));
        }

        //--------------------------------------------------------------
        //引数パラメータ必須チェック
        //--------------------------------------------------------------
        if (!$this->assert(array('user_company_id', 'send_mail_id'), & $vo)) {
            throw new xbpwException(E_USER_ERROR, sprintf(F_NM_03, 'vo'));
        }

        try {
            //--------------------------------------------------------------
            //テーブル情報の取得
            //--------------------------------------------------------------
            $somfa = $this->getDatabase();

            $somfa->begin();

            //--------------------------------------------------------------
            //登録用情報生成
            //--------------------------------------------------------------
            $update_time = getTimestamp();

            $data = array();
            $data['user_company_id'] = $vo->user_company_id;
            $data['send_mail_id']    = $vo->send_mail_id;
            $data['status_kb']       = $vo->status_kb;
            $data['del_flg']         = DB_ENABLE;
            $data['add_user_cd']     = $vo->logon_user_cd;
            $data['upd_date']        = $update_time;
            $data['upd_pgid']        = __METHOD__;
            $data['upd_user_cd']     = $vo->logon_user_cd;

            //--------------------------------------------------------------
            //登録／更新実行
            //--------------------------------------------------------------
            $result = $somfa->save('tbt_send_mail', $data);
            if ($result == R_SUCCESS_INSERT || $result == R_SUCCESS_UPDATE) {
                $somfa->commit();
            }

            return $result;
        }
        catch (xbpwException $e) {
            throw $e;
        }
        catch (Exception $e) {
            throw new xbpwException(E_USER_ERROR, sprintf(F_NM_01, $e->getMessage()));
        }
    }

}
?>
