<?php
/**
 * sendMailService class.
 *
 * @author
 * @copyright 2008- EXBRIDGE,Inc. All Rights Reserved.
 * @link      http://exbridge.jp/
 */
class sendMailService extends xbpwService {

    /**
     * メール送信
     *
     * @access public
     * @param  $vo->to_address_list
     * @param  $vo->title
     * @param  $vo->body
     * @param  $vo->*
     * @return integer
     */
    public function send(& $vo) {
        debugLog('called ' . __METHOD__, __CLASS__, __FILE__, __LINE__);

        //--------------------------------------------------------------
        //引数存在チェック
        //--------------------------------------------------------------
        if (isNULL($vo)) {
            throw new xbpwException(E_USER_ERROR, sprintf(F_NM_02, 'vo'));
        }

        //--------------------------------------------------------------
        //引数パラメータ必須チェック
        //--------------------------------------------------------------
        if (!$this->assert(array('to_mail_info_list', 'from_mail_info', 'subject', 'body'), & $vo)) {
            throw new xbpwException(E_USER_ERROR, sprintf(F_NM_03, 'vo'));
        }

        //--------------------------------------------------------------
        //somfaオブジェクト取得
        //--------------------------------------------------------------
        $somfa = $this->getDatabase();

        try {

            $mail = new xbpwMail(SMTP_HOST, SMTP_PORT);

            //--------------------------------------
            //送信者設定
            //--------------------------------------
            $mail->setSender($vo->from_mail_info);

            //--------------------------------------
            //受信者設定
            //--------------------------------------
            foreach ($vo->to_mail_info_list as $to_mail_info) {
                if(!isNULL($to_mail_info)){
                    $mail->addTo($to_mail_info);
                }
            }
            //--------------------------------------
            //CC設定
            //--------------------------------------
            foreach ($vo->cc_mail_info_list as $cc_mail_info) {
                if(!isNULL($cc_mail_info)){
                    $mail->addCC($cc_mail_info);
                }
            }

            //--------------------------------------
            //BCC設定
            //--------------------------------------
            foreach ($vo->bcc_mail_info_list as $bcc_mail_info) {
                if(!isNULL($bcc_mail_info)){
                    $mail->addBCC($bcc_mail_info);
                }
            }

            //--------------------------------------
            //件名設定
            //--------------------------------------
            $mail->setSubject($vo->subject);

            //--------------------------------------
            //本文設定 @todo 文頭に改行コードが必要。。。
            //--------------------------------------
            $mail->setBody("\n" . $vo->body);

            //--------------------------------------
            //添付ファイル設定
            //--------------------------------------
            foreach ($vo->file_list as $file) {
                $mail->addFile($path . '/' . $file, $file);
            }

            //--------------------------------------
            //メール送信
            //--------------------------------------
            $result_info = $mail->send();

            return $result_info;
        }
        catch (xbpwException $e) {
            throw $e;
        }
        catch (Exception $e) {
            throw new xbpwException(E_USER_ERROR, sprintf(F_NM_01, $e->getMessage()));
        }
    }

    /**
     * メール送信 指定の宛先一人づつに送信する。
     *
     * @access public
     * @param  $vo->to_address_list
     * @param  $vo->title
     * @param  $vo->body
     * @param  $vo->*
     * @return integer
     */
    public function sendEach(& $vo) {

        debugLog('called ' . __METHOD__, __CLASS__, __FILE__, __LINE__);

        //--------------------------------------------------------------
        //引数存在チェック
        //--------------------------------------------------------------
        if (isNULL($vo)) {
            throw new xbpwException(E_USER_ERROR, sprintf(F_NM_02, 'vo'));
        }

        //--------------------------------------------------------------
        //引数パラメータ必須チェック
        //--------------------------------------------------------------
        if (!$this->assert(array('to_mail_info_list', 'from_mail_info', 'subject', 'body'), & $vo)) {
            throw new xbpwException(E_USER_ERROR, sprintf(F_NM_03, 'vo'));
        }

        //--------------------------------------------------------------
        //somfaオブジェクト取得
        //--------------------------------------------------------------
        $somfa = $this->getDatabase();

        try {

            foreach ($vo->to_mail_info_list as $to_mail_info) {
                $mail = new xbpwMail(SMTP_HOST, SMTP_PORT);

                //--------------------------------------
                //受信者設定
                //--------------------------------------
                $mail->addTo($to_mail_info);

                //--------------------------------------
                //送信者設定
                //--------------------------------------
                $mail->setSender($vo->from_mail_info);

                //--------------------------------------
                //件名設定
                //--------------------------------------
                $mail->setSubject($vo->subject);

                //--------------------------------------
                //本文設定 @todo 文頭に改行コードが必要。。。
                //--------------------------------------
                $mail->setBody("\n" . $vo->body);

                //--------------------------------------
                //添付ファイル設定
                //--------------------------------------
                foreach ($vo->file_list as $file) {
                    $mail->addFile($path . '/' . $file, $file);
                }

                //--------------------------------------
                //メール送信
                //--------------------------------------
                $results = $mail->send();

                if(!$results){
                    return $results;
                }
                //一秒待ち
                sleep(1);
            }
            return $results;
        }
        catch (xbpwException $e) {
            throw $e;
        }
        catch (Exception $e) {
            throw new xbpwException(E_USER_ERROR, sprintf(F_NM_01, $e->getMessage()));
        }
    }

}
?>
