<?php 
//==================================================================
//データ取得部分
//引数
//$m['year_id'] : リストボックス年ＩＤ
//$m['month_id']: リストボックス月ＩＤ
//$m['day_id']  : リストボックス日ＩＤ
//$m['min_year']  : 最小年
//$m['max_year']  : 最大年
//$m['disabled_year']  : true  false （デフォルト）
//$m['disabled_month'] : true  false （デフォルト）
//$m['disabled_day']   : true  false （デフォルト）
//$m['year'] : 年
//$m['month']: 月
//$m['day']  : 日
//$m['null']    : true - 空白有（デフォルト） false - 空白無
//==================================================================
if (!isset($m['null'])){
    $m['null'] = false;
}

$year_id        = $m['year_id'];
$month_id       = $m['month_id'];
$day_id         = $m['day_id'];

$calendar_id    = 'calendar_' . $year_id;

$year       = $m['year'];
$month      = $m['month'];
$day        = $m['day'];
$min_year   = $m['min_year'];
$max_year   = $m['max_year'];
$simbiFlag  = $m['simebi'];
if(true != $simbiFlag){
    $simbiFlag = "false";
}

$now_year = date('Y', time());

//開始年が指定されていない場合、現在年-1を開始年とする
$startYear = isNULL($min_year)?$now_year - MIN_DISP_YEAR:$now_year - $min_year;

//終了年が指定されていない場合、現在年+2を終了年とする
$endYear = isNULL($max_year)?$now_year + MAX_DISP_YEAR:$now_year + $max_year;

$disabled_year       = $m['disabled_year'];
$disabled_month      = $m['disabled_month'];
$disabled_day        = $m['disabled_day'];

if( !$m['null'] && isNULL($year)){
    $year = $now_year;
}

//年
if( $disabled_year ){
    echo input_tag( $year_id, $year, array('editable'=>false, 'class'=>'x60'));
    echo CL_YEAR;
}
else{
    echo xb_year_select_tag ( $year_id, array( 'class'=>'selectY x60', 'tarMonthObj'=>$month_id, 'disabled'=>$disabled_year), $year, $m['null'], $min_year, $max_year);
    echo CL_YEAR;
}
//月
if( $disabled_month ){
    echo input_tag( $month_id, $month, array('editable'=>false, 'class'=>'x40') );
    echo CL_MONTH;
}
else{
    echo xb_month_select_tag( $month_id, array( 'class'=>'selectM2 x40', 'tarDayObj'=>$day_id), $month, $m['null']);
    echo CL_MONTH;
}
//日
if( $disabled_day ){
    echo input_tag( $day_id, $day, array('editable'=>false, 'class'=>'x40') );
    echo CL_DAY;
}
else{
    echo xb_day_select_tag  ( $day_id, array('class'=>'x40'), $day, $m['null'], $simbiFlag);
    echo CL_DAY;

}
?>

<?php echo button_tag($calendar_id, '', array('class'=>'calen'));?>


<script type="text/javascript" charset="utf-8">
           j$(function()
            {
                // initialise the "Select date" link
                j$('#<?php echo $calendar_id ?>')
                    .datePicker(
                        // associate the link with a date picker
                        {
                            createButton:false,
                            startDate:'01/01/<?php echo $startYear ?>',
                            endDate:'31/12/<?php echo $endYear ?>'
                        }
                    ).bind(
                        // when the link is clicked display the date picker
                        'click',
                        function()
                        {
                            //選択値設定
                            var d = new Date(
                                        j$('#<?php echo $year_id ?>').val(),
                                        j$('#<?php echo $month_id ?>').val()-1,
                                        j$('#<?php echo $day_id ?>').val()
                                    );
                            j$(this).dpSetSelected(d.asString());
                            j$(this).dpDisplay();
                            return false;
                        }
                    ).bind(
                        // when a date is selected update the SELECTs
                        'dateSelected',
                        function(e, selectedDate, j$td, state)
                        {
                            updateSelects(selectedDate);
                        }
                    ).bind(
                        'dpClosed',
                        function(e, selected)
                        {
                            updateSelects(selected[0]);
                        }
                    );

                var updateSelects = function (selectedDate)
                {
                    selectedDate = new Date(selectedDate);
                    var temp    = new Date();
                    var day     = selectedDate.getDate();
                    var month   = selectedDate.getMonth() + 1;
                    var year    = selectedDate.getFullYear();
                    j$('#<?php echo $day_id ?>').val(day);
                    j$('#<?php echo $month_id ?>').val(month);
                    j$('#<?php echo $year_id ?>').val(year);

                    //指定日がリストボックスに存在しない場合
                    if(j$('#<?php echo $year_id ?>').val() != year){
                        j$('#<?php echo $day_id ?>').val('');
                        j$('#<?php echo $month_id ?>').val('');
                        j$('#<?php echo $year_id ?>').val('');
                    }
                    //日のリストを再作成
                    create<?php echo $calendar_id ?>DateListBox();
                }
                //年と月のonChangeイベントで日のリストボックスを再作成
                j$('#<?php echo $year_id ?>, #<?php echo $month_id ?>')
                    .bind(
                        'change',
                        function()
                        {
                            create<?php echo $calendar_id ?>DateListBox();
                        }
                    );
                // listen for when the selects are changed and update the picker
                j$('#<?php echo $day_id ?>, #<?php echo $month_id ?>, #<?php echo $year_id ?>')
                    .bind(
                        'change',
                        function()
                        {
                            var d = new Date(
                                        j$('#<?php echo $year_id ?>').val(),
                                        j$('#<?php echo $month_id ?>').val()-1,
                                        j$('#<?php echo $day_id ?>').val()
                                    );
                            j$('#<?php echo $calendar_id ?>').dpSetSelected(d.asString());
                        }
                    );

                // and update the datePicker to reflect it...
                j$('#<?php echo $year_id ?>').trigger('change');
            });

Date.dayNames = ['日曜日', '月曜日', '火曜日', '水曜日', '木曜日', '金曜日', '土曜日'];
Date.abbrDayNames = ['日', '月', '火', '水', '木', '金', '土'];
Date.monthNames = ['1月', '2月', '3月', '4月', '5月', '6月', '7月', '8月', '9月', '10月', '11月', '12月'];
Date.abbrMonthNames = ['1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'];

function create<?php echo $calendar_id ?>DateListBox(){
    var year = j$('#<?php echo $year_id ?>').val();
    var month = j$('#<?php echo $month_id ?>').val();
    //日の値を一時的に保持
    var tmp_day = j$('#<?php echo $day_id ?>').val();

    //日のリストボックスを空にする
    j$('#<?php echo $day_id ?>').empty();

    var date = new Date(year, month, 0);
    dayCnt = date.getDate();
    var option_arr = new Array();
    <?php if($m['null']): ?>
        option_arr[0] = "<option value=''></option>";
    <?php endif;?>
    for(var i=1; i<=dayCnt; i++)
    {
        var day = i;
        if(i<10)
        {
            day = '0'+ i;
        }
        option_arr[i] = "<option value='" + day + "'>" + day + "</option>";
    }

    var simebi = <?php echo $simbiFlag ?>;
    if(true == simebi){
        option_arr[i] = "<option value='" + 99 + "'>" + 99 + "</option>";
    }

    j$('#<?php echo $day_id ?>').append(option_arr.join('\n'));
    j$('#<?php echo $day_id ?>').val(tmp_day);
}
</script>

