<?php
/*
 * This file is part of the pettiwork package.
 * (c) 2007-2008 Exbridge,inc. <info@exbridge.jp>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

/**
 * Project: pettiwork: the PHP lightweight web framework
 * File:    function.errorHandler.php
 *
 * @link http://exbridge.jp/
 * @author S.Tajima <tajima@exbridge.jp>
 * @version svn:$Id: function.errorHandler.php 3 2008-07-01 10:08:07Z tshiro $
 * @copyright 2007-2008 Exbridge,Inc.
 */

/**
 *値    定数                注記    説明 
 * 1    E_ERROR                     スクリプトの実行は中断されます。   重大な実行時エラー。これは、メモリ確保に関する問題のように復帰で きないエラーを示します。
 * 2    E_WARNING                   スクリプトの実行は中断さ れません。実行時の警告 (致命的なエラーではない)。
 * 4    E_PARSE                     コンパイル時のパースエラー。パースエラーはパーサでのみ生成されま す。
 * 8    E_NOTICE                    実行時の警告。エラーを発しうる状況に遭遇したことを示す。 ただし通常のスクリプト実行の場合にもこの警告を発することがありうる。
 * 16   E_CORE_ERROR        PHP4    PHPの初期始動時点での致命的なエラー。E_ERRORに 似ているがPHPのコアによって発行される点が違う。
 * 32   E_CORE_WARNING      PHP4   （致命的ではない）警告。PHPの初期始動時に発生する。 E_WARNINGに似ているがPHPのコアによって発行される 点が違う。
 * 64   E_COMPILE_ERROR     PHP4    コンパイル時の致命的なエラー。E_ERRORに 似ているがZendスクリプティングエンジンによって発行される点が違う。
 * 128  E_COMPILE_WARNING   PHP4    コンパイル時の警告（致命的ではない）。E_WARNINGに 似ているがZendスクリプティングエンジンによって発行される点が違う。
 * 256  E_USER_ERROR        PHP4    ユーザーによって発行されるエラーメッセージ。E_ERROR に似ているがPHPコード上でtrigger_error()関数を 使用した場合に発行される点が違う。
 * 512  E_USER_WARNING      PHP4    ユーザーによって発行される警告メッセージ。E_WARNING に似ているがPHPコード上でtrigger_error()関数を 使用した場合に発行される点が違う。
 * 1024 E_USER_NOTICE       PHP4    ユーザーによって発行される注意メッセージ。E_NOTICEに に似ているがPHPコード上でtrigger_error()関数を 使用した場合に発行される点が違う。
 * 2048 E_STRICT            PHP5    実行時の注意。コードの相互運用性や互換性を維持するために PHP がコードの変更を提案する。
 * 4096 E_RECOVERABLE_ERROR PHP5.2  キャッチできる致命的なエラー。危険なエラーが発生したが、 エンジンが不安定な状態になるほどではないことを表す。ユーザ定義のハンドラでエラーがキャッチされなかった場合 (set_error_handler() も参照ください) は、 E_ERROR として異常終了する。
 * 8191 E_ALL
 */
set_error_handler("errorHandler");

function errorHandler ($errno, $errstr, $errfile, $errline)
{
    $err_kbn;
    switch ($errno) {
    case E_ERROR:
        $err_kbn = 'Fatal';
        break;
    case E_WARNING:
        $err_kbn = 'Warning';
        //break;
        return;
    case E_PARSE:
        $err_kbn = 'Parse Error';
        break;
    case E_NOTICE:
        return;
    case E_CORE_ERROR:
        $err_kbn = 'Core Error';
        break;
    case E_CORE_WARNING:
        $err_kbn = 'Core Warning';
        break;
    case E_COMPILE_ERROR:
        $err_kbn = 'Compile Error';
        break;
    case E_COMPILE_WARNING:
        $err_kbn = 'Compile Error';
        break;
    case E_USER_ERROR:
        $err_kbn = 'Fatal Application';
        break;
    case E_USER_WARNING:
        $err_kbn = 'Warning Application';
        break;
    case E_USER_NOTICE:
        $err_kbn = 'Notice Application';
        //break;
        return;
    case E_STRICT:
        //$err_kbn = 'Strict';
        //break;
        return;
    case E_RECOVERABLE_ERROR:
        //$err_kbn = 'Rcoverable';
        //break;
        return;
    }
    if (PW_EXCEPTION_DISABLED) {
        echo "<b>$err_kbn</b>: $errstr in <b>$errfile</b> on line <b>$errline</b><br />";
        //echo "error_reporting:".error_reporting();
        //exit;
    }
    else {
        throw new xbpwException($errno, $errstr);
    }
}

function &_fatal_error_handler(& $buffer)
{
    //if (preg_match('/<b>(Fatal error|Warning)<\/b>: +(.+) in <b>(.+)<\/b> on line <b>(\d+)<\/b><br \/>/', $buffer, $matches)) {
    if (preg_match('/<b>(Parse Error|Fatal|Warning|Fatal Application|Warning Application)<\/b>: +(.+) in <b>(.+)<\/b> on line <b>(\d+)<\/b><br \/>/s', $buffer, $matches)) {
        errorLog($matches[2], '', $matches[3], $matches[4]);
        //if (PW_ERROR_MAIL_SENDER) {
        //    if (function_exists('errorMailSender')){//カスタマイズメールセンダーが存在する場合のみ
        //        errorMailSender(sprintf("%s (%s)(%s)", $matches[2], $matches[3], $matches[4]));
        //    }
        //}
        if (function_exists('output_html_error_infomation')) {
            $result = output_html_error_infomation($matches[1], $matches[2], $matches[3], $matches[4]);
            if (is_string($result)) return $result;
        }
    }
    return $buffer;
}

function output_html_error_infomation($errLevel, $str, $file, $line)
{
    $html   = array();
    $html[] = '<html>';
    output_html_error_header($html);
    $html[] = '<body>';
    $html[] = '<center>';
    $html[] = '<div id=main>';
    $html[] = '  <h1>[pettiwork Exception]</h1>';
    $html[] = '  <p class=error>Error Message : ' . $str . '</p>';
    $html[] = '  <h2 id=message>';
    $html[] = '  <B>Code</B><Br>' . $errLevel . '<Br><Br>';
    $html[] = '  <B>Line</B><Br>' . $line . '<Br><Br>';
    $html[] = '  <B>File</B><Br>' . $file . '<Br><Br>';
    $html[] = '  </h2>';
    $html[] = '  <p id=footer>';
    $html[] = '    pettiwork - php ' . PHP_VERSION . '<br/>';
    $html[] = '  </p>';
    $html[] = '</div>';
    $html[] = '</center>';
    $html[] = '</body>';
    $html[] = '</html>';
    return implode("\n", $html);
}

function output_error($e)
{
    ob_end_clean ();
    $html   = array();
    $html[] = '<html>';
    output_html_error_header($html);
    $html[] = '<body>';
    $html[] = '<center>';
    $html[] = '<div id=main>';
    $html[] = '  <h1>[pettiwork Exception]</h1>';
    $html[] = '  <p class=error>Error Message : ' . $e->getErrorMessage() . '</p>';
    $html[] = '  <h2 id=message>';
    $html[] = '  <pre>' . $e . '</pre>';
    $html[] = '  </h2>';
    $html[] = '  <p id=footer>';
    $html[] = '    pettiwork - php ' . PHP_VERSION . '<br/>';
    $html[] = '  </p>';
    $html[] = '</div>';
    $html[] = '</center>';
    $html[] = '</body>';
    $html[] = '</html>';
    return implode("\n", $html);
}

function output_html_error_header(& $html)
{
    $html[] = "<head>";
    $html[] = "<meta http-equiv='Content-Type' content='text/html; charset=" . PW_HTML_META_CHARSET . "'/>";
    $html[] = "<title>pettiwork exception</title>";
    $html[] = "<style>";
    $html[] = "  body { margin: 0; padding: 20px; margin-top: 20px; background-color: #eee }";
    $html[] = "  body, td, th { font: 11px Verdana, Arial, sans-serif; color: #333 }";
    $html[] = "  h1 { margin: 0 0 0 10px; padding: 10px 0 10px 0; font-weight: bold; font-size: 120% }";
    $html[] = "  h2 { margin: 0; padding: 5px 0; font-size: 110% }";
    $html[] = "  p.error { padding: 10px; background-color: #f00; font-weight: bold; text-align: center; -moz-border-radius: 10px; }";
    $html[] = "  #main { padding: 20px; padding-left: 70px; border: 1px solid #ddd; background-color: #fff; text-align:left; -moz-border-radius: 10px; min-width: 13em; max-width: 52em }";
    $html[] = "  #message { padding: 10px; margin-bottom: 10px; background-color: #eee; -moz-border-radius: 10px }";
    $html[] = "  </style>";
    $html[] = "</head>";
}
