<?php
/*
 * This file is part of the pettiwork package.
 * (c) 2007-2008 Exbridge,inc. <info@exbridge.jp>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

/**
 * Project: pettiwork: the PHP lightweight web framework
 * File:    xbpwLogger.php
 *
 * @link http://exbridge.jp/
 * @author S.Tajima <tajima@exbridge.jp>
 * @version svn:$Id: function.logger.php 3 2008-07-01 10:08:07Z tshiro $
 * @copyright 2007-2008 Exbridge,Inc.
 */

/**
 * access logging
 */
function accessLog($message, $class, $file, $line)
{
    if (LOGGER_LEVEL <= 2) {//INFO
        pringLog(LOGGER_ACEESS, constructLogLine($message, $class, $file, $line, 'INFO'));
    }
}

/**
 * debug logging
 */
function debugLog($message, $class, $file, $line)
{
    if (LOGGER_LEVEL <= 1) {//DEBUG
        pringLog(LOGGER, constructLogLine($message, $class, $file, $line, 'DEBUG'));
    }
}

/**
 * info logging
 */
function traceLog($message, $class, $file, $line)
{
    if (LOGGER_LEVEL <= 2) {//INFO
        pringLog(LOGGER, constructLogLine($message, $class, $file, $line, 'INFO'));
    }
}

/**
 * warn logging
 */
function warnLog($message, $class, $file, $line)
{
    if (LOGGER_LEVEL <= 3) {//WARN
        pringLog(LOGGER, constructLogLine($message, $class, $file, $line, 'WARN'));
    }
}

/**
 * error logging
 */
function errorLog($message, $class, $file, $line)
{
    if (LOGGER_LEVEL <= 4) {//ERROR
        pringLog(LOGGER, constructLogLine($message, $class, $file, $line, 'ERROR'));
    }
}

/**
 * fatal logging
 */
function fatalLog($message, $class, $file, $line)
{
    if (LOGGER_LEVEL <= 5) {//FATAL
        pringLog(LOGGER, constructLogLine($message, $class, $file, $line, 'FATAL'));
    }
}

/**
 * logging formatter
 */
function constructLogLine($message, $class, $file, $line, $level)
{
    $ip = getEnv('REMOTE_ADDR');
    $ip = ($ip=='')?'none':"$ip";
    $date = date('Y/m/d H:i:s', time());
    if (is_object($message)||is_array($message)) {
        $message = var_export($message, true);
    }
    return "[$date][$level][$ip][$line][$class]$message";
}

function pringLog($file, $str)
{
    $path = LOGGER_DIR . '/' . $file;
    $fp = fopen($path, "a+");
    fwrite($fp, $str . "\n");
    fclose($fp);
    rotationLog($path);
}

function rotationLog($path)
{
    $dirname = dirname($path);
    $basename = basename($path);

    // ファイルが最大サイズを超えていないかチェック
    if (filesize($path) > LOGGER_MAX_SIZE) {
        if ($dh = opendir($dirname)) {
            while (($file = readdir($dh)) !== false) {
                if (ereg("^". $basename . "\." , $file)) {
                    $arrLog[] = $file;
                }
            }
            // ファイルログが最大個数なら以上なら古いファイルから削除する
            $count = count($arrLog);
            if ($count >= LOGGER_MAX_ROTATION) {
                $diff = $count - LOGGER_MAX_ROTATION;
                for ($i=0; $diff >= $i; $i++) {
                    unlink($dirname. "/" .array_pop($arrLog));
                }
            }
            // ログファイルの添え字をずらす
            $count = count($arrLog);
            for ($i=$count; 1 <= $i; $i--) {
                $move_number = $i + 1;
                if (file_exists("$path.$move_number")) {
                    unlink("$path.$move_number");
                }
                copy("$dirname/" . $arrLog[$i - 1], "$path.$move_number");		
            }
            $ret = copy($path, "$path.1");
            if($ret) {
                unlink($path);
                touch($path);
            }
        }
    }
}
