<?php
/*
 * This file is part of the pettiwork package.
 * (c) 2007-2008 Exbridge,inc. <info@exbridge.jp>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

/**
 * Project: pettiwork: the PHP lightweight web framework
 * File:    xbpwXML.php
 *
 * @link http://exbridge.jp/
 * @author      S.Tajima <tajima@exbridge.jp> 2007N0905
 *              S.Tajima <tajima@exbridge.jp> 2007N1105
 * @version svn:$Id: xbpwXML.php 3 2008-07-01 10:08:07Z tshiro $
 * @copyright 2007-2008 Exbridge,Inc.
 */
class xbpwXML extends DOMDocument {

    /** xpath object */
    var $_xpath = null;

    /** dpath object */
    var $_dpath = null;

    /**
     * constructer
     */
    function xbpwXML($file=null)
    {
        parent::__construct('1.0', 'UTF-8');
        //load
        $this->formatOutput = true;// o͂͂ꂢɐ`łˁB
        $this->preserveWhiteSpace = false;//󔒂ɔY܂ꂽ܂BBBȂ̂
        $this->load($file);
        $this->_dpath = new DOMXPath($this);
        $this->_xpath = simplexml_import_dom($this);
    }

    /**
     * get xml data
     */
    function getXML()
    {
        if ($this->_xpath) {
            return $this->_xpath->asXML();
        }
        return '';
    }

    /**
     * get xml data
     */
    function saveXML($saveFile)
    {
        @fclose(@fwrite(@fopen($saveFile, 'w'), $this->getXML()));
    }

    /**
     * get xml data
     */
    function getSimpleXML()
    {
        return $this->_xpath;
    }

    /**
     * xpath query executer
     */
    function xpath($path)
    {
        if ($this->_xpath) {
            return $this->_xpath->xpath($path);
        }
        return false;
    }

    /**
     * adding element
     */
    function add($xpath, $element, $val)
    {
        $node = $this->_dpath->query($xpath);
        if ($node) {
            $node = $node->item(0);
        }
        if (!$node) {
            $node = $this;
        }
        $node = $node->appendChild($this->createElement($element, htmlspecialchars($val, ENT_QUOTES, 'UTF-8')));
        if (!is_object($this->_xpath)) {
            $this->_xpath = simplexml_import_dom($this);
        }
        return $node;
    }

    /**
     * replace element
     */
    function replace($parent_xpath, $target_xpath, $element, $val)
    {
        $node = $this->_dpath->query($parent_xpath);
        if ($node) {
            $node = $node->item(0);
        }
        if (!$node) {
            $node = $this;
        }
        $node = $node->replaceChild($this->createElement($element, htmlspecialchars($val, ENT_QUOTES, 'UTF-8')), $this->_dpath->query($target_xpath));
        if (!is_object($this->_xpath)) {
            $this->_xpath = simplexml_import_dom($this);
        }
        return $node;
    }

    /**
     * setting attribute (update)
     */
    function attr($xpath, $attr, $val)
    {
        $node = $this->_dpath->query($xpath);
        if ($node) {
            $node = $node->item(0);
        }
        if ($node) {
            if (is_null($val) || $val=='') {
                //deleting attribute
                if ($node->hasAttribute($attr)) {
                    $node->removeAttribute($attr);
                }
            }
            else {
                //setting attribute
                $node->setAttribute($attr, htmlspecialchars($val, ENT_QUOTES, 'UTF-8'));
            }
        }
    }

    /**
     * replace path
     */
    //function _simple_path($path)
    //{
    //    $path = preg_replace('/\[[^[]*\]/i', '', $path);
    //    $path = preg_replace('/text\(\)\/*/i', '', $path);
    //    $path = preg_replace('/@[^\/@]+\/*/i', '', $path);
    //    return $path;
    //}
}
