<?php
/*
 * This file is part of the pettiwork package.
 * (c) 2007-2008 Exbridge,inc. <info@exbridge.jp>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

/**
 * Project: pettiwork: the PHP lightweight web framework
 * File:    xbpwService.php
 *
 * @link http://exbridge.jp/
 * @author S.Tajima <tajima@exbridge.jp>
 * @version svn:$Id: xbpwService.php 16 2008-07-10 12:10:55Z tshiro $
 * @copyright 2007-2008 Exbridge,Inc.
 */
class xbpwService
{
    /**
     * parameter check.
     * @access public
     * @return boolean
     */
    function assert($check, $vo)
    {
        if (is_array($check)) {
            foreach ($check as $val) {
                if (isset($vo->$val) && $vo->$val === 0) {
                    return true;
                }
                if (!isset($vo->$val) || is_null($vo->$val) || $vo->$val === '') {
                    if (PW_EXCEPTION_DISABLED) {
                        trigger_error($val . ' parameter failure [not found]', E_USER_ERROR);
                    }
                    else {
                        throw new xbpwException(E_USER_ERROR, $val . ' parameter failure [not found]');
                    }
                    return false;
                }
            }
        }
        else {
            if(isset($vo->$check) && $vo->$check === 0) {
                return true;
            }
            if (!isset($vo->$check) || is_null($vo->$check) || $vo->$check === '') {
                if (PW_EXCEPTION_DISABLED) {
                    trigger_error($check . ' parameter failure [not found]', E_USER_ERROR);
                }
                else {
                    throw new xbpwException(E_USER_ERROR, $check . ' parameter failure [not found]');
                }
                return false;
            }
        }
        return true;
    }

    /**
     * Returns somfa instance.
     * @access public
     * @return object
     */
    function getDatabase()
    {
        global $_pw_db;
        return $_pw_db;
    }

    /**
     * Returns valueObject instance.
     * @access public
     * @return object
     */
    function getValueObject($param, $vo_name)
    {
        if(is_null($param)) {
            $param = array();
        }
        $class_name = $vo_name . '_vo';
        //use cache file
        if (!PW_DYNAMIC_VALUE_OBJECT) {
            if (file_exists(PW_VALUE_OBJECT_CACHE_DIR)) {
                //あまり意味ないかも・・・
                $vo_file = PW_VALUE_OBJECT_CACHE_DIR . '/' . $class_name . '.php';
                //exists cache file
                if (file_exists ($vo_file)) {
                    //instance of model class
                    require_once($vo_file);
                    return new $class_name;
                }
            }
        }

        if (!class_exists($class_name)) {
            $dynamicClass = 'class '. $class_name . ' {}';
            //use cache file
            if (!PW_DYNAMIC_VALUE_OBJECT) {
                if (file_exists(PW_VALUE_OBJECT_CACHE_DIR)) {
                    $vo_file = PW_VALUE_OBJECT_CACHE_DIR . '/' . $class_name . '.php';
                    $fp = @fopen($vo_file, 'w');@fwrite($fp, "<?php \n" . $dynamicClass . "\n");@fclose($fp);
                }
            }
            eval($dynamicClass);
            $vo = new $class_name();
        }
        else {
            $vo = new $class_name();
        }
        foreach ($param as $key => $val) {
            if (preg_match('/^_.*/i', $key)) {
                continue;
            }
            if (is_object($val)) {
                $vo->$key =& $val;
            }
            else {
                $vo->$key = $val;
            }
        }
        return $vo;
    }

    /**
     * load valueObject.
     * @access public
     */
    function loadValueObject($param, $vo)
    {
        foreach ($vo as $key=>$val) {
            if (preg_match('/^_.*/i', $key)) {
                continue;
            }
            if (is_object($val)) {
                $param->$key =& $val;
            }
            else {
                $param->$key = $val;
            }
        }
    }
}
