<?php
/*
 * This file is part of the petitwork package.
 * (c) 2007-2008 Exbridge,inc. <info@exbridge.jp>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */
require_once(PW_CORE_DIR . DS . 'xbpwController.php');

/**
 * Project: petitwork: the PHP lightweight web framework
 * File:    xbpwMailReader.php
 *
 * @link http://exbridge.jp/
 * @author S.Tajima <tajima@exbridge.jp>
 * @version svn:$Id: xbpwMailController.php 3 2008-10-01 02:51:50Z exbridge $
 * @copyright 2007-2008 Exbridge,Inc.
 */
class xbpwMailController extends xbpwController
{
    var $_pw_mail = null;

    /**
     * Creates new instance.
     * @access public
     */
    function xbpwMailController()
    {
        require_once(PW_VENDORS_DIR . DS . 'pear' . DS . 'Mail' . DS . 'mimeDecode.php');
        $params['include_bodies'] = true;
        $params['decode_bodies']  = true;
        $params['decode_headers'] = true;
        $params['input'] = file_get_contents("php://stdin");
        $params['crlf'] = "\r\n";
        $this->_pw_mail = Mail_mimeDecode::decode($params);
    }

    /**
     * getting message-id method.
     * @access public
     */
    function getMessageId()
    {
        return $this->_pw_mail->headers['message-id'];
    }

    /**
     * getting date method.
     * @access public
     */
    function getDate()
    {
        return $this->_pw_mail->headers['date'];
    }

    /**
     * getting subject method.
     * @access public
     */
    function getSubject()
    {
        return mb_convert_encoding($this->_pw_mail->headers['subject'], PW_ENCODE, 'SJIS,EUC-JP,UTF-8');
    }

    /**
     * getting from method.
     *
     * @return string or array
     * @access public
     */
    function getFrom()
    {
        return $this->_getMailAddresses($this->_pw_mail->headers['from']);
    }

    /**
     * getting to method.
     *
     * @return string or array
     * @access public
     */
    function getTo()
    {
        return $this->_getMailAddresses($this->_pw_mail->headers['to']);
    }

    /**
     * getting cc method.
     *
     * @return string or array
     * @access public
     */
    function getCc()
    {
        return $this->_getMailAddresses($this->_pw_mail->headers['cc']);
    }

    /**
     * getting bcc method.
     *
     * @return string or array
     * @access public
     */
    function getBcc()
    {
        return $this->_getMailAddresses($this->_pw_mail->headers['bcc']);
    }

    /**
     * getting body method.
     * @access public
     */
    function getBody()
    {
        $body = '';
        switch(strtolower($this->_pw_mail->ctype_primary)) {
            case 'text':
                $body = $this->_pw_mail->body;
                break;
            case 'multipart':
                $body = $this->_pw_mail->parts[0]->body;
                break;
            default:
                break;
        }
        return $body;
    }

    /**
     * getting attachments method.
     *
     * @return array
     * @access public
     */
    function getAttachments()
    {
        if (!isset($this->_pw_mail->parts)) {
            return null;
        }
        $attachs = $this->_pw_mail->parts;
        unset($attachs[0]);
        $attachment_list = array();
        foreach ($attachs as $attach) {
            $attachment_list[$attach->d_parameters['filename']] = $attach->body;
        }
        return $attachment_list;
    }

    /**
     * getting mailaddress method.
     *
     * @return string or array
     * @access private
     */
    function _getMailAddresses($param)
    {
        $addresses = explode(',', $param);

        if (count($addresses) > 1) {
            foreach ($addresses as $address) {
                $address_list = array();
                if (eregi("([a-zA-Z0-9])+([a-zA-Z0-9\._-])*@([a-zA-Z0-9_-])+([a-zA-Z0-9\._-]+)+", $address, $results)) {
                    $address_list[] = $results[0];
                }
            }
            return $address_list;
        }
        else {
            if (eregi("([a-zA-Z0-9])+([a-zA-Z0-9\._-])*@([a-zA-Z0-9_-])+([a-zA-Z0-9\._-]+)+", $addresses[0], $results)) {
                return $results[0];
            }
        }
        return '';
    }
}
