<?php
/*
 * This file is part of the petitwork package.
 * (c) 2007-2008 Exbridge,inc. <info@exbridge.jp>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

/**
 * Project: petitwork: the PHP lightweight web framework
 * File:    xbpwContext.php
 *
 * @link http://exbridge.jp/
 * @author S.Tajima <tajima@exbridge.jp>
 * @version svn:$Id: xbpwContext.php 3 2008-10-01 02:51:50Z exbridge $
 * @copyright 2007-2008 Exbridge,Inc.
 */
class xbpwContext 
{
    /**
     * Getting controller class
     * @access public
     */
    function getController()
    {
        //controller incetance
        //static $controller;
        $file = PW_APP . 'Controller.php';
        if (PW_CTL != '') {
            $file = PW_CTL . DS . PW_APP . 'Controller.php';
        }
        $class = PW_APP . 'Controller';
        require_once PW_APP_CONTROLLER_DIR . DS . $file;
        //if(!isset($controller)) $controller = new $class(); 
        //return $controller;
        return new $class();
    }

    /**
     * Getting service class
     * @access public
     */
    function getService($service, $prefix_dir=PW_SRV)
    {
        //service incetance
        //static $service;
        if (is_null($prefix_dir)) {
            $file = $service . 'Service.php';
        }
        else {
            $file = $prefix_dir . DS . $service . 'Service.php';
        }
        $class = $service . 'Service';
        require_once PW_APP_SERVICES_DIR . DS . $file;
        //if(!isset($service)) $service = new $class(); 
        //return $service;
        return new $class();
    }

    /**
     * Getting user session
     * @access public
     */
    function getUser()
    {
        //controller class の dispatch 後に取得可能。
        static $user;
        $user = $_SESSION[PW_SESSION_USER_KEY];
        if (!isset($user) || is_null($user) || $user =='') {
            $user = & new xbpwSecurityUser();
            $_SESSION[PW_SESSION_USER_KEY] = $user;
        }
        return $user;
    }

    /**
     * Setting user session
     * @access public
     */
    function setUser($user)
    {
        $_SESSION[PW_SESSION_USER_KEY] = $user;
    }

    /**
     * Getting user session parameter
     * @access public
     */
    function getUserParameter($key)
    {
        $u = $this->getUser();
        return $u->getUserParameter($key);
    }

    /**
     * Setting user session parameter
     * @access public
     */
    function setUserParameter($key, $val)
    {
        $u = $this->getUser();
        $u->setUserParameter($key, $val);
        $this->setUser($u);
    }

    /**
     * Setting user authentication
     * @access public
     */
    function setAuthenticated($val)
    {
        $u = $this->getUser();
        $u->setAuthenticated($val);
        $this->setUser($u);
    }

    /**
     * is user authentication
     * @access public
     */
    function isAuthenticated()
    {
        $u = $this->getUser();
        return $u->isAuthenticated();
    }

    /**
     * add user credential
     * @access public
     */
    function addCredential($val)
    {
        $u = $this->getUser();
        $u->addCredential($val);
        $this->setUser($u);
    }

    /**
     * is user credential
     * @access public
     */
    function isCredential()
    {
        $u = $this->getUser();
        return $u->isCredential();
    }

    /**
     * setting session value
     * @access public
     */
    function setSession($key, $val)
    {
        $_SESSION[PW_SESSION_GLOBAL_KEY][$key] = $val;
    }

    /**
     * getting session value
     * @access public
     */
    function getSession($key)
    {
        return $_SESSION[PW_SESSION_GLOBAL_KEY][$key];
    }

    /**
     * getting session value
     * @access public
     */
    function clearSession($key)
    {
        unset($_SESSION[PW_SESSION_GLOBAL_KEY][$key]);
    }

    /**
     * setting flash cache value
     * @access public
     */
    function setCache($key, $val)
    {
        if (file_exists(PW_TMP_DIR . DS . 'session')) {
            $val = serialize($val);
            $fp = @fopen(PW_TMP_DIR . DS . 'session' . DS . session_id() . '.' . $key . '.flash.cache', 'w');
            @fwrite($fp, $val);
            @fclose($fp);
        }
        else {
            $message = 'session info save dir is not exists.';
            if (PW_EXCEPTION_DISABLED) {
                trigger_error($message, E_USER_ERROR);
            }
            else {
                throw new xbpwException(E_USER_ERROR, $message);
            }
        }
    }

    /**
     * getting flash cache value
     * @access public
     */
    function getCache($key)
    {
        $file = PW_TMP_DIR . DS . 'session' . DS . session_id() . '.' . $key . '.flash.cache';
        $fp = @fopen($file, 'r');
        $contents = @fread($fp, filesize($file));
        @fclose($fp);
        return unserialize($contents);
    }

    /**
     * clear flash value
     * @access public
     */
    function clearCache($key)
    {
        $file = PW_TMP_DIR . DS . 'session' . DS . session_id() . '.' . $key . '.flash.cache';
        unlink($file);
    }

    /**
     * clear all flash value
     * @access public
     */
    function clearAllCache()
    {
        foreach (glob(PW_TMP_DIR . DS . 'session' . DS . session_id() . '.*.flash.cache') as $file) {
            unlink($file);
        }
    }
}
