<?php
/*
 * This file is part of the petitwork package.
 * (c) 2007-2008 Exbridge,inc. <info@exbridge.jp>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

/**
 * Project: petitwork: the PHP lightweight web framework
 * File:    xbpwUploadFile.php
 *
 * @link http://exbridge.jp/
 * @author S.Tajima <tajima@exbridge.jp>
 * @version svn:$Id: xbpwUploadFile.php 3 2008-10-01 02:51:50Z exbridge $
 * @copyright 2007-2008 Exbridge,Inc.
 */
class xbpwUploadFile
{
    /**
     * @access private
     * @var string
     */
    var $name = null;

    /**
     * @access private
     * @var string
     */
    var $mimeType = null;

    /**
     * @access private
     * @var string
     */
    var $tmpFilePath = null;

    /**
     * @access private
     * @var integer
     */
    var $errorCode = null;

    /**
     * @access private
     * @var integer
     */
    var $fileSize = null;

    /**
     * Creates new instance.
     *
     * @access public
     * @param array $param
     */
    function xbpwUploadFile($param = array())
    {
        if (array_key_exists('name', $param)) {
            $this->setName($param['name']);
        }
        if (array_key_exists('type', $param)) {
            $this->setMimeType($param['type']);
        }
        if (array_key_exists('tmp_name', $param)) {
            $this->setTmpFilePath($param['tmp_name']);
        }
        if (array_key_exists('error', $param)) {
            $this->setErrorCode($param['error']);
        }
        if (array_key_exists('size', $param)) {
            $this->setFileSize($param['size']);
        }
    }

    /**
     * Returns uploaded filename or null.
     *
     * @access public
     * @return string
     */
    function getName()
    {
        return $this->name;
    }

    /**
     * Sets uploaded filename.
     *
     * @access public
     * @param string $name
     */
    function setName($name)
    {
        $this->name = $name;
    }

    /**
     * Returns mime type of uploaded file or null.
     *
     * @access public
     * @return string
     */
    function getMimeType()
    {
        return $this->mimeType;
    }

    /**
     * Sets mime type of uploaded file.
     *
     * @access public
     * @param string $mimeType
     */
    function setMimeType($mimeType)
    {
        $this->mimeType = $mimeType;
    }

    /**
     * Returns temporary file path of uploaded file or null.
     *
     * @access public
     * @return string
     */
    function getTmpFilePath()
    {
        return $this->tmpFilePath;
    }

    /**
     * Sets temporary file path of uploaded file.
     *
     * @access public
     * @param string $tmpFilePath
     */
    function setTmpFilePath($tmpFilePath)
    {
        $this->tmpFilePath = $tmpFilePath;
    }

    /**
     * Returns error code or null.
     *
     * @access public
     * @return integer
     */
    function getErrorCode()
    {
        return $this->errorCode;
    }

    /**
     * Sets error code.
     *
     * @access public
     * @param integer $errorCode
     */
    function setErrorCode($errorCode)
    {
        $this->errorCode = $errorCode;
    }

    /**
     * Returns file size of uploaded file or null.
     *
     * @access public
     * @return integer
     */
    function getFileSize()
    {
        return $this->fileSize;
    }

    /**
     * Sets file size of uploaded file.
     *
     * @access public
     * @param integer $fileSize
     */
    function setFileSize($fileSize)
    {
        $this->fileSize = $fileSize;
    }
}
