<?php
/*
 * This file is part of the somfa package.
 * (c) 2007-2008 Exbridge,inc. <info@exbridge.jp>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

/**
 * Simple O/R Mapping Class
 * PHP versions 5
 * 
 * @package SOMFA
 * @author S.Tajima<tajima@exbridge.jp> 2007/10/24
 *
 * Petitworkとの関連で悩み中
 *
 * @version svn:$Id: somfaLogger.php 3 2008-10-01 02:51:50Z exbridge $
 * @copyright 2007-2008 Exbridge,inc.
 */

/**
 * database logging
 */
function somfaLogger ($message, $class = null, $file = null, $line = null)
{
    if (LOGGER_LEVEL <= 1) {//DEBUG
        somfaPringLog(LOGGER, somfaLogLine($message, $class, $file, $line, 'DEBUG'));
    }
}

/**
 * logging formatter
 */
function somfaLogLine ($message, $class = null, $file = null, $line = null, $level)
{
    $ip = getEnv("REMOTE_ADDR");
    $ip = ($ip=='')?"none":"$ip";
    $date = date('Y/m/d H:i:s', time());
    return "[$date][$level][$ip][$line][$class]$message";
}

function somfaPringLog($file, $str)
{
    $path = LOGGER_DIR . '/' . $file;
    $fp = fopen($path, "a+");
    fwrite( $fp, $str."\n" );
    fclose( $fp );
}
