<?php
/**
 * サンプル用 service class.
 *
 * @author S.Tajima
 */
class sampleService extends xbpwService
{
    function find(&$vo)
    {
        try {
            if (isNULL($vo)) {
                throw new xbpwException(E_USER_ERROR, 'value object class not found');
            }

            $somfa = $this->getDatabase();

            $user_list = $somfa->select('tbm_sample', 'user_cd, user_nm', null, null, 'user_cd', null, &$vo->page_id, &$vo->count);

            $vo->user_list = $user_list;
        }
        catch (xbpwException $e) {
            throw $e;
        }
        catch (Exception $e) {
            throw new xbpwException(E_USER_ERROR, $e->getMessage());
        }
    }

    function save(&$vo)
    {
        try {
            if (isNULL($vo)) {
                throw new xbpwException(E_USER_ERROR, 'value object class not found');
            }
            if (!$this->assert(array('user_cd'), &$vo)) {
                throw new xbpwException(E_USER_ERROR, 'user_cd not found');
            }

            $somfa = $this->getDatabase();

            $data = array();
            $data['user_cd'] = $vo->user_cd;
            $data['user_nm'] = $vo->user_nm;
            $result = $somfa->save('tbm_sample', $data);
        }
        catch (xbpwException $e) {
            throw $e;
        }
        catch (Exception $e) {
            throw new xbpwException(E_USER_ERROR, $e->getMessage());
        }
    }

    function delete(&$vo)
    {
        try {
            if (isNULL($vo)) {
                throw new xbpwException(E_USER_ERROR, 'value object class not found');
            }
            if (!$this->assert(array('user_cd'), &$vo)) {
                throw new xbpwException(E_USER_ERROR, 'user_cd not found');
            }

            $somfa = $this->getDatabase();

            $result = $somfa->delete('tbm_sample', array('user_cd'=>$vo->user_cd));
        }
        catch (xbpwException $e) {
            throw $e;
        }
        catch (Exception $e) {
            throw new xbpwException(E_USER_ERROR, $e->getMessage());
        }
    }
}
