<?php
/*
 * This file is part of the petitwork package.
 * (c) 2007-2008 Exbridge,inc. <info@exbridge.jp>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

/**
 * Project: petitwork: the PHP lightweight web framework
 * File:    function.glib.php
 *
 * @link http://exbridge.jp/
 * @author S.Tajima <tajima@exbridge.jp>
 * @version svn:$Id: function.glib.php 3 2008-10-01 02:51:50Z exbridge $
 * @copyright 2007-2008 Exbridge,Inc.
 */

/**
 * デバッグ用
 */
function a($val)
{
    if (!class_exists('Print_a_class', false)) {
        require_once (PW_VENDORS_DIR . DS . 'debuglib.php');
    }
    print_a($val);
}
function d($val)
{
    echo var_dump($val);
}

/**
 * コンポーネント関数
 */
function include_component($template, $m=null)
{
    $path = PW_TEMPLATE_TEMPLATES_DIR . DS . "component" . DS . $template;
    if (file_exists($path)) {
        return include ($path);
    }
    else {
        throw new xbpwException(E_USER_ERROR, sprintf('component not exists[%s]', $path));
    }
}

/**
 * isNULL
 *
 * @return true:NULLである false:NULLではない
 */
function isNULL($val)
{
    if (isset($val) && $val===0) {
        return false;
    }
    if (!isset($val) || is_null($val) || $val==='') {
        return true;
    }
    return false;
}

/**
 * NULL値の置換
 *
 * @return string
 */
function NVL($val1, $val2=0)
{
    if (isset($val1)) {
        if (isNULL($val1)) {
            return $val2;
        }
    }
    return $val1;
}

/**
 * 左詰め処理
 *
 * @return string
 */
function LPAD($val1, $val2)
{
    return str_pad($val1, $val2, '0', STR_PAD_LEFT);
}

/**
 * 全角、半角混在の長さ取得
 * （UTF-8でもEUCでもSJISでも同じ結果がほしい）
 *
 * @return integer
 */
function LEN($str, $encode=PW_ENCODE) {
    $len = 0;
    $count = mb_strwidth($str, $encode);
    for ($i=0; $i<$count; $i++) {
        $s = substr($str, $i, 1);
        $l = strlen(bin2hex($s)) / 2;
        if ($l==1) {
            $len++;
        }
        else {
            $len = $len + 2;
        }
    }
    return $len;
}

/**
 * バイト数取得
 *
 * @return integer
 */
function BYTE_LEN($str) {
    return strlen(bin2hex($str)) / 2;
}

/**
 * convert uri
 * @return string
 */
function convert_uri($uri)
{
    if ($uri == '#') {
        return $uri;
    }
    if (strpos($uri, '://')) {
        return $uri;
    }
    if (defined('PW_WEB_ALIAS')) {
        if (strlen(PW_WEB_ALIAS) > 0) {
            return '/' . PW_WEB_ALIAS . '/' . $uri;
        }
        else {
            return '/' . $uri;
        }
    }
    return $uri;
}

/**
 * 日付から年週を取得する
 *
 * @param string  ymd 日付
 * @param integer offset 開始曜日（0:日...6:土）
 * @param integer type 週タイプ（1:１月１日を必ず第１週とする
 *                               2:前年の最終週を考慮する
 *                               3:１月１日を含む週を第１週とする）
 * @return string
 */
function week($ymd, $offset=0, $type=2) {
    if ($offset < 0 || $offset > 6) {
        $offset = 0;
    }
    if ($type < 1 || $type > 3) {
        $offset = 1;
    }

    //現在日を作成
    $time = mktime(0, 0, 0, substr($ymd, 4, 2), intval(substr($ymd, 6, 2)), substr($ymd, 0, 4));
    //１月１日からの経過日数を取得する
    $dd = date("z", $time);

    //該当年の１月１日を取得
    $time_f = mktime(0, 0, 0, 1, 1, substr($ymd, 0, 4));
    //曜日番号を取得し１月１日の週初めからの経過日数とする
    $f = date("w", $time_f) + ($offset * -1);
    //if ($f==0) {
    //    $f = $f + 7;
    //}

    if ($type == 1) {
        //１月の週番号日数分を加算
        $dd = $dd + $f;
        //週番号を取得する
        $ww = intval($dd / 7) + 1;
        return substr($ymd,0,4) . LPAD($ww, 2);
    }
    else if ($type == 2) {
        if ($f==0) {
            $f = $f + 7;
        }
        if ((6-$f) >= $dd) {
            //該当年前年の最終週番号を取得
            $time_zf = mktime(0, 0, 0, 1, 1, intval(substr($ymd, 0, 4)) - 1);
            $zf = date("w", $time_zf) + ($offset * -1);
            $time_f = mktime(0, 0, 0, 1, 1-1, substr($ymd, 0, 4));
            $dd = date("z", $time_f) + (6 - $zf);
            if ($zf <= 0) {
                $ww = intval($dd / 7) + 1;
            }
            else {
                $ww = intval($dd / 7);
            }
            return substr(date('Y', $time_f),0,4) . LPAD($ww, 2);
        }
        else {
            //前年の最終週を考慮した週番号を取得
            $ww = intval(($dd - (6-$f+1)) / 7) + 1;
            return substr($ymd,0,4) . LPAD($ww, 2);
        }
    }
    else if ($type == 3) {
        //翌年の１月１日を取得
        $time_n = mktime(0, 0, 0, 1, 1, intval(substr($ymd, 0, 4)) + 1);
        //翌年１月１日の曜日番号を取得
        $ww = date("w", $time_n);
        //７日後の年変わりを取得する
        $time_x = mktime(0, 0, 0, substr($ymd, 4, 2), intval(substr($ymd, 6, 2)) + 7, substr($ymd, 0, 4));
        $yy = date("Y", $time_x);
        $xx = date("z", $time_x);
        if ($yy > intval(substr($ymd, 0, 4)) && ($ww+$xx) > 6) {
            return intval(substr($ymd,0,4)) + 1 . '01';
        }
        else {
            //１月１日からの経過日数を取得する（１月の週番号日数分を加算）
            $dd = $dd + $f;
            //週番号を取得する
            $ww = intval($dd / 7) + 1;
            return substr($ymd,0,4) . LPAD($ww, 2);
        }
    }
}

/**
 * 年週から日付を取得する
 *
 * @param string  yyyyww 年週
 * @param integer head   0:週の開始日 1:週の終了日
 * @param integer offset 開始曜日（0:日...6:土）
 * @param integer type 週タイプ（1:１月１日を必ず第１週とする
 *                               2:前年の最終週を考慮する
 *                               3:１月１日を含む週を第１週とする）
 * @return string
 */
function week2ymd($yyyyww, $head=0, $offset=0, $type=2) {
    if ($head < 0 || $head > 1) {
        $head = 0;
    }
    if ($offset < 0 || $offset > 6) {
        $offset = 0;
    }
    if ($type < 1 || $type > 3) {
        $offset = 1;
    }

    $yyyy = substr($yyyyww, 0, 4);
    $ww = substr($yyyyww, 4, 2);

    if ($type == 2) {
        $yyww = week(substr($yyyyww, 0, 4) . '0101', $offset, $type);
        if (intval(substr($yyww, 4, 2)) > 1 ) {
            $ww = $ww + 1;
        }
    }

    //該当年の１月１日を取得
    $time_f = mktime(0, 0, 0, 1, 1, $yyyy);
    //曜日番号を取得し１月１日の週初めからの経過日数とする
    $f = date('w', $time_f) + ($offset * -1);
    if ($head==0) {
        $dd = $ww * 7 - $f - 6;
    }
    else {
        $dd = $ww * 7 - $f;
    }

    $time = mktime(0, 0, 0, 1, $dd, $yyyy);
    return date('Ymd', $time);
}

/**
 * 日付フォーマット（YYYY-MM-DD HH:mm:SS （Ex.2007-11-08 15:15:05））
 *
 * @param $val yyyymmddhhmmss
 */
function formatYmdHms($val) {
    if (!isNULL($val) && LEN($val)==14) {
        $year   = substr($val, 0, 4);
        $month  = substr($val, 4, 2);
        $day    = substr($val, 6, 2);
        $hour   = substr($val, 8, 2);
        $minute = substr($val, 10, 2);
        $second = substr($val, 12, 2);
        return  $year . '-' . $month . '-' . $day . ' ' . $hour . ':' . $minute . ':' . $second;
    }
    else {
        return $val;
    }
}

/**
 * 日付アンフォーマット（YYYY-MM-DD HH:mm:SS →YYYYMMDDHHmmSS）
 *
 * @param $val yyyy-mm-dd hh:mm:ss
 */
function unFormatYmdHms($val) {
    if (!isNULL($val)) {
        return str_replace(array('-',':',' '), array('','',''), $val);
    }
    else {
        return $val;
    }
}

/**
 * ファイルをフォルダごと削除
 *
 * @param $file
 */
function rm($file) {
    require_once(PW_ROOT_DIR . DS . 'vendors' . DS . 'pear' . DS . 'System.php');
    System::rm("-r " . $file);
}

/**
 * Post Url.
 * @access public
 */
function get_url_contents($url, $param = null, $option_headers = null) {
    $params = array();
    $params['http']['method'] = 'POST';
    if (!is_null($param)) {
        $params['http']['content'] = str_replace('amp;', '', http_build_query($param));
    }
    if (!is_null($option_headers)) {
        $params['http']['header'] = $option_headers;
    }
    return trim(file_get_contents($url, false, stream_context_create($params)));
}

/**
 * isMoble.
 * @access public
 */
function isMobile() {
    if (PW_TEMPLATE_AUTO_CONVERT) {
        require_once(PW_VENDORS_DIR . DS . 'pear' . DS . 'Net'. DS . 'UserAgent'. DS . 'Mobile.php');
        if (Net_UserAgent_Mobile::isMobile()) {
            return true;
        }
    }
    return false;
}
