# PG-REX運用補助ツール 10 利用マニュアル

## 目次

- [運用補助ツールとは?](#運用補助ツールとは?)
- [導入方法](#導入方法)
- [コマンドリファレンス](#コマンドリファレンス)
- [設定ファイル](#設定ファイル)
- [使用上の注意と制約](#使用上の注意と制約)
- [よくあるQ&A](#よくあるQ&A)
- [PG-REX運用補助ツール 1.8からの変更点](#PG-REX運用補助ツール 1.8からの変更点)

## 運用補助ツールとは?

PG-REX運用補助ツールとは、PG-REXの運用手順の簡易化を目的とした以下のコマンド群です。

### 機能概要

各コマンドの概要を以下に示します。

1. pg-rex_master_start

   PG-REXをMasterとして起動する。

2. pg-rex_slave_start

   PG-REXをSlaveとして起動する。

3. pg-rex_stop

   PG-REXのMasterまたはSlaveを停止する。

4. pg-rex_archivefile_delete

   データベースの復旧に必要のないアーカイブログを移動または削除する。

5. pg-rex_switchover

   PG-REXの系切り替えを実施する。



## 導入方法

### インストール

#### 動作確認済み環境

- OS : Redhat Enterprise Linux 7.4
- PG-REX : 10
  - DBMS : PostgreSQL 10.2
  - HA : Pacemaker 1.1.17



#### パッケージのインストール

PG-REX運用補助ツールを使用するためにインストール必須のRPMパッケージを以下に示します。

1. pg-rex_operation_tools_script-10.0-1.el7.noarch.rpm
2. IO_Tty-1.11-1.el7.x86_64.rpm
3. Net_OpenSSH-0.62-1.el7.x86_64.rpm

※バージョンは適宜読み替えてください。



PG-REX運用補助ツールをRPMパッケージからインストールします。インストールは以下の順序で行います。

```
# rpm -ivh Net_OpenSSH-0.62-1.el7.x86_64.rpm
準備しています...              ################################# [100%]
更新中 / インストール中...
   1:Net_OpenSSH-0.62-1.el7           ################################# [100%]
# rpm -ivh IO_Tty-1.11-1.el7.x86_64.rpm
準備しています...              ################################# [100%]
更新中 / インストール中...
   1:IO_Tty-1.11-1.el7                ################################# [100%]
# rpm -ivh pg-rex_operation_tools_script-10.0-1.el7.noarch.rpm
準備しています...              ################################# [100%]
更新中 / インストール中...
   1:pg-rex_operation_tools_script-10################################# [100%]
```



PG-REX運用補助ツールのRPMパッケージをインストールすると、以下のようなディレクトリ構成になります。

```
/usr
   └-local
      └-bin
         └-pg-rex_master_start
         └-pg-rex_slave_start
         └-pg-rex_stop
         └-pg-rex_archivefile_delete
         └-pg-rex_switchover

/etc
   └- pg-rex_tools.conf
```



PG-REX運用補助ツールのRPMパッケージが正常にインストールされていることを確認します。

```
# rpm -qa | grep IO_Tty
IO_Tty-1.11-1.el7.x86_64
# rpm -qa | grep Net_OpenSSH
Net_OpenSSH-0.62-1.el7.x86_64
# rpm -qa | grep pg-rex
pg-rex_operation_tools_script-10.0-1.el7.noarch
```



#### 設定ファイルの編集

環境にあわせて、`/etc/pg-rex_tools.conf`の設定を行います。各項目の詳細は[設定ファイル](#設定ファイル)を参照してください。設定例を以下に示します。

```
$ cat /etc/pg-rex_tools.conf
D-LAN_IPAddress = 192.168.2.1 , 192.168.2.2
Archive_dir = /dbfp/pgarch/arc1
STONITH = enable
VIP_SLAVE = enable
PGPATH = /usr/pgsql-10/bin
PEER_NODE_SSH_PASS_MODE = manual
PEER_NODE_SSH_PASS_FILE = /root/.ssh/peer_node_passfile
BACKUP_NODE_SSH_PASS_MODE = manual
BACKUP_NODE_SSH_PASS_FILE = /root/.ssh/backup_node_passfile
PG-REX_Master_ResourceID = msPostgresql
PG-REX_Primitive_ResourceID = pgsql
VIP-MASTER_ResourceID = vip-master
VIP-REP_ResourceID = vip-rep
VIP-SLAVE_ResourceID = vip-slave
PING_ResourceID = clnPing
DISKD_ResourceID = clnDiskd1
STONITH_ResourceID = grpStonith1 , grpStonith2
ARCHIVE_DELETE_DBCLUSTER_DIR = /dbfp/pgdata/data # この設定値はツールが自動で追加したものです。設定行が複数行出る場合がありますが動作に影響はありません。
```



#### ネットワーク接続の登録

PG-REX運用補助ツールでは両系の状態確認にネットワークの通信を用いるため、事前に両系のrootユーザの`.ssh/known_host`に相手先のD-LANのIPアドレスに対する接続登録をする必要があります。

```
# ssh 192.168.2.2	←相手先のD-LANのIPアドレスを指定
The authenticity of host '192.168.2.2 (192.168.2.2)' can't be established.
ECDSA key fingerprint is *******
Are you sure you want to continue connecting (yes/no)? yes
↑[yes]を入力し[Enter]キーを押下
Warning: Permanently added '192.168.2.2' (ECDSA) to the list of known hosts.
root@192.168.2.2's password:	←[Ctrl]キーと[C]キーを同時に押下
```



### アンインストール

RPMパッケージのアンインストールを行います。

```
# rpm -e pg-rex_operation_tools_script-10.0-1.el7.noarch
# rpm -e Net_OpenSSH-0.62-1.el7.x86_64
# rpm -e IO_Tty-1.11-1.el7.x86_64

# rpm -qa | grep IO_Tty
（出力なし）
# rpm -qa | grep Net_OpenSSH
（出力なし）
# rpm -qa | grep pg-rex
（出力なし）
```



## コマンドリファレンス

1. [pg-rex_master_start](#pg-rex_master_start)
2. [pg-rex_slave_start](#pg-rex_slave_start)
3. [pg-rex_stop](#pg-rex_stop)
4. [pg-rex_archivefile_delete](#pg-rex_archivefile_delete)
5. [pg-rex_switchover](#pg-rex_switchover)

### pg-rex_master_start

##### 概要

本コマンドを実行したノードで、PG-REXをMasterとして起動します。

##### 形式

```
pg-rex_master_start [-h][-v][CrmFilePath]
```

##### 引数

- -h, --help

  Usageを表示して終了します

- -v, --version

  バージョン情報を表示して終了します

- *CrmFilePath*

  crmファイルのファイルパスを指定します(初回起動時に使用する)

##### 実行例

- 引数なしの実行例

```
# pg-rex_master_start
root@192.168.2.2's password:
パスワードが入力されました
1. Pacemaker および Corosync が停止していることを確認
…[OK]
2. 稼働中の Master が存在していないことを確認
…[OK]
3. Master として稼働することが出来るかを確認
…[OK]
4. 起動禁止フラグの存在を確認
…[OK]
5. Pacemaker 起動
…[OK]
6. Master の起動確認
…[OK]
ノード(pgrex01)が Master として起動しました
```

- 引数ありの実行例

```
# pg-rex_master_start PG-REX9.6_pm_crmgen_env.crm
root@192.168.2.2's password:
パスワードが入力されました
1. Pacemaker および Corosync が停止していることを確認
…[OK]
2. 稼働中の Master が存在していないことを確認
…[OK]
3. 起動禁止フラグの存在を確認
…[OK]
/var/lib/pacemaker/cib 配下に既に cib ファイルがあります
削除して反映しても宜しいでしょうか？ (y/N) y
4. /var/lib/pacemaker/cib 配下の cib ファイルを削除
…[OK]
5. Pacemaker 起動
…[OK]
6. crm ファイルの反映
…[OK]
7. Master の起動確認
…[OK]
ノード(pgrex01)が Master として起動しました
```



### pg-rex_slave_start

##### 概要

本コマンドを実行したノードで、PG-REXをSlaveとして起動します。

##### 形式

```
pg-rex_slave_start [[-n] [-r] [-b | -f] | -c] [-d] [-s] [-o OPTIONS] [-h] [-v]
```

##### 引数

- -n, --normal

  現在のDBクラスタを使用してSlave を起動します

- -r, --rewind

  現在のDBクラスタに相手 (Master) ノードと同期したうえでレプリケーションを行えるように、巻き戻し後、Slaveを起動します

- -b, --basebackup

  相手ノードをMasterとしてベースバックアップを取得後、Slaveとして起動します

- -f, --force

  -b オプションに同じ。廃止予定

- -d, --dry-run

  データの変更とノードの起動の実行を伴わず、表示のみを行います

- -c, --check-only

  DBクラスタの状態確認までを実施します

- -s, --shared-archive-directory

  Master と Slave でアーカイブディレクトリを共有しているものとして動作します

- -o, --options=*OPTIONS*

  pg_basebackup に渡すオプションを指定します。**廃止予定で、指定されても無視します**

- -h, --help

  Usageを表示して終了します

- -v, --version

  バージョン情報を表示して終了します

##### 実行例

```
# pg-rex_slave_start
root@192.168.2.1's password:
パスワードが入力されました
1. Pacemaker および Corosync が停止していることを確認
…[OK]
2. 稼働中の Master が存在していることを確認
…[OK]
3. 起動禁止フラグが存在しないことを確認
…[OK]
4. DB クラスタの状態を確認
4.1 現在のDBクラスタのまま起動が可能か確認
DB クラスタが存在していません
4.2 巻き戻しを実行することで起動が可能か確認
DB クラスタが存在していません
4.3 ベースバックアップを取得することが可能か確認

以下の方法で起動が可能です
b) ベースバックアップを取得してSlaveを起動
q) Slaveの起動を中止する
起動方法を選択してください(b/q) b
5. IC-LAN が接続されていることを確認
…[OK]
6. Master からベースバックアップ取得
22631/22631 kB (100%), 1/1 tablespace
NOTICE:  pg_stop_backup complete, all required WAL segments have been archived
...[OK]
7. Master のアーカイブディレクトリと同期
receiving incremental file list
./
000000010000000000000002.partial
00000002.history
000000020000000000000003.00000028.backup

sent 125 bytes  received 16779892 bytes  11186678.00 bytes/sec
total size is 16777559  speedup is 1.00
receiving incremental file list
000000010000000000000001
000000020000000000000002
000000020000000000000003

sent 68 bytes  received 50338126 bytes  33558796.00 bytes/sec
total size is 67109207  speedup is 1.33
...[OK]
8. /var/lib/pacemaker/cib 配下のファイルを削除
...[OK]
9. Slave の起動 (アーカイブリカバリ対象 WAL セグメント数: 1)
...[OK]
10. Slave の起動確認
...[OK]
ノード(pgrex02)が Slave として起動しました
```



### pg-rex_stop

##### 概要

本コマンドを実行したノードで、PG-REXのMasterまたはSlaveを停止します。

##### 形式

```
pg-rex_stop [-f][-h][-v]
```

##### 引数

- -f, --fast

  停止前にCHECKPOINTとsyncコマンドを実行しません

- -h, --help

  Usageを表示して終了します

- -v, --version

  バージョン情報を表示して終了します

##### 実行例

```
# pg-rex_stop
Master を停止します
1. Pacemaker 停止
…[OK]
2. Pacemaker 停止確認
…[OK]
PG-REX の Master (pgrex01)を停止しました
```



### pg-rex_archivefile_delete

##### 概要

本コマンドを実行したノードで不要なアーカイブログを削除します。不要なアーカイブログとは、PG-REXのMasterとSlaveのDBクラスタ、およびコマンド実行時に指定したベースバックアップのリカバリに不要なアーカイブログです。指定したベースバックアップの取得時点よりも過去に取得したベースバックアップは使用できなくなることに注意してください。MasterとSlaveの両方がSSH接続可能である必要があります。

コマンド実行時にベースバックアップの場所の指定を省略した場合は、対話形式での指定となります。対話形式でも省略した場合は、MasterとSlaveのみを対象にして不要なアーカイブログを削除します。ベースバックアップの場所がリモートサーバの場合は、環境設定ファイルのBACKUP_NODE_SSH_PASS_MODEに設定した認証方式でリモートサーバにアクセスします。

本コマンドには、不要なアーカイブログを削除するモード(削除モード)と移動するモード(移動モード)があります。移動モードを指定した場合は、アーカイブログ格納ディレクトリ直下に現在日時のディレクトリを作成し、当該ディレクトリに不要なアーカイブログが移動されます。

##### 形式

```
pg-rex_archivefile_delete {-m|-r}[-f][-D DBclusterFilepath][-h][-v] [[Hostname:]BasebackupPath]

```

##### 引数

- -m, --move

  移動モードで実行します

- -r, --remove

  削除モードで実行します

  ※ 移動モードまたは削除モードはどちらか片方を必ず指定してください


- -f, --force

  アーカイブログの削除を問い合わせ無しで実行します

- -h, --help

  Usageを表示して終了します

- -v, --version

  バージョン情報を表示して終了します

- -D, --dbcluster=*DBclusterFilepath*

  両系で使用しているDBクラスタの場所の絶対パスを指定します

  指定を省略した場合は、以下の優先度で値が適用されます

  1. 環境設定ファイルの「ARCHIVE_DELETE_DBCLUSTER_DIR」
  2. rootユーザでの実行の場合、cib.xmlの「pgdata」
  3. 環境変数の「PGDATA」

- *Hostname*

  ベースバックアップが存在するリモートサーバを指定します

  Hostnameを省略した場合は"localhost"が適用されます

- *BasebackupPath*

  ベースバックアップの場所を絶対パスで指定します

##### 実行例

- 移動モードでベースバックアップの指定をしない場合

```
# pg-rex_archivefile_delete -m

**** 1. 実行準備 ****
移動モードで実行します
ベースバックアップが存在するリモートサーバを入力してください
(入力しなければ "localhost" を設定します)
>
ベースバックアップの場所の絶対パスを入力してください
(入力しなければバックアップ指定無しとして実行されアーカイブが削除されるため、
以前に取得したベースバックアップが使用できなくなります)
>
環境設定ファイル (pgrex_tools.conf) を読み込みます
root@192.168.2.2's password:
パスワードが入力されました
両系のノード名を取得します
cib.xml ファイルを読み込みます
ベースバックアップの場所を指定せずに実行すると、
自身のノード "pgrex01" と相手のノード "pgrex02" の
現時点の PGDATA "/dbfp/pgdata/data" を基準にしてアーカイブログを削除することになります
アーカイブログを削除しますか (y/N) : y

**** 2. WAL ファイル名の取得 ****
自身のノード "pgrex01" の現時点の PGDATA "/dbfp/pgdata/data" からリカバリに必要な最初の WAL ファイル名を取得します
"00000002000000000000000C"
相手のノード "pgrex02" の現時点の PGDATA "/dbfp/pgdata/data" からリカバリに必要な最初の WAL ファイル名を取得します
"000000020000000000000003"

**** 3. 削除基準の算出 ****
削除基準を "000000020000000000000003" としました

**** 4. アーカイブログの移動 ****
削除対象のリストに "000000010000000000000002" を追加します
削除対象のリストに "000000020000000000000002" を追加します
削除対象のリストに "000000010000000000000001" を追加します
移動先ディレクトリ "/dbfp/pgarch/arc1/20130826_163510" を作成しました
-- 移動 -- 000000010000000000000002
-- 移動 -- 000000020000000000000002
-- 移動 -- 000000010000000000000001
アーカイブログの移動に成功しました
移動モード実行のため、移動したファイルは"/dbfp/pgarch/arc1/20130826_163510" に格納されています
```

- 削除モードで、ベースバックアップを指定した場合

```
# pg-rex_archivefile_delete -r pgrex03:/pgdata/backup_data

**** 1. 実行準備 ****
削除モードで実行します
環境設定ファイル (pg-rex_tools.conf) を読み込みます
root@192.168.2.2's password:
パスワードが入力されました
両系のノード名を取得します
cib.xml ファイルを読み込みます

**** 2. WAL ファイル名の取得 ****
指定されたバックアップからリカバリを行うために必要な最初の WAL ファイル名を取得します
root@pgrex03's password:
パスワードが入力されました
"000000020000000000000004"
自身のノード "pgrex01" の現時点の PGDATA "/dbfp/pgdata/data" からリカバリに必要な最初の WAL ファイル名を取得します
"000000020000000000000003"
相手のノード "pgrex02" の現時点の PGDATA "/dbfp/pgdata/data" からリカバリに必要な最初の WAL ファイル名を取得します
"00000002000000000000000C"

**** 3. 削除基準の算出 ****
削除基準を "000000020000000000000003" としました

**** 4. アーカイブログの削除 ****
削除対象のリストに "000000010000000000000001" を追加します
削除対象のリストに "000000010000000000000002" を追加します
削除対象のリストに "000000020000000000000002" を追加します
-- 削除 -- 000000010000000000000001
-- 削除 -- 000000010000000000000002
-- 削除 -- 000000020000000000000002
アーカイブログの削除に成功しました
```



### pg-rex_switchover

##### 概要

Slaveの再組み込み時にベースバックアップを取得せずにPG-REXの系切り替えを実行します。ベースバックアップを取得しないことで、系切り替え時間の短縮を実現します。

本コマンドは、PG-REXのMasterとSlaveのどちらのノードでも実行することができます。

##### 形式

```
pg-rex_switchover [-h][-v]
```

##### 引数

- -h, --help

  Usageを表示して終了します

- -v, --version

  バージョン情報を表示して終了します

##### 実行例

```
# pg-rex_switchover
root@192.168.2.2's password:
パスワードが入力されました
**** 実行準備 ****
1. 環境設定ファイル (pg-rex_tools.conf) の読み込みと両系のノード名を取得
…[OK]
2. 現在および系切り替え後のクラスタ状態を確認

[ 現在 / 系切り替え後のクラスタ状態 ]
 Master : pgrex01 -> pgrex02
 Slave  : pgrex02 -> pgrex01

系切り替え中は可用性が保証されません。
系切り替えを実行してもよろしいでしょうか？ (y/N) y

3. CHECKPOINT の実行
…[OK]
**** 系切り替えを実行 ****
4. Pacemaker の監視を停止
…[OK]
5. Master (pgrex01) の PostgreSQL を停止
…[OK]
6. Pacemaker の監視を再開し系切り替えを実行
…[OK]
7. pgrex02 が新 Master になったことを確認

**** pgrex02 が Master として起動しました ****

8. pgrex01 の Pacemaker を停止
…[OK]
9. pgrex01 で Slave を起動
receiving incremental file list
./
00000011000000000000000C
00000012000000000000000E
00000013.history

sent 71 bytes  received 33561066 bytes  7458030.44 bytes/sec
total size is 503327160  speedup is 15.00

**** pgrex01 が Slave として起動しました ****

****************************************
**** 系切り替えが正常に完了しました ****
****************************************

[ 現在のクラスタ状態 ]
 Master : pgrex02
 Slave  : pgrex01
```



## 設定ファイル

PG-REX運用補助ツールで利用する設定ファイルについて以下に示します。

1. 格納場所 : /etc
2. ファイル名 : pg-rex_tools.conf


### 設定項目一覧


- D-LAN_IPAddress
  - **両系のD-LANのIPアドレス**を指定します。IPアドレスはカンマで区切って指定します。**指定必須**の項目です。
- Archive_dir
  - **アーカイブディレクトリの絶対パス**を指定します。**指定必須**の項目です。
- STONITH
  - STONITH導入環境の場合は**enable**、それ以外の場合は**disable**を指定します。**指定必須**の項目です。
- VIP_SLAVE
  - vip_slaveを使用する環境の場合は**enable**、それ以外の場合は**disable**を指定します。**指定必須**の項目です。
- PGPATH
  - **PostgreSQLコマンドへの絶対パス**を指定します。postgresユーザログイン時に設定される環境変数のPATHにPostgreSQLコマンドへのパスの指定が無い場合に、この設定が有効になります。なお、本パラメータ省略時には、/usr/pgsql-10/bin となります。
- PEER_NODE_SSH_PASS_MODE
  - **manual**、**passfile**、**nopass**のいずれかを指定します。運用補助ツールは実行時に相手ノードにsshで接続する場合があり、このパラメータでssh接続のパスワード取得方法を変更することができます。設定値はセキュリティの観点から**manual**を推奨します。**指定必須**の項目です。
    - manual ： パスワードを手動で入力する。
    - passfile ： PEER_NODE_SSH_PASS_FILEに指定したファイル内のパスワードを参照する。
    - nopass：公開鍵認証を使用する。
- PEER_NODE_SSH_PASS_FILE
  - **相手ノードへのssh接続に必要なパスワードのみが記述されたファイルの絶対パス**を指定します。 **PEER_NODE_SSH_PASS_MODEにpassfileを指定している場合**は、**設定が必須**となります。passfile以外を指定している場合、この設定は参照されません。
- BACKUP_NODE_SSH_PASS_MODE
  - **manual、passfile、nopass**のいずれかを設定します。pg-rex_archivefile_deleteコマンドは実行時にDBクラスタのバックアップ格納先ノードにsshで接続する場合があり、このパラメータでssh接続のパスワード取得方法を変更することができます。設定値はセキュリティの観点から**manual**を推奨します。**指定必須**の項目です。
    - manual ： パスワードを手動で入力する。
    - passfile ：BACKUP_NODE_SSH_ PASS_FILEに指定したファイル内のパスワードを参照する。
    - nopass ： 公開鍵認証を使用する。
- BACKUP_NODE_SSH_PASS_FILE
  - **DBクラスタのバックアップ格納先ノードへのssh接続に必要なパスワードのみが記述されたファイルの絶対パス**を指定します。**BACKUP_NODE_SSH_PASS_MODEにpassfileを指定している場合**は、**設定が必須**となります。passfile以外を指定している場合、この設定は参照されません。
- PG-REX_Master＿ResourceID
  - **PG-REXのMasterのリソースID**を指定します。**指定必須**の項目です。
- PG-REX_Primitive_ResourceID
  - **PG-REXのPrimitiveのリソースID**を指定します。**指定必須**の項目です。
- VIP-MASTER_ResourceID
  - **vip-masterのPrimitiveのリソースID**を指定します。**起動確認を行わない場合は値の指定を省略します。**
- VIP-REP_ResourceID
  - **vip-repのPrimitiveのリソースID**を指定します。**起動確認を行わない場合は値の指定を省略します。**
- VIP-SLAVE_ResourceID
  - **vip-slaveのPrimitiveのリソースID**を指定します。**起動確認を行わない場合は値の指定を省略します。**
- PING_ResourceID
  - **pingのリソースID**を指定します。複数設定する場合はカンマ区切りで指定します。**起動確認を行わない場合は値の指定を省略します。**
- DISKD_ResourceID
  - **diskdのリソースID**を指定します。複数設定する場合はカンマ区切りで指定します。**起動確認を行わない場合は値の指定を省略します。**
- STONITH_ResourceID
  - **STONITHのGroupのリソースIDをカンマ区切りで**指定します。STONITHにdisableが指定されている場合、この設定は無視され、STONITHのGroupの起動確認が行われません。また、この**設定を省略した場合も起動確認が行われません**。
- PG_BASEBAKCUP_opt
  - **今後廃止予定であり、値を指定しても無視されます**。ベースバックアップ取得時に実行するpg_basebackupに渡すオプションを指定します。
- ARCHIVE_DELETE_DBCLUSTER_DIR **(自動設定項目)**
  - 運用補助ツールをrootユーザで実行した時に運用補助ツールが自動的に追加されるパラメータのため、**指定しないでください**。pg-rex_archivefile_deleteコマンド実行時に削除するアーカイブログの基準を決定するため、PG-REXが管理しているDBクラスタディレクトリの絶対パスが設定されます。**PG-REX環境の再構成等で、DBクラスタディレクトリの場所を変更した場合、この設定を削除してから運用補助ツールのコマンドを実行してください**。



## 使用上の注意と制約

PG-REX運用補助ツール利用時の制約を以下に示します。

1. pg-rex_switchoverによる系切り替えでは、Masterの停止後からMasterの切り替え（新Masterの起動）が完了するまでの間は一時的にサービスが停止した状態となる。
2. pg-rex_switchoverによる系切り替えの実施中に、pg-rex_switchoverが異常終了した場合のクラスタ状態は不確定であり、サービスが停止している可能性がある。この場合、元の状態への復旧は自動で実施されないため、クラスタ状態を確認し、手動復旧を試みること。
3. 起動確認はPostgreSQLやIPaddr2、Ping、Diskd、STONITHなどの固有のリソースにしか確認を行わないため、Apacheなど新しくリソースを追加したとしてもその確認を行わない。
4. 両系の状態確認にネットワークの通信を用いるので、ツールが使用するLAN（デフォルトはD-LAN）切断時は、それ以外のLANが繋がっていても実行に失敗する。
5. PG-REXでインストールしたファイルのディレクトリ構成が両系で同一であること。
6. アーカイブログを圧縮する場合、圧縮方式に対応した拡張子を付与しなければならない。サポートする圧縮方式はgzip (拡張子.gz)のみである。



## よくあるQ&A

PG-REX運用補助ツール利用時における、よくある質問について以下に示します。

- Q1. 運用補助ツールコマンドのタイムアウトの時間を変更したい。
  - pg-rex_master_start、pg-rex_slave_start、pg-rex_stop、pg-rex_switchoverコマンドの起動/停止確認時間のタイムアウト値は300秒に設定してあります。これを変更したい場合は、/usr/local/bin配下にある上記コマンドの”my $timeout = 300”と記述されている箇所の数値(秒単位)を変更して下さい。


- Q2. Slave起動時にベースバックアップを取得しなくてよいパターンとは具体的にどういう場合か。
  - 例えば、フェイルオーバ後に旧MasterをSlaveとして起動する場合や、Slaveを一旦停止して再び起動する場合はベースバックアップを取得する必要はありません。ただし、どちらの場合でもSlave起動時のPostgreSQLのリカバリに必要なWALファイルを消去していないことが前提となります。


- Q3. PG-REXでインストールするファイルのディレクトリ構成を両系で異なる構成にしたい。
  - PG-REXではディレクトリ構成が両系で同一であることを前提としています。ディレクトリ構成が両系で同一でない場合、運用補助ツールは正常に動作しません。


- Q4. 運用補助ツールが表示するメッセージに日本語と英語が混在する。
  - 運用補助ツールではPostgreSQLのコマンドをpostgresユーザに切り替えて実行しています。そのため、PostgreSQLのコマンドが出力するメッセージはpostgresユーザの言語設定に沿って表示されます。



## PG-REX運用補助ツール 1.8からの変更点

- 対応するPG-REXのバージョンが10になりました。


------

Copyright (c) 2012-2018, NIPPON TELEGRAPH AND TELEPHONE CORPORATION