/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.ui.graphic;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.weasis.core.api.gui.Image2DViewer;
import org.weasis.core.api.gui.util.DecFormater;
import org.weasis.core.api.gui.util.GeomUtil;
import org.weasis.core.api.media.data.ImageElement;
import org.weasis.core.ui.editor.image.DefaultView2d;
import org.weasis.core.ui.graphic.DragSequence;
import org.weasis.core.ui.graphic.Graphic;
import org.weasis.core.ui.graphic.GraphicLabel;
import org.weasis.core.ui.graphic.MeasureItem;

public abstract class AbstractDragGraphic
implements Graphic,
Cloneable {
    protected PropertyChangeSupport pcs;
    protected Shape shape;
    protected int handlePointTotalNumber;
    protected List<Point2D> handlePointList;
    protected int handleSize = 6;
    protected Paint colorPaint;
    protected float lineThickness;
    protected Stroke stroke;
    protected boolean filled;
    protected boolean labelVisible;
    protected GraphicLabel graphicLabel;
    protected boolean selected = false;
    protected boolean graphicComplete = false;

    public AbstractDragGraphic(int handlePointTotalNumber) {
        this(handlePointTotalNumber, Color.YELLOW);
    }

    public AbstractDragGraphic(int handlePointTotalNumber, Color paintColor) {
        this(handlePointTotalNumber, paintColor, 1.0f);
    }

    public AbstractDragGraphic(int handlePointTotalNumber, Color paintColor, float lineThickness) {
        this(handlePointTotalNumber, paintColor, lineThickness, true);
    }

    public AbstractDragGraphic(int handlePointTotalNumber, Color paintColor, float lineThickness, boolean labelVisible) {
        this(handlePointTotalNumber, paintColor, lineThickness, labelVisible, false);
    }

    public AbstractDragGraphic(int handlePointTotalNumber, Color paintColor, float lineThickness, boolean labelVisible, boolean filled) {
        this.handlePointTotalNumber = handlePointTotalNumber;
        this.handlePointList = new ArrayList<Point2D>(handlePointTotalNumber);
        this.colorPaint = paintColor;
        this.lineThickness = lineThickness;
        this.labelVisible = labelVisible;
        this.filled = filled;
        this.updateStroke();
    }

    @Override
    public Shape getShape() {
        return this.shape;
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public Paint getColorPaint() {
        return this.colorPaint;
    }

    public float getLineThickness() {
        return this.lineThickness;
    }

    public int getHandleSize() {
        return this.handleSize;
    }

    public boolean isFilled() {
        return this.filled;
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    public boolean isLabelVisible() {
        return this.labelVisible;
    }

    @Override
    public GraphicLabel getGraphicLabel() {
        return this.graphicLabel;
    }

    @Override
    public String[] getLabel() {
        return this.graphicLabel != null ? this.graphicLabel.getLabels() : null;
    }

    public boolean isGraphicComplete() {
        this.graphicComplete = this.handlePointList.size() == this.handlePointTotalNumber;
        return this.graphicComplete;
    }

    public String getDescription() {
        return "";
    }

    @Override
    @Deprecated
    public Area getArea() {
        return new Area(this.getShape());
    }

    @Override
    public Area getArea(AffineTransform transform) {
        if (this.shape == null) {
            return new Area();
        }
        if (this.shape instanceof AdvancedShape) {
            return ((AdvancedShape)this.shape).getArea(transform);
        }
        double growingSize = (double)(this.getHandleSize() * 2) / GeomUtil.extractScalingFactor((AffineTransform)transform);
        BasicStroke boundingStroke = new BasicStroke((float)growingSize, 1, 1);
        return new Area(boundingStroke.createStrokedShape(this.shape));
    }

    public Area getArea(MouseEvent mouseEvent) {
        AffineTransform transform = this.getAffineTransform(mouseEvent);
        return this.getArea(transform);
    }

    @Override
    @Deprecated
    public Rectangle getBounds() {
        if (this.shape == null) {
            return null;
        }
        Rectangle bound = this.shape.getBounds();
        bound.grow(bound.width < 1 ? 1 : 0, bound.height < 1 ? 1 : 0);
        return bound;
    }

    @Override
    public Rectangle getBounds(AffineTransform transform) {
        if (this.shape == null) {
            return null;
        }
        if (this.shape instanceof AdvancedShape) {
            ((AdvancedShape)this.shape).updateScalingFactor(transform);
        }
        Rectangle2D bounds = this.shape.getBounds2D();
        this.growSelection(bounds, transform);
        return bounds.getBounds();
    }

    @Override
    @Deprecated
    public Rectangle getRepaintBounds() {
        return this.getRepaintBounds(this.shape);
    }

    @Deprecated
    public Rectangle getRepaintBounds(Shape shape) {
        if (shape == null) {
            return null;
        }
        Rectangle rectangle = shape.getBounds();
        this.growHandles(rectangle);
        return rectangle;
    }

    @Override
    public Rectangle getRepaintBounds(AffineTransform transform) {
        return this.getRepaintBounds(this.shape, transform);
    }

    public Rectangle getRepaintBounds(Shape shape, AffineTransform transform) {
        if (shape == null) {
            return null;
        }
        if (shape instanceof AdvancedShape) {
            ((AdvancedShape)shape).updateScalingFactor(transform);
        }
        Rectangle2D bounds = shape.getBounds2D();
        this.growHandles(bounds, transform);
        return bounds != null ? bounds.getBounds() : null;
    }

    @Override
    public Rectangle getTransformedBounds(Shape shape, AffineTransform transform) {
        Rectangle rectangle = this.getRepaintBounds(shape, transform);
        if (transform != null && rectangle != null) {
            rectangle = transform.createTransformedShape(rectangle).getBounds();
        }
        return rectangle;
    }

    @Deprecated
    public void growHandles(Rectangle rectangle) {
        int growingValue = Math.max((int)Math.ceil((double)this.handleSize * 1.5), (int)Math.ceil(this.lineThickness)) + 1 >> 1;
        rectangle.grow(growingValue, growingValue);
    }

    public void growHandles(Rectangle2D rectangle, AffineTransform transform) {
        double growingSize = Math.max((double)this.handleSize * 1.5, (double)this.lineThickness) / 2.0;
        if (transform != null) {
            double scalingFactor = GeomUtil.extractScalingFactor((AffineTransform)transform);
            growingSize /= scalingFactor;
        }
        GeomUtil.growRectangle((Rectangle2D)rectangle, (double)growingSize);
    }

    public void growSelection(Rectangle2D rectangle, AffineTransform transform) {
        double growingSize = this.handleSize;
        if (transform != null) {
            growingSize /= GeomUtil.extractScalingFactor((AffineTransform)transform);
        }
        GeomUtil.growRectangle((Rectangle2D)rectangle, (double)growingSize);
    }

    @Deprecated
    public int getResizeCorner(MouseEvent mouseEvent) {
        return this.getHandlePointIndex(mouseEvent);
    }

    public int getHandlePointIndex(MouseEvent mouseevent) {
        Point mousePoint = mouseevent.getPoint();
        double maxHandleDistance = (double)this.handleSize * 1.5 / 2.0;
        AffineTransform transform = this.getAffineTransform(mouseevent);
        if (transform != null) {
            double scalingFactor = GeomUtil.extractScalingFactor((AffineTransform)transform);
            maxHandleDistance /= scalingFactor;
        }
        for (int index = 0; index < this.handlePointList.size(); ++index) {
            Point2D point = this.handlePointList.get(index);
            if (!(mousePoint.distance(point) <= maxHandleDistance)) continue;
            return index;
        }
        return -1;
    }

    public boolean isOnGraphicLabel(MouseEvent mouseevent) {
        Area selectionArea;
        Point mousePoint = mouseevent.getPoint();
        AffineTransform transform = this.getAffineTransform(mouseevent);
        return transform != null && this.graphicLabel != null && (selectionArea = this.graphicLabel.getArea(transform)) != null && selectionArea.contains(mousePoint);
    }

    protected DefaultView2d getDefaultView2d(MouseEvent mouseevent) {
        if (mouseevent != null && mouseevent.getSource() instanceof DefaultView2d) {
            return (DefaultView2d)mouseevent.getSource();
        }
        return null;
    }

    protected AffineTransform getAffineTransform(MouseEvent mouseevent) {
        if (mouseevent != null && mouseevent.getSource() instanceof Image2DViewer) {
            return ((Image2DViewer)mouseevent.getSource()).getAffineTransform();
        }
        return null;
    }

    protected ImageElement getImageElement(MouseEvent mouseevent) {
        if (mouseevent != null && mouseevent.getSource() instanceof Image2DViewer) {
            return ((Image2DViewer)mouseevent.getSource()).getImage();
        }
        return null;
    }

    @Override
    @Deprecated
    public boolean intersects(Rectangle rectangle) {
        return this.getArea().intersects(rectangle);
    }

    @Override
    @Deprecated
    public boolean intersects(Rectangle rectangle, AffineTransform transform) {
        return this.getArea(transform).intersects(rectangle);
    }

    @Override
    public void showProperties() {
    }

    public void setShape(Shape newShape, MouseEvent mouseevent) {
        if (this.shape == null || newShape == null || !this.shape.equals(newShape)) {
            Shape oldShape = this.shape;
            this.shape = newShape;
            this.fireDrawingChanged(oldShape);
        }
    }

    public void setLineThickness(float lineThickness) {
        if (this.lineThickness != lineThickness) {
            this.lineThickness = lineThickness;
            this.updateStroke();
            this.fireDrawingChanged();
        }
    }

    public void setPaint(Color newPaintColor) {
        if (this.colorPaint == null || newPaintColor == null || !this.colorPaint.equals(newPaintColor)) {
            this.colorPaint = newPaintColor;
            this.fireDrawingChanged();
        }
    }

    public void setFilled(boolean newFilled) {
        if (this.filled != newFilled) {
            this.filled = newFilled;
            this.fireDrawingChanged();
        }
    }

    @Override
    public void setSelected(boolean newSelected) {
        if (this.selected != newSelected) {
            this.selected = newSelected;
            this.fireDrawingChanged();
        }
    }

    public void setLabelVisible(boolean newLabelVisible) {
        if (this.labelVisible != newLabelVisible) {
            this.labelVisible = newLabelVisible;
            this.fireDrawingChanged();
        }
    }

    @Override
    public void setLabel(String[] labels, DefaultView2d view2d) {
        if (this.shape != null) {
            Rectangle rect = this.shape.getBounds();
            int xPos = rect.x + rect.width;
            int yPos = (int)Math.ceil((double)rect.y + (double)rect.height * 0.5);
            this.setLabel(labels, view2d, xPos, yPos);
        }
    }

    public void setLabel(String[] labels, DefaultView2d view2d, int xPos, int yPos) {
        if (view2d == null) {
            return;
        }
        if (this.labelVisible) {
            Rectangle2D oldBounds = this.graphicLabel != null ? this.graphicLabel.getLabelBounds() : null;
            Rectangle2D newBounds = null;
            if (labels == null || labels.length == 0) {
                this.graphicLabel = null;
            } else {
                if (this.graphicLabel == null) {
                    this.graphicLabel = new GraphicLabel();
                }
                this.graphicLabel.setLabel(view2d, xPos, yPos, labels);
                newBounds = this.graphicLabel.getLabelBounds();
            }
            if (oldBounds == null || newBounds == null || !oldBounds.equals(newBounds)) {
                this.firePropertyChange("graphicLabel", oldBounds, newBounds);
            }
        }
    }

    protected void updateStroke() {
        this.stroke = new BasicStroke(this.lineThickness, 0, 0);
    }

    @Override
    public void updateLabel(Object source, DefaultView2d view2d) {
        if (this.labelVisible) {
            List<MeasureItem> list;
            boolean releasedEvent = true;
            ImageElement imageElement = null;
            if (source instanceof MouseEvent) {
                imageElement = this.getImageElement((MouseEvent)source);
                releasedEvent = ((MouseEvent)source).getID() == 502;
            } else if (source instanceof ImageElement) {
                imageElement = (ImageElement)source;
            }
            if (imageElement != null && (list = this.getMeasurements(imageElement, releasedEvent)) != null) {
                String[] labels = new String[list.size()];
                for (int i = 0; i < labels.length; ++i) {
                    MeasureItem m = list.get(i);
                    StringBuffer buffer = new StringBuffer(m.getMeasurement().getName());
                    buffer.append(": ");
                    if (m.getValue() != null) {
                        buffer.append(DecFormater.oneDecimalUngroup((double)m.getValue()));
                    }
                    if (m.getUnit() != null) {
                        buffer.append(" ");
                        buffer.append(m.getUnit());
                    }
                    labels[i] = buffer.toString();
                }
                this.setLabel(labels, view2d);
            }
        }
    }

    @Override
    public void paint(Graphics2D g2d, AffineTransform transform) {
        Paint oldPaint = g2d.getPaint();
        Stroke oldStroke = g2d.getStroke();
        if (this.shape instanceof AdvancedShape) {
            ((AdvancedShape)this.shape).paint(g2d, transform);
        } else if (this.shape != null) {
            Shape drawingShape = transform == null ? this.shape : transform.createTransformedShape(this.shape);
            g2d.setPaint(this.colorPaint);
            g2d.setStroke(this.stroke);
            g2d.draw(drawingShape);
            if (this.isFilled()) {
                g2d.fill(drawingShape);
            }
        }
        if (this.isSelected()) {
            this.paintHandles(g2d, transform);
        }
        this.paintLabel(g2d, transform);
        g2d.setPaint(oldPaint);
        g2d.setStroke(oldStroke);
    }

    @Override
    public void paintLabel(Graphics2D g2d, AffineTransform transform) {
        if (this.labelVisible && this.graphicLabel != null) {
            this.graphicLabel.paint(g2d, transform, this.selected);
        }
    }

    public void paintHandles(Graphics2D g2d, AffineTransform transform) {
        double size = this.handleSize;
        double halfSize = size / 2.0;
        Point2D[] handlePtArray = new Point2D.Double[this.handlePointList.size()];
        for (int i = 0; i < this.handlePointList.size(); ++i) {
            handlePtArray[i] = new Point2D.Double(this.handlePointList.get(i).getX(), this.handlePointList.get(i).getY());
        }
        transform.transform(handlePtArray, 0, handlePtArray, 0, handlePtArray.length);
        g2d.setPaint(Color.black);
        for (Point2D point : handlePtArray) {
            g2d.fill(new Rectangle2D.Double(point.getX() - halfSize, point.getY() - halfSize, size, size));
        }
        g2d.setPaint(Color.white);
        g2d.setStroke(new BasicStroke(1.0f));
        for (Point2D point : handlePtArray) {
            g2d.draw(new Rectangle2D.Double(point.getX() - halfSize, point.getY() - halfSize, size, size));
        }
    }

    protected boolean isShapeValid() {
        int lastPointIndex = this.handlePointList.size() - 1;
        while (lastPointIndex > 0) {
            Point2D checkPoint = this.handlePointList.get(lastPointIndex);
            ListIterator<Point2D> listIt = this.handlePointList.listIterator(lastPointIndex--);
            while (listIt.hasPrevious()) {
                if (!checkPoint.equals(listIt.previous())) continue;
                return false;
            }
        }
        return true;
    }

    public DragSequence createDragSequence(DragSequence dragsequence, MouseEvent mouseevent) {
        int i = 1;
        if (mouseevent != null && (dragsequence != null || (i = this.getHandlePointIndex(mouseevent)) == -1)) {
            return this.createMoveDrag(dragsequence, mouseevent);
        }
        return this.createResizeDrag(mouseevent, i);
    }

    protected DragSequence createMoveDrag(DragSequence dragsequence, MouseEvent mouseevent) {
        return new DefaultDragSequence();
    }

    protected DragSequence createResizeDrag(MouseEvent mouseevent, int i) {
        return new DefaultDragSequence(i);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertychangelistener) {
        if (this.pcs == null) {
            this.pcs = new PropertyChangeSupport(this);
        }
        for (PropertyChangeListener listener : this.pcs.getPropertyChangeListeners()) {
            if (listener != propertychangelistener) continue;
            return;
        }
        this.pcs.addPropertyChangeListener(propertychangelistener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertychangelistener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(propertychangelistener);
        }
    }

    protected void firePropertyChange(String s, Object obj, Object obj1) {
        if (this.pcs != null) {
            this.pcs.firePropertyChange(s, obj, obj1);
        }
    }

    protected void firePropertyChange(String s, int i, int j) {
        if (this.pcs != null) {
            this.pcs.firePropertyChange(s, i, j);
        }
    }

    protected void firePropertyChange(String s, boolean flag, boolean flag1) {
        if (this.pcs != null) {
            this.pcs.firePropertyChange(s, flag, flag1);
        }
    }

    protected void fireDrawingChanged() {
        this.fireDrawingChanged(null);
    }

    protected void fireDrawingChanged(Shape oldShape) {
        this.firePropertyChange("bounds", oldShape, this.shape);
        Rectangle2D labelBounds = this.graphicLabel != null ? this.graphicLabel.getLabelBounds() : null;
        this.firePropertyChange("graphicLabel", null, labelBounds);
    }

    protected void fireMoveAction() {
        this.firePropertyChange("move", null, this);
    }

    @Override
    public void fireRemoveAction() {
        this.firePropertyChange("remove", null, this);
    }

    public void fireRemoveAndRepaintAction() {
        this.firePropertyChange("remove.repaint", null, this);
    }

    public String toString() {
        return this.getUIName();
    }

    public Object clone() {
        AbstractDragGraphic newGraphic = null;
        try {
            newGraphic = (AbstractDragGraphic)super.clone();
        }
        catch (CloneNotSupportedException clonenotsupportedexception) {
            return null;
        }
        newGraphic.pcs = null;
        newGraphic.shape = null;
        newGraphic.handlePointList = new ArrayList<Point2D>(this.handlePointTotalNumber);
        this.updateStroke();
        newGraphic.graphicLabel = null;
        newGraphic.selected = false;
        newGraphic.graphicComplete = false;
        return newGraphic;
    }

    public Graphic clone(int xPos, int yPos) {
        AbstractDragGraphic graphic = (AbstractDragGraphic)this.clone();
        graphic.setShape(new Rectangle(xPos, yPos, 0, 0), null);
        return graphic;
    }

    @Deprecated
    protected int resizeOnDrawing(int handlePointIndex, int deltaX, int deltaY, MouseEvent mouseEvent) {
        return this.moveAndResizeOnDrawing(handlePointIndex, deltaX, deltaY, mouseEvent);
    }

    protected int moveAndResizeOnDrawing(int handlePointIndex, int deltaX, int deltaY, MouseEvent mouseEvent) {
        if (handlePointIndex == -1) {
            for (Point2D point : this.handlePointList) {
                point.setLocation(point.getX() + (double)deltaX, point.getY() + (double)deltaY);
            }
        } else {
            this.handlePointList.get(handlePointIndex).setLocation(mouseEvent.getPoint());
        }
        return handlePointIndex;
    }

    protected abstract void updateShapeOnDrawing(MouseEvent var1);

    public class AdvancedShape
    implements Shape {
        protected List<BasicShape> shapeList;
        protected double scalingFactor = 1.0;

        public AdvancedShape(int initialShapeNumber) {
            this.shapeList = new ArrayList<BasicShape>(initialShapeNumber);
        }

        void addShape(Shape shape) {
            this.addShape(shape, AbstractDragGraphic.this.getStroke());
        }

        void addShape(Shape shape, Stroke stroke) {
            this.shapeList.add(new BasicShape(shape, stroke));
        }

        void addInvShape(Shape shape, Point2D anchorPoint) {
            this.addInvShape(shape, anchorPoint, AbstractDragGraphic.this.getStroke());
        }

        void addInvShape(Shape shape, Point2D anchorPoint, double scalingMin) {
            this.addInvShape(shape, anchorPoint, scalingMin, AbstractDragGraphic.this.getStroke());
        }

        void addInvShape(Shape shape, Point2D anchorPoint, double scalingMin, Stroke stroke) {
            this.shapeList.add(new InvariantShape(shape, stroke, anchorPoint, scalingMin));
        }

        void addInvShape(Shape shape, Point2D anchorPoint, Stroke stroke) {
            this.shapeList.add(new InvariantShape(shape, stroke, anchorPoint));
        }

        void updateScalingFactor(double scalingFactor) {
            this.scalingFactor = scalingFactor;
        }

        public void updateScalingFactor(AffineTransform transform) {
            this.updateScalingFactor(GeomUtil.extractScalingFactor((AffineTransform)transform));
        }

        public void paint(Graphics2D g2d, AffineTransform transform) {
            this.updateScalingFactor(transform);
            Paint oldPaint = g2d.getPaint();
            Stroke oldStroke = g2d.getStroke();
            g2d.setPaint(AbstractDragGraphic.this.getColorPaint());
            for (BasicShape item : this.shapeList) {
                Shape drawingShape = transform == null ? item.getRealShape() : transform.createTransformedShape(item.getRealShape());
                g2d.setStroke(item.stroke);
                g2d.draw(drawingShape);
                if (!AbstractDragGraphic.this.isFilled()) continue;
                g2d.fill(drawingShape);
            }
            g2d.setPaint(oldPaint);
            g2d.setStroke(oldStroke);
        }

        public Shape getGeneralShape() {
            if (this.shapeList.size() > 0) {
                return this.shapeList.get(0).getRealShape();
            }
            return null;
        }

        @Override
        public Rectangle getBounds() {
            Rectangle rectangle = null;
            for (BasicShape item : this.shapeList) {
                if (rectangle == null) {
                    rectangle = item.getRealShape().getBounds();
                    continue;
                }
                rectangle.add(item.getRealShape().getBounds());
            }
            return rectangle;
        }

        @Override
        public Rectangle2D getBounds2D() {
            Rectangle2D rectangle = null;
            for (BasicShape item : this.shapeList) {
                if (rectangle == null) {
                    rectangle = item.getRealShape().getBounds2D();
                    continue;
                }
                rectangle.add(item.getRealShape().getBounds2D());
            }
            return rectangle;
        }

        @Override
        public boolean contains(double x, double y) {
            for (BasicShape item : this.shapeList) {
                if (!item.getRealShape().contains(x, y)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean contains(Point2D p) {
            for (BasicShape item : this.shapeList) {
                if (!item.getRealShape().contains(p)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean contains(double x, double y, double w, double h) {
            for (BasicShape item : this.shapeList) {
                if (!item.getRealShape().contains(x, y, w, h)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean contains(Rectangle2D r) {
            for (BasicShape item : this.shapeList) {
                if (!item.getRealShape().contains(r)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean intersects(double x, double y, double w, double h) {
            for (BasicShape item : this.shapeList) {
                if (!item.getRealShape().intersects(x, y, w, h)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean intersects(Rectangle2D r) {
            for (BasicShape item : this.shapeList) {
                if (!item.getRealShape().intersects(r)) continue;
                return true;
            }
            return false;
        }

        @Override
        public PathIterator getPathIterator(AffineTransform at) {
            if (at != null) {
                this.updateScalingFactor(at);
            }
            return this.getFullPathShape().getPathIterator(at);
        }

        @Override
        public PathIterator getPathIterator(AffineTransform at, double flatness) {
            if (at != null) {
                this.updateScalingFactor(at);
            }
            return this.getFullPathShape().getPathIterator(at, flatness);
        }

        private Path2D getFullPathShape() {
            Path2D.Double pathShape = new Path2D.Double(1);
            for (BasicShape item : this.shapeList) {
                pathShape.append(item.getRealShape(), false);
            }
            return pathShape;
        }

        public Area getArea(AffineTransform transform) {
            this.updateScalingFactor(transform);
            double growingSize = (double)AbstractDragGraphic.this.getHandleSize() * 2.0 / this.scalingFactor;
            BasicStroke boundingStroke = new BasicStroke((float)growingSize, 1, 1);
            Area pathBoundingArea = new Area();
            for (BasicShape item : this.shapeList) {
                Area strokedArea = null;
                try {
                    Shape strokedShape = boundingStroke.createStrokedShape(item.getRealShape());
                    strokedArea = new Area(strokedShape);
                }
                catch (Throwable e) {
                    System.err.println(e);
                }
                if (strokedArea == null) continue;
                pathBoundingArea.add(new Area(strokedArea));
            }
            return pathBoundingArea;
        }

        class InvariantShape
        extends BasicShape {
            Point2D anchorPoint;
            double scalingMin;

            public InvariantShape(Shape shape, Stroke stroke, Point2D anchorPoint) {
                super(shape, stroke);
                this.scalingMin = 0.0;
                if (anchorPoint == null) {
                    throw new IllegalArgumentException();
                }
                this.anchorPoint = anchorPoint;
            }

            public InvariantShape(Shape shape, Stroke stroke, Point2D anchorPoint, double scalingMin) {
                this(shape, stroke, anchorPoint);
                if (scalingMin < 0.0) {
                    throw new IllegalArgumentException();
                }
                this.scalingMin = scalingMin;
            }

            @Override
            public Shape getRealShape() {
                double scale = AdvancedShape.this.scalingFactor < this.scalingMin ? this.scalingMin : AdvancedShape.this.scalingFactor;
                return GeomUtil.getScaledShape((Shape)this.shape, (double)(1.0 / scale), (Point2D)this.anchorPoint);
            }
        }

        class BasicShape {
            Shape shape;
            Stroke stroke;

            public BasicShape(Shape shape, Stroke stroke) {
                if (shape == null || stroke == null) {
                    throw new IllegalArgumentException();
                }
                this.shape = shape;
                this.stroke = stroke;
            }

            public Shape getRealShape() {
                return this.shape;
            }
        }
    }

    protected class DefaultDragSequence
    implements DragSequence {
        protected int lastX;
        protected int lastY;
        protected int handlePointIndex;

        protected DefaultDragSequence() {
            this(-1);
        }

        protected DefaultDragSequence(int handlePointIndex) {
            this.handlePointIndex = handlePointIndex;
        }

        @Override
        public void startDrag(MouseEvent mouseEvent) {
            this.lastX = mouseEvent.getX();
            this.lastY = mouseEvent.getY();
            if (!AbstractDragGraphic.this.isGraphicComplete()) {
                if (AbstractDragGraphic.this.handlePointList.isEmpty()) {
                    AbstractDragGraphic.this.handlePointList.add(new Point2D.Double(mouseEvent.getPoint().getX(), mouseEvent.getPoint().getY()));
                }
                if (!AbstractDragGraphic.this.isGraphicComplete()) {
                    AbstractDragGraphic.this.handlePointList.add(new Point2D.Double(mouseEvent.getPoint().getX(), mouseEvent.getPoint().getY()));
                }
                this.handlePointIndex = AbstractDragGraphic.this.handlePointList.size() - 1;
            }
        }

        @Override
        public void drag(MouseEvent mouseEvent) {
            int deltaX = mouseEvent.getX() - this.lastX;
            int deltaY = mouseEvent.getY() - this.lastY;
            if (deltaX != 0 || deltaY != 0) {
                this.lastX = mouseEvent.getX();
                this.lastY = mouseEvent.getY();
                this.handlePointIndex = AbstractDragGraphic.this.moveAndResizeOnDrawing(this.handlePointIndex, deltaX, deltaY, mouseEvent);
                AbstractDragGraphic.this.updateShapeOnDrawing(mouseEvent);
            }
        }

        @Override
        public boolean completeDrag(MouseEvent mouseEvent) {
            boolean shapeValid;
            if (!AbstractDragGraphic.this.isGraphicComplete()) {
                Point2D previousPoint;
                int lastPointIndex = AbstractDragGraphic.this.handlePointList.size() - 1;
                Point2D lastPoint = AbstractDragGraphic.this.handlePointList.get(lastPointIndex);
                if (lastPointIndex > 0 && lastPoint.equals(previousPoint = AbstractDragGraphic.this.handlePointList.get(lastPointIndex - 1))) {
                    return false;
                }
                AbstractDragGraphic.this.handlePointList.add(new Point2D.Double(mouseEvent.getPoint().getX(), mouseEvent.getPoint().getY()));
                this.handlePointIndex = AbstractDragGraphic.this.handlePointList.size() - 1;
                return false;
            }
            boolean bl = shapeValid = AbstractDragGraphic.this.shape != null && AbstractDragGraphic.this.isShapeValid();
            if (shapeValid) {
                AbstractDragGraphic.this.updateShapeOnDrawing(mouseEvent);
            }
            return shapeValid;
        }
    }
}

