/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.ui.graphic;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.image.RenderedImage;
import java.util.ArrayList;
import javax.media.jai.PlanarImage;
import javax.media.jai.iterator.RectIter;
import javax.media.jai.iterator.RectIterFactory;
import org.weasis.core.ui.graphic.AbstractDragGraphic;

public abstract class AbstractDragGraphicArea
extends AbstractDragGraphic {
    public AbstractDragGraphicArea(int handlePointTotalNumber) {
        this(handlePointTotalNumber, Color.YELLOW);
    }

    public AbstractDragGraphicArea(int handlePointTotalNumber, Color paintColor) {
        this(handlePointTotalNumber, paintColor, 1.0f);
    }

    public AbstractDragGraphicArea(int handlePointTotalNumber, Color paintColor, float lineThickness) {
        this(handlePointTotalNumber, paintColor, lineThickness, true);
    }

    public AbstractDragGraphicArea(int handlePointTotalNumber, Color paintColor, float lineThickness, boolean labelVisible) {
        this(handlePointTotalNumber, paintColor, lineThickness, labelVisible, false);
    }

    public AbstractDragGraphicArea(int handlePointTotalNumber, Color paintColor, float lineThickness, boolean labelVisible, boolean filled) {
        super(handlePointTotalNumber, paintColor, lineThickness, labelVisible, filled);
    }

    @Override
    public Area getArea(AffineTransform transform) {
        if (this.shape == null) {
            return new Area();
        }
        return new Area(this.shape);
    }

    protected ArrayList<Integer> getValueFromArea(PlanarImage imageData) {
        RectIter it;
        if (imageData == null || this.shape == null) {
            return null;
        }
        Area area = new Area(this.shape);
        Rectangle bound = area.getBounds();
        bound = imageData.getBounds().intersection(bound);
        if (bound.width == 0 || bound.height == 0) {
            return null;
        }
        try {
            it = RectIterFactory.create((RenderedImage)imageData, (Rectangle)bound);
        }
        catch (Exception ex) {
            it = null;
        }
        ArrayList<Integer> list = null;
        if (it != null) {
            int band = imageData.getSampleModel().getNumBands();
            list = new ArrayList<Integer>();
            int[] c = new int[]{0, 0, 0};
            it.startBands();
            it.startLines();
            int y = bound.y;
            while (!it.finishedLines()) {
                it.startPixels();
                int x = bound.x;
                while (!it.finishedPixels()) {
                    if (this.shape.contains(x, y)) {
                        it.getPixel(c);
                        for (int i = 0; i < band; ++i) {
                            list.add(c[i]);
                        }
                    }
                    it.nextPixel();
                    ++x;
                }
                it.nextLine();
                ++y;
            }
        }
        return list;
    }
}

