/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.ui.graphic;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.RenderedImage;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import javax.media.jai.PlanarImage;
import javax.media.jai.iterator.RectIter;
import javax.media.jai.iterator.RectIterFactory;
import org.weasis.core.api.gui.Image2DViewer;
import org.weasis.core.api.media.data.ImageElement;
import org.weasis.core.ui.editor.image.DefaultView2d;
import org.weasis.core.ui.graphic.DragSequence;
import org.weasis.core.ui.graphic.Graphic;
import org.weasis.core.ui.graphic.GraphicLabel;
import org.weasis.core.ui.graphic.model.GraphicsPane;

public abstract class AbstractDragGraphicOld
implements Graphic,
Cloneable {
    protected float lineThickness;
    protected Paint paint;
    protected boolean filled;
    protected transient PropertyChangeSupport pcs;
    protected transient boolean selected;
    protected transient boolean showLabel = true;
    protected transient boolean createPoints = true;
    protected transient Stroke stroke;
    protected transient Shape shape;
    private transient String[] labels;
    protected transient Double labelHeight = null;
    protected transient GraphicLabel graphicLabel = null;

    protected Graphics2D getGraphics2D(MouseEvent mouseevent) {
        if (mouseevent != null && mouseevent.getSource() instanceof GraphicsPane) {
            return (Graphics2D)((GraphicsPane)mouseevent.getSource()).getGraphics();
        }
        return null;
    }

    protected AffineTransform getAffineTransform(MouseEvent mouseevent) {
        if (mouseevent != null && mouseevent.getSource() instanceof Image2DViewer) {
            return ((Image2DViewer)mouseevent.getSource()).getAffineTransform();
        }
        return null;
    }

    protected ImageElement getImageElement(MouseEvent mouseevent) {
        if (mouseevent != null && mouseevent.getSource() instanceof Image2DViewer) {
            return ((Image2DViewer)mouseevent.getSource()).getImage();
        }
        return null;
    }

    @Override
    public void setSelected(boolean flag) {
        if (this.selected != flag) {
            this.selected = flag;
            this.firePropertyChange("bounds", null, this.shape);
        }
    }

    public String toString() {
        return this.getUIName();
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    public void setShape(Shape shape, MouseEvent mouseevent) {
        if (shape != null) {
            Shape oldShape = this.shape;
            this.shape = shape;
            this.firePropertyChange("bounds", oldShape, shape);
        }
    }

    protected void buildLabelBound(DefaultView2d view2d) {
        if (this.showLabel && this.labels != null && view2d != null) {
            RectangularShape longestBound = null;
            for (String l : this.labels) {
                Font defaultFont = view2d.getEventManager().getViewSetting().getFont();
                Rectangle2D bound = defaultFont.getStringBounds(l, ((Graphics2D)view2d.getGraphics()).getFontRenderContext());
                if (longestBound != null && !(bound.getWidth() > longestBound.getWidth())) continue;
                longestBound = bound;
            }
            if (longestBound == null) {
                this.graphicLabel = null;
                this.labelHeight = null;
            } else {
                this.labelHeight = longestBound.getHeight();
                Rectangle rect = this.shape.getBounds();
                if (this.graphicLabel == null) {
                    this.graphicLabel = new GraphicLabel();
                }
                Rectangle oldBound = this.graphicLabel.getBound();
                this.graphicLabel.setLabelBound(rect.x + rect.width, (double)rect.y + (double)rect.height * 0.5, longestBound.getWidth() + 6.0, this.labelHeight * (double)this.labels.length + 6.0);
                this.firePropertyChange("graphicLabel", oldBound, this.graphicLabel);
            }
        }
    }

    @Override
    public GraphicLabel getGraphicLabel() {
        return this.graphicLabel;
    }

    @Override
    public Shape getShape() {
        return this.shape;
    }

    public int getHandleSize() {
        return 6;
    }

    public void setPaint(Paint paint1) {
        this.paint = paint1;
        this.firePropertyChange("bounds", null, this.shape);
    }

    public Paint getPaint() {
        return this.paint;
    }

    public void setFilled(boolean flag) {
        if (this.filled != flag) {
            this.filled = flag;
            this.firePropertyChange("bounds", null, this.shape);
        }
    }

    public boolean isFilled() {
        return this.filled;
    }

    protected void updateShape() {
        this.firePropertyChange("bounds", null, this.shape);
    }

    protected void updateStroke() {
        this.stroke = new BasicStroke(this.lineThickness, 0, 1);
    }

    public float getLineThickness() {
        return this.lineThickness;
    }

    public Point getLabelPosition(Shape shape) {
        if (this.labelHeight != null) {
            Rectangle rect = shape.getBounds();
            return new Point(rect.x + 3 + rect.width, (int)((double)(rect.y + 6 + rect.height / 2) - this.labelHeight * (double)this.labels.length * 0.5));
        }
        return null;
    }

    @Override
    public void paint(Graphics2D g2d, AffineTransform transform) {
        Shape shape = this.getShape();
        if (shape != null) {
            Shape transformedShape;
            g2d.setPaint(this.getPaint());
            g2d.setStroke(this.stroke);
            Shape shape2 = transformedShape = transform == null ? shape : transform.createTransformedShape(shape);
            if (this.isFilled()) {
                g2d.fill(transformedShape);
            }
            g2d.draw(transformedShape);
            if (this.selected && !this.createPoints) {
                this.paintHandles(g2d, transform);
            }
            this.paintLabel(g2d, transform);
        }
    }

    @Override
    public void paintLabel(Graphics2D g2d, AffineTransform transform) {
        if (this.showLabel && this.labels != null && this.graphicLabel != null && this.labelHeight != null) {
            Rectangle2D labelBound = this.graphicLabel.getLabelBounds();
            Point2D.Double p = new Point2D.Double(labelBound.getX(), labelBound.getY());
            transform.transform(p, p);
            p.x += this.graphicLabel.getOffsetX();
            p.y += this.graphicLabel.getOffsetY();
            for (int i = 0; i < this.labels.length; ++i) {
                this.paintFontOutline(g2d, this.labels[i], (float)(p.x + 3.0), (float)(p.y + this.labelHeight * (double)(i + 1)));
            }
        }
    }

    public void paintFontOutline(Graphics2D g2, String str, float x, float y) {
        g2.setPaint(Color.BLACK);
        g2.drawString(str, x - 1.0f, y - 1.0f);
        g2.drawString(str, x - 1.0f, y);
        g2.drawString(str, x - 1.0f, y + 1.0f);
        g2.drawString(str, x, y - 1.0f);
        g2.drawString(str, x, y + 1.0f);
        g2.drawString(str, x + 1.0f, y - 1.0f);
        g2.drawString(str, x + 1.0f, y);
        g2.drawString(str, x + 1.0f, y + 1.0f);
        g2.setPaint(Color.WHITE);
        g2.drawString(str, x, y);
    }

    protected Stroke getStroke() {
        return this.stroke;
    }

    public void paintHandles(Graphics2D graphics2d, AffineTransform transform) {
        int k;
        Rectangle rect = this.getBounds();
        graphics2d.setPaint(Color.black);
        int numPoints = 8;
        int i = this.getHandleSize();
        int j = i / 2;
        float x = rect.x;
        float y = rect.y;
        float w = x + (float)rect.width;
        float h = y + (float)rect.height;
        float mw = x + (float)rect.width / 2.0f;
        float mh = y + (float)rect.height / 2.0f;
        float[] dstPts = new float[]{x, y, mw, y, w, y, x, mh, w, mh, x, h, mw, h, w, h};
        if (transform != null) {
            transform.transform(dstPts, 0, dstPts, 0, numPoints);
        }
        int l = numPoints * 2;
        for (k = 0; k < l; ++k) {
            graphics2d.fill(new Rectangle2D.Float(dstPts[k] - (float)j, dstPts[++k] - (float)j, i, i));
        }
        graphics2d.setPaint(Color.white);
        graphics2d.setStroke(new BasicStroke(1.0f));
        l = numPoints * 2;
        for (k = 0; k < l; ++k) {
            graphics2d.draw(new Rectangle2D.Float(dstPts[k] - (float)j, dstPts[++k] - (float)j, i, i));
        }
    }

    public void setLineThickness(float f) {
        this.lineThickness = f;
        this.updateStroke();
        this.updateShape();
    }

    @Override
    public void showProperties() {
    }

    @Override
    public boolean intersects(Rectangle rectangle) {
        return this.getArea().intersects(rectangle);
    }

    @Override
    public boolean intersects(Rectangle rectangle, AffineTransform transform) {
        return this.getArea(transform).intersects(rectangle);
    }

    @Override
    public Rectangle getRepaintBounds() {
        return this.getRepaintBounds(this.shape);
    }

    public Rectangle getRepaintBounds(Shape shape) {
        if (shape == null) {
            return null;
        }
        Rectangle rectangle = shape.getBounds();
        this.growHandles(rectangle);
        return rectangle;
    }

    public void growHandles(Rectangle rectangle) {
        int i = this.getHandleSize();
        int thick = (int)Math.ceil(this.lineThickness);
        if (thick > i) {
            i = thick;
        }
        rectangle.width += (i += 4);
        rectangle.height += i;
        rectangle.x -= (i /= 2);
        rectangle.y -= i;
    }

    public Rectangle getTransformedBounds(AffineTransform affineTransform) {
        return this.getTransformedBounds(this.shape, affineTransform);
    }

    @Override
    public Rectangle getTransformedBounds(Shape shape, AffineTransform affineTransform) {
        if (affineTransform == null) {
            return this.getRepaintBounds(shape);
        }
        Rectangle rectangle = affineTransform.createTransformedShape(shape).getBounds();
        this.growHandles(rectangle);
        return rectangle;
    }

    @Override
    public Rectangle getBounds() {
        return this.getBounds(null);
    }

    @Override
    public Rectangle getBounds(AffineTransform affineTransform) {
        Shape shape1 = this.getShape();
        if (shape1 == null) {
            return null;
        }
        Rectangle bound = shape1.getBounds();
        if (bound.width < 1) {
            bound.width = 1;
        }
        if (bound.height < 1) {
            bound.height = 1;
        }
        return bound;
    }

    public DragSequence createDragSequence(DragSequence dragsequence, MouseEvent mouseevent) {
        int i = 1;
        if (mouseevent != null && (dragsequence != null || (i = this.getResizeCorner(mouseevent)) == -1)) {
            return this.createMoveDrag(dragsequence, mouseevent);
        }
        return this.createResizeDrag(mouseevent, i);
    }

    protected DragSequence createMoveDrag(DragSequence dragsequence, MouseEvent mouseevent) {
        return new DefaultDragSequence();
    }

    protected DragSequence createResizeDrag(MouseEvent mouseevent, int i) {
        return new DefaultDragSequence(mouseevent == null, i);
    }

    @Override
    public Area getArea() {
        return new Area(this.getShape());
    }

    public Area getArea(MouseEvent mouseevent) {
        return this.getArea();
    }

    @Override
    public Area getArea(AffineTransform transform) {
        return this.getArea();
    }

    public int getResizeCorner(MouseEvent mouseevent) {
        Point pos = mouseevent.getPoint();
        Rectangle rect = this.getBounds();
        int k = this.getHandleSize() + 2;
        AffineTransform affineTransform = this.getAffineTransform(mouseevent);
        if (affineTransform != null) {
            double scale = affineTransform.getScaleX();
            k = (int)Math.ceil((double)k / scale + 1.0);
        }
        int l = k / 2;
        int i = pos.x - rect.x + l;
        int j = pos.y - rect.y + l;
        int i1 = -1;
        if (i >= 0) {
            if (i < k) {
                i1 = 1;
            } else if (i >= rect.width / 2 && i < rect.width / 2 + k) {
                i1 = 2;
            } else if (i >= rect.width && i < rect.width + k) {
                i1 = 3;
            }
        }
        if (i1 != -1 && j >= 0) {
            if (j >= rect.height / 2 && j < rect.height / 2 + k) {
                if (i1 == 2) {
                    return -1;
                }
                i1 = i1 == 1 ? 0 : 4;
            } else if (j >= rect.height && j < rect.height + k) {
                i1 = i1 == 1 ? 7 : (i1 == 2 ? 6 : 5);
            } else if (j >= k) {
                i1 = -1;
            }
        } else {
            i1 = -1;
        }
        return i1;
    }

    public Object clone() throws CloneNotSupportedException {
        AbstractDragGraphicOld abstractGraphic = null;
        try {
            abstractGraphic = (AbstractDragGraphicOld)super.clone();
        }
        catch (CloneNotSupportedException clonenotsupportedexception) {
            return null;
        }
        abstractGraphic.pcs = null;
        abstractGraphic.selected = false;
        abstractGraphic.filled = this.filled;
        return abstractGraphic;
    }

    protected abstract int resizeOnDrawing(int var1, int var2, int var3, MouseEvent var4);

    public abstract Graphic clone(int var1, int var2);

    protected abstract void updateShapeOnDrawing(MouseEvent var1);

    public void move(int i, int j, int k, MouseEvent mouseevent) {
    }

    public Point needToMoveCanvas(int x, int y) {
        return null;
    }

    protected void firePropertyChange(String s, Object obj, Object obj1) {
        if (this.pcs != null) {
            this.pcs.firePropertyChange(s, obj, obj1);
        }
    }

    protected void firePropertyChange(String s, int i, int j) {
        if (this.pcs != null) {
            this.pcs.firePropertyChange(s, i, j);
        }
    }

    protected void firePropertyChange(String s, boolean flag, boolean flag1) {
        if (this.pcs != null) {
            this.pcs.firePropertyChange(s, flag, flag1);
        }
    }

    protected void fireMoveAction() {
        if (this.pcs != null) {
            this.pcs.firePropertyChange("move", null, this);
        }
    }

    @Override
    public void fireRemoveAction() {
        if (this.pcs != null) {
            this.pcs.firePropertyChange("remove", null, this);
        }
    }

    public void fireRemoveAndRepaintAction() {
        if (this.pcs != null) {
            this.pcs.firePropertyChange("remove.repaint", null, this);
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertychangelistener) {
        if (this.pcs == null) {
            this.pcs = new PropertyChangeSupport(this);
        }
        for (PropertyChangeListener listener : this.pcs.getPropertyChangeListeners()) {
            if (listener != propertychangelistener) continue;
            return;
        }
        this.pcs.addPropertyChangeListener(propertychangelistener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertychangelistener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(propertychangelistener);
        }
    }

    public boolean isCreatePoints() {
        return this.createPoints;
    }

    @Override
    public String[] getLabel() {
        return this.labels;
    }

    @Override
    public void setLabel(String[] label, DefaultView2d view2d) {
        this.labels = label;
        this.buildLabelBound(view2d);
    }

    protected ArrayList<Integer> getValueFromArea(PlanarImage imageData) {
        RectIter it;
        if (imageData == null || this.shape == null) {
            return null;
        }
        Area area = new Area(this.shape);
        Rectangle bound = area.getBounds();
        bound = imageData.getBounds().intersection(bound);
        if (bound.width == 0 || bound.height == 0) {
            return null;
        }
        try {
            it = RectIterFactory.create((RenderedImage)imageData, (Rectangle)bound);
        }
        catch (Exception ex) {
            it = null;
        }
        ArrayList<Integer> list = null;
        if (it != null) {
            int band = imageData.getSampleModel().getNumBands();
            list = new ArrayList<Integer>();
            int[] c = new int[]{0, 0, 0};
            it.startBands();
            it.startLines();
            int y = bound.y;
            while (!it.finishedLines()) {
                it.startPixels();
                int x = bound.x;
                while (!it.finishedPixels()) {
                    if (this.shape.contains(x, y)) {
                        it.getPixel(c);
                        for (int i = 0; i < band; ++i) {
                            list.add(c[i]);
                        }
                    }
                    it.nextPixel();
                    ++x;
                }
                it.nextLine();
                ++y;
            }
        }
        return list;
    }

    @Override
    public Rectangle getRepaintBounds(AffineTransform transform) {
        return null;
    }

    protected class DefaultDragSequence
    implements DragSequence {
        protected int lastX;
        protected int lastY;
        protected int boundingPointIndex;

        @Override
        public void startDrag(MouseEvent mouseevent) {
            this.update(mouseevent);
        }

        @Override
        public void drag(MouseEvent mouseevent) {
            int deltaX = mouseevent.getX() - this.getLastX();
            int deltaY = mouseevent.getY() - this.getLastY();
            if (deltaX != 0 || deltaY != 0) {
                this.boundingPointIndex = AbstractDragGraphicOld.this.resizeOnDrawing(this.getType(), deltaX, deltaY, mouseevent);
                AbstractDragGraphicOld.this.updateShapeOnDrawing(mouseevent);
                this.update(mouseevent);
            }
        }

        @Override
        public boolean completeDrag(MouseEvent mouseevent) {
            if (AbstractDragGraphicOld.this.createPoints) {
                AbstractDragGraphicOld.this.updateShape();
                AbstractDragGraphicOld.this.createPoints = false;
            }
            int deltaX = mouseevent.getX() - this.getLastX();
            int deltaY = mouseevent.getY() - this.getLastY();
            if (deltaX != 0 || deltaY != 0) {
                System.out.println();
            }
            this.update(mouseevent);
            return true;
        }

        protected int getType() {
            return this.boundingPointIndex;
        }

        protected int getLastX() {
            return this.lastX;
        }

        protected int getLastY() {
            return this.lastY;
        }

        protected void update(int x, int y) {
            this.lastX = x;
            this.lastY = y;
        }

        protected void update(MouseEvent mouseevent) {
            this.lastX = mouseevent.getX();
            this.lastY = mouseevent.getY();
        }

        protected DefaultDragSequence() {
            this(false, -1);
        }

        protected DefaultDragSequence(boolean flag, int i) {
            this.boundingPointIndex = i;
        }
    }
}

