/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.ui.graphic;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.geom.Arc2D;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.weasis.core.api.gui.util.GeomUtil;
import org.weasis.core.api.image.measure.MeasurementsAdapter;
import org.weasis.core.api.media.data.ImageElement;
import org.weasis.core.ui.Messages;
import org.weasis.core.ui.editor.image.DefaultView2d;
import org.weasis.core.ui.graphic.AbstractDragGraphic;
import org.weasis.core.ui.graphic.MeasureItem;
import org.weasis.core.ui.graphic.Measurement;

public class CobbAngleToolGraphic
extends AbstractDragGraphic {
    public static final Icon ICON = new ImageIcon(CobbAngleToolGraphic.class.getResource("/icon/22x22/draw-cobb.png"));
    public static final Measurement Angle = new Measurement("Angle", true);
    public static final Measurement ComplementaryAngle = new Measurement("Complementary Angle", true);
    protected Stroke strokeDecorator;

    public CobbAngleToolGraphic(float lineThickness, Color paintColor, boolean labelVisible) {
        super(5, paintColor, lineThickness, labelVisible);
    }

    public Icon getIcon() {
        return ICON;
    }

    public String getUIName() {
        return Messages.getString("MeasureToolBar.cobb.angle");
    }

    @Override
    protected void updateStroke() {
        super.updateStroke();
        this.strokeDecorator = new BasicStroke(this.lineThickness, 0, 0, 10.0f, new float[]{5.0f, 5.0f}, 0.0f);
    }

    @Override
    public void updateLabel(Object source, DefaultView2d view2d) {
    }

    @Override
    protected int moveAndResizeOnDrawing(int handlePointIndex, int deltaX, int deltaY, MouseEvent mouseEvent) {
        if (handlePointIndex == -1) {
            for (Point2D point : this.handlePointList) {
                point.setLocation(point.getX() + (double)deltaX, point.getY() + (double)deltaY);
            }
        } else {
            ((Point2D)this.handlePointList.get(handlePointIndex)).setLocation(mouseEvent.getPoint());
            if (handlePointIndex != 4 && this.handlePointList.size() >= 4) {
                Point2D A = (Point2D)this.handlePointList.get(0);
                Point2D B = (Point2D)this.handlePointList.get(1);
                Point2D C = (Point2D)this.handlePointList.get(2);
                Point2D D = (Point2D)this.handlePointList.get(3);
                double Ax = A.getX();
                double Ay = A.getY();
                double Bx = B.getX();
                double By = B.getY();
                double Cx = C.getX();
                double Cy = C.getY();
                double Dx = D.getX();
                double Dy = D.getY();
                double denominator = (Bx - Ax) * (Dy - Cy) - (By - Ay) * (Dx - Cx);
                if (denominator != 0.0) {
                    double d2;
                    double d1;
                    Point2D switchPoint;
                    double r = ((Ay - Cy) * (Dx - Cx) - (Ax - Cx) * (Dy - Cy)) / denominator;
                    double s = ((Ay - Cy) * (Bx - Ax) - (Ax - Cx) * (By - Ay)) / denominator;
                    Point2D.Double P = new Point2D.Double(Ax + r * (Bx - Ax), Ay + r * (By - Ay));
                    Point2D[] pts1 = new Point2D[3];
                    Point2D[] pts2 = new Point2D[3];
                    Point2D point2D = pts1[0] = r >= 0.0 ? A : B;
                    Point2D point2D2 = r < 0.0 ? A : (pts1[1] = r > 1.0 ? B : P);
                    Point2D point2D3 = r < 0.0 ? P : (pts1[2] = r > 1.0 ? P : B);
                    if (pts1[1].equals(P) && pts1[1].distance(pts1[0]) < pts1[1].distance(pts1[2])) {
                        switchPoint = (Point2D)pts1[2].clone();
                        pts1[2] = (Point2D)pts1[0].clone();
                        pts1[0] = switchPoint;
                    }
                    Point2D point2D4 = pts2[0] = s >= 0.0 ? C : D;
                    Point2D point2D5 = s < 0.0 ? C : (pts2[1] = s > 1.0 ? D : P);
                    Point2D point2D6 = s < 0.0 ? P : (pts2[2] = s > 1.0 ? P : D);
                    if (pts2[1].equals(P) && pts2[1].distance(pts2[0]) < pts2[1].distance(pts2[2])) {
                        switchPoint = (Point2D)pts2[2].clone();
                        pts2[2] = (Point2D)pts2[0].clone();
                        pts2[0] = switchPoint;
                    }
                    Point2D M = Math.max(d1 = P.distance(pts1[0]), d2 = P.distance(pts2[0])) == d1 ? GeomUtil.getMidPoint((Point2D)pts1[0], (Point2D)GeomUtil.getColinearPointWithLength((Point2D)P, (Point2D)pts2[0], (double)d1)) : GeomUtil.getMidPoint((Point2D)pts2[0], (Point2D)GeomUtil.getColinearPointWithLength((Point2D)P, (Point2D)pts1[0], (double)d2));
                    Line2D.Double lineMP = new Line2D.Double(M, P);
                    Point2D H1 = GeomUtil.getMidPoint((Point2D)pts1[1], (Point2D)GeomUtil.getMidPoint((Point2D)pts1[0], (Point2D)pts1[1]));
                    Point2D H2 = GeomUtil.getMidPoint((Point2D)pts2[1], (Point2D)GeomUtil.getMidPoint((Point2D)pts2[0], (Point2D)pts2[1]));
                    Point2D O1 = GeomUtil.getPerpendicularPointToLine((Line2D)lineMP, (Point2D)H1);
                    Point2D O2 = GeomUtil.getPerpendicularPointToLine((Line2D)lineMP, (Point2D)H2);
                    Point2D O = GeomUtil.getMidPoint((Point2D)O1, (Point2D)O2);
                    if (this.handlePointList.size() < this.handlePointTotalNumber) {
                        this.handlePointList.add(new Point2D.Double(O.getX(), O.getY()));
                    } else {
                        ((Point2D)this.handlePointList.get(4)).setLocation(O.getX(), O.getY());
                    }
                }
            }
        }
        return handlePointIndex;
    }

    @Override
    protected void updateShapeOnDrawing(MouseEvent mouseEvent) {
        if (this.handlePointList.size() >= 1) {
            Point2D A = (Point2D)this.handlePointList.get(0);
            if (this.handlePointList.size() >= 2) {
                AbstractDragGraphic.AdvancedShape newShape = new AbstractDragGraphic.AdvancedShape(9);
                Path2D.Double generalpath = new Path2D.Double(1, this.handlePointList.size());
                newShape.addShape(generalpath);
                Point2D B = (Point2D)this.handlePointList.get(1);
                ((Path2D)generalpath).moveTo(A.getX(), A.getY());
                ((Path2D)generalpath).lineTo(B.getX(), B.getY());
                if (this.handlePointList.size() >= 3) {
                    Point2D C = (Point2D)this.handlePointList.get(2);
                    if (this.handlePointList.size() >= 4) {
                        Point2D D = (Point2D)this.handlePointList.get(3);
                        ((Path2D)generalpath).moveTo(C.getX(), C.getY());
                        ((Path2D)generalpath).lineTo(D.getX(), D.getY());
                        if (this.handlePointList.size() >= 5) {
                            Point2D O = (Point2D)this.handlePointList.get(4);
                            double Ax = A.getX();
                            double Ay = A.getY();
                            double Bx = B.getX();
                            double By = B.getY();
                            double Cx = C.getX();
                            double Cy = C.getY();
                            double Dx = D.getX();
                            double Dy = D.getY();
                            double distAB2 = Point2D.distanceSq(Ax, Ay, Bx, By);
                            double distCD2 = Point2D.distanceSq(Cx, Cy, Dx, Dy);
                            double r1 = ((Ay - O.getY()) * (Ay - By) + (Ax - O.getX()) * (Ax - Bx)) / distAB2;
                            double r2 = ((Cy - O.getY()) * (Cy - Dy) + (Cx - O.getX()) * (Cx - Dx)) / distCD2;
                            Point2D.Double I = new Point2D.Double(Ax + r1 * (Bx - Ax), Ay + r1 * (By - Ay));
                            Point2D.Double J = new Point2D.Double(Cx + r2 * (Dx - Cx), Cy + r2 * (Dy - Cy));
                            if (r1 < 0.0 || r1 > 1.0) {
                                newShape.addShape(new Line2D.Double(r1 > 1.0 ? B : A, I), this.strokeDecorator);
                            }
                            if (r2 < 0.0 || r2 > 1.0) {
                                newShape.addShape(new Line2D.Double(r1 > 1.0 ? D : C, J), this.strokeDecorator);
                            }
                            newShape.addShape(new Line2D.Double(O, I));
                            newShape.addShape(new Line2D.Double(O, J));
                            double distOI = O.distance(I);
                            double distOJ = O.distance(J);
                            double extSegLength = 32.0;
                            Point2D K = GeomUtil.getColinearPointWithLength((Point2D)I, (Point2D)O, (double)(distOI + extSegLength));
                            Point2D L = GeomUtil.getColinearPointWithLength((Point2D)J, (Point2D)O, (double)(distOJ + extSegLength));
                            double dOKmax = 0.5 * distOI;
                            newShape.addInvShape((Shape)new Line2D.Double(O, K), (Point2D)O.clone(), extSegLength / dOKmax);
                            double dOLmax = 0.5 * distOJ;
                            newShape.addInvShape((Shape)new Line2D.Double(O, L), (Point2D)O.clone(), extSegLength / dOKmax);
                            double startingAngle = K.getY() > L.getY() ? GeomUtil.getAngleDeg((Point2D)O, (Point2D)J) : GeomUtil.getAngleDeg((Point2D)O, (Point2D)I);
                            double angularExtent = K.getY() > L.getY() ? GeomUtil.getAngleDeg((Point2D)J, (Point2D)O, (Point2D)K) : GeomUtil.getAngleDeg((Point2D)I, (Point2D)O, (Point2D)L);
                            angularExtent = GeomUtil.getSmallestRotationAngleDeg((double)angularExtent);
                            double radius = 0.6666666666666666 * extSegLength;
                            Rectangle2D.Double arcAngleBounds = new Rectangle2D.Double(O.getX() - radius, O.getY() - radius, 2.0 * radius, 2.0 * radius);
                            Arc2D.Double arcAngle = new Arc2D.Double(arcAngleBounds, startingAngle, angularExtent, 0);
                            double rMax = 0.6666666666666666 * (K.getY() > L.getY() ? dOKmax : dOLmax);
                            newShape.addInvShape((Shape)arcAngle, (Point2D)O.clone(), radius / rMax);
                            double cornerLength = 10.0;
                            double cImax = 0.6666666666666666 * Math.min(distOI, Math.max(I.distance(A), I.distance(B)));
                            newShape.addInvShape(GeomUtil.getCornerShape((Point2D)GeomUtil.getMidPoint((Point2D)A, (Point2D)B), (Point2D)I, (Point2D)O, (double)cornerLength), (Point2D)I.clone(), cornerLength / cImax);
                            double cJmax = 0.6666666666666666 * Math.min(distOJ, Math.max(J.distance(C), J.distance(D)));
                            newShape.addInvShape(GeomUtil.getCornerShape((Point2D)GeomUtil.getMidPoint((Point2D)C, (Point2D)D), (Point2D)J, (Point2D)O, (double)cornerLength), (Point2D)J.clone(), cornerLength / cJmax);
                        }
                    }
                }
                this.setShape(newShape, mouseEvent);
                this.updateLabel(mouseEvent, this.getDefaultView2d(mouseEvent));
            }
        }
    }

    @Override
    public List<MeasureItem> getMeasurements(ImageElement imageElement, boolean releaseEvent) {
        MeasurementsAdapter adapter;
        if (imageElement != null && this.handlePointList.size() >= 5 && (adapter = imageElement.getMeasurementAdapter()) != null) {
            ArrayList<MeasureItem> measVal = new ArrayList<MeasureItem>();
            if (Angle.isComputed()) {
                Point2D A = (Point2D)this.handlePointList.get(0);
                Point2D B = (Point2D)this.handlePointList.get(1);
                Point2D C = (Point2D)this.handlePointList.get(2);
                Point2D D = (Point2D)this.handlePointList.get(3);
                Point2D O = (Point2D)this.handlePointList.get(4);
                double Ax = A.getX();
                double Ay = A.getY();
                double Bx = B.getX();
                double By = B.getY();
                double Cx = C.getX();
                double Cy = C.getY();
                double Dx = D.getX();
                double Dy = D.getY();
                double distAB2 = Point2D.distanceSq(Ax, Ay, Bx, By);
                double distCD2 = Point2D.distanceSq(Cx, Cy, Dx, Dy);
                double r1 = ((Ay - O.getY()) * (Ay - By) + (Ax - O.getX()) * (Ax - Bx)) / distAB2;
                double r2 = ((Cy - O.getY()) * (Cy - Dy) + (Cx - O.getX()) * (Cx - Dx)) / distCD2;
                Point2D.Double I = new Point2D.Double(Ax + r1 * (Bx - Ax), Ay + r1 * (By - Ay));
                Point2D.Double J = new Point2D.Double(Cx + r2 * (Dx - Cx), Cy + r2 * (Dy - Cy));
                double distOI = O.distance(I);
                double distOJ = O.distance(J);
                Point2D K = distOI < 64.0 ? GeomUtil.getColinearPointWithRatio((Point2D)I, (Point2D)O, (double)1.5) : GeomUtil.getColinearPointWithLength((Point2D)I, (Point2D)O, (double)(distOI + 32.0));
                Point2D L = distOJ < 64.0 ? GeomUtil.getColinearPointWithRatio((Point2D)J, (Point2D)O, (double)1.5) : GeomUtil.getColinearPointWithLength((Point2D)J, (Point2D)O, (double)(distOJ + 32.0));
                double realAngle = K.getY() > L.getY() ? Math.abs(GeomUtil.getSmallestRotationAngleDeg((double)GeomUtil.getAngleDeg((Point2D)J, (Point2D)O, (Point2D)K))) : Math.abs(GeomUtil.getSmallestRotationAngleDeg((double)GeomUtil.getAngleDeg((Point2D)I, (Point2D)O, (Point2D)L)));
                if (Angle.isComputed() && (releaseEvent || Angle.isGraphicLabel())) {
                    measVal.add(new MeasureItem(Angle, realAngle, "deg"));
                }
                if (ComplementaryAngle.isComputed() && (releaseEvent || ComplementaryAngle.isGraphicLabel())) {
                    measVal.add(new MeasureItem(ComplementaryAngle, 180.0 - realAngle, "deg"));
                }
            }
            return measVal;
        }
        return null;
    }
}

