/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.ui.graphic;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import org.weasis.core.ui.graphic.FreeHandGraphic;

public class FreeHandLineGraphic
extends FreeHandGraphic {
    private static final long serialVersionUID = -4598193427257672035L;

    public FreeHandLineGraphic(float lineThickness, Color paint) {
        super(lineThickness, paint, false, true);
    }

    @Override
    public void paintHandles(Graphics2D g2d, AffineTransform transform) {
        if (this.closed) {
            g2d.setPaint(Color.white);
            g2d.setStroke(new BasicStroke(2.0f));
            g2d.draw(this.getShape());
            g2d.setColor(Color.BLACK);
            g2d.setStroke(new BasicStroke(2.0f, 0, 0, 3.0f, new float[]{3.0f}, 0.0f));
            g2d.draw(this.getShape());
        }
    }

    @Override
    public Rectangle getRepaintBounds(Shape shape1) {
        if (shape1 == null) {
            return null;
        }
        Rectangle rectangle = shape1.getBounds();
        int i = (int)(this.lineThickness / 2.0f) + 1;
        rectangle.width += 2 * i + 2;
        rectangle.height += 2 * i + 2;
        rectangle.x -= i - 1;
        rectangle.y -= i - 1;
        return rectangle;
    }

    public float[] getPoints() {
        return this.points;
    }

    @Override
    public Rectangle getRepaintBounds() {
        Shape shape1 = this.getShape();
        if (shape1 == null) {
            return null;
        }
        return this.getRepaintBounds(shape1);
    }
}

