/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.ui.graphic;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.weasis.core.api.gui.util.GeomUtil;
import org.weasis.core.ui.editor.image.DefaultView2d;

public class GraphicLabel {
    protected String[] labelStringArray;
    protected Rectangle2D labelBounds;
    protected double labelWidth;
    protected double labelHeight;
    protected static final int GROWING_BOUND = 3;

    protected void init() {
        this.labelStringArray = null;
        this.labelBounds = null;
        this.labelWidth = 0.0;
        this.labelHeight = 0.0;
    }

    public String[] getLabels() {
        return this.labelStringArray;
    }

    public Rectangle2D getLabelBounds() {
        return this.labelBounds;
    }

    public Rectangle2D getBounds(AffineTransform transform) {
        return this.getArea(transform).getBounds();
    }

    public Area getArea(AffineTransform transform) {
        if (this.labelBounds == null) {
            return new Area();
        }
        Rectangle2D scaledBounds = (Rectangle2D)this.labelBounds.clone();
        double scalingFactor = GeomUtil.extractScalingFactor((AffineTransform)transform);
        if (scalingFactor != 1.0) {
            double invScaledWidth = this.labelBounds.getWidth() / scalingFactor;
            double invScaledHeight = this.labelBounds.getHeight() / scalingFactor;
            scaledBounds.setRect(scaledBounds.getX(), scaledBounds.getY(), invScaledWidth, invScaledHeight);
        }
        Point2D.Double pt1 = new Point2D.Double(1.0, 0.0);
        Point2D pt2 = transform.deltaTransform(pt1, null);
        double rot = GeomUtil.getAngleRad((Point2D)pt2, (Point2D)new Point2D.Double(0.0, 0.0), (Point2D)pt1);
        AffineTransform invRot = AffineTransform.getRotateInstance(-rot, scaledBounds.getX(), scaledBounds.getY());
        Area boundingArea = new Area(scaledBounds);
        boundingArea.transform(invRot);
        return boundingArea;
    }

    public Rectangle2D getTransformedBounds(Rectangle2D realBounds, AffineTransform transform) {
        if (realBounds == null) {
            return null;
        }
        Rectangle2D transformedBounds = (Rectangle2D)realBounds.clone();
        if (transform != null) {
            Point2D.Double p = new Point2D.Double(transformedBounds.getX(), transformedBounds.getY());
            transform.transform(p, p);
            transformedBounds.setRect(p.getX(), p.getY(), transformedBounds.getWidth(), transformedBounds.getHeight());
        }
        return transformedBounds.getBounds();
    }

    public void setLabel(DefaultView2d view2d, double xPos, double yPos, String ... labels) {
        if (view2d == null) {
            throw new RuntimeException("DefaultView2d should not be null !");
        }
        if (labels == null || labels.length == 0) {
            this.init();
        } else {
            this.labelStringArray = labels;
            Font defaultFont = view2d.getEventManager().getViewSetting().getFont();
            FontRenderContext fontRenderContext = ((Graphics2D)view2d.getGraphics()).getFontRenderContext();
            this.updateBoundsSize(defaultFont, fontRenderContext);
            this.labelBounds = new Rectangle2D.Double(xPos + 3.0, yPos + 3.0, this.labelWidth, this.labelHeight * (double)labels.length);
            GeomUtil.growRectangle((Rectangle2D)this.labelBounds, (double)3.0);
        }
    }

    protected void updateBoundsSize(Font defaultFont, FontRenderContext fontRenderContext) {
        if (defaultFont == null) {
            throw new RuntimeException("Font shouldn't ne null");
        }
        if (fontRenderContext == null) {
            throw new RuntimeException("FontRenderContext shouldn't ne null");
        }
        if (this.labelStringArray == null || this.labelStringArray.length == 0) {
            this.labelBounds = null;
            this.labelWidth = 0.0;
            this.labelHeight = 0.0;
        } else {
            double maxWidth = 0.0;
            double maxHeight = 0.0;
            for (String label : this.labelStringArray) {
                if (label.length() <= 0) continue;
                TextLayout layout = new TextLayout(label, defaultFont, fontRenderContext);
                Rectangle2D stringBounds = layout.getBounds();
                maxWidth = Math.max(stringBounds.getWidth(), maxWidth);
                maxHeight = Math.max(stringBounds.getHeight(), maxHeight);
            }
            this.labelHeight = maxHeight;
            this.labelWidth = maxWidth;
        }
    }

    public void paint(Graphics2D g2d, AffineTransform transform, boolean selected) {
        if (this.labelStringArray != null && this.labelBounds != null) {
            Paint oldPaint = g2d.getPaint();
            Point2D.Double pt = new Point2D.Double(this.labelBounds.getX(), this.labelBounds.getY());
            if (transform != null) {
                transform.transform(pt, pt);
            }
            float px = (float)((Point2D)pt).getX() + 3.0f;
            float py = (float)((Point2D)pt).getY() + 3.0f;
            for (String label : this.labelStringArray) {
                if (label.length() <= 0) continue;
                py = (float)((double)py + this.labelHeight);
                this.paintFontOutline(g2d, label, px, py);
            }
            if (selected) {
                this.paintBoundOutline(g2d, transform);
            }
            g2d.setPaint(oldPaint);
        }
    }

    protected void paintBoundOutline(Graphics2D g2d, AffineTransform transform) {
        Rectangle2D boundingRect = this.getTransformedBounds(this.labelBounds, transform);
        g2d.setPaint(Color.BLACK);
        g2d.draw(boundingRect);
        GeomUtil.growRectangle((Rectangle2D)boundingRect, (double)-1.0);
        g2d.setPaint(Color.WHITE);
        g2d.draw(boundingRect);
    }

    protected void paintFontOutline(Graphics2D g2d, String str, float x, float y) {
        Font defaultFont = g2d.getFont();
        FontRenderContext fontRenderContext = g2d.getFontRenderContext();
        assert (defaultFont != null) : "Font shouldn't be null";
        assert (fontRenderContext != null) : "FontRenderContext shouldn't be null";
        TextLayout layout = new TextLayout(str, defaultFont, fontRenderContext);
        g2d.setPaint(Color.BLACK);
        layout.draw(g2d, x - 1.0f, y - 1.0f);
        layout.draw(g2d, x - 1.0f, y);
        layout.draw(g2d, x - 1.0f, y + 1.0f);
        layout.draw(g2d, x, y - 1.0f);
        layout.draw(g2d, x, y + 1.0f);
        layout.draw(g2d, x + 1.0f, y - 1.0f);
        layout.draw(g2d, x + 1.0f, y);
        layout.draw(g2d, x + 1.0f, y + 1.0f);
        g2d.setPaint(Color.WHITE);
        layout.draw(g2d, x, y);
    }

    @Deprecated
    public double getOffsetX() {
        return 3.0;
    }

    @Deprecated
    public double getOffsetY() {
        if (this.labelBounds == null) {
            return 0.0;
        }
        return -10.0;
    }

    @Deprecated
    public Rectangle getBound() {
        return this.labelBounds == null ? null : this.labelBounds.getBounds2D().getBounds();
    }

    @Deprecated
    public void setLabelBound(double x, double y, double width, double height) {
        if (this.labelBounds == null) {
            this.labelBounds = new Rectangle2D.Double(x, y, width, height).getBounds();
        } else {
            this.labelBounds.setRect(x, y, width, height);
        }
    }
}

