/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.ui.graphic;

import java.awt.Color;
import java.awt.event.MouseEvent;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.weasis.core.api.gui.util.MathUtil;
import org.weasis.core.api.image.measure.MeasurementsAdapter;
import org.weasis.core.api.media.data.ImageElement;
import org.weasis.core.ui.Messages;
import org.weasis.core.ui.graphic.AbstractDragGraphic;
import org.weasis.core.ui.graphic.Graphic;
import org.weasis.core.ui.graphic.MeasureItem;
import org.weasis.core.ui.graphic.Measurement;

public class LineGraphic
extends AbstractDragGraphic {
    public static final Icon ICON = new ImageIcon(LineGraphic.class.getResource("/icon/22x22/draw-line.png"));
    public static final Measurement FirstPointX = new Measurement("First point X", true);
    public static final Measurement FirstPointY = new Measurement("First point Y", true);
    public static final Measurement LastPointX = new Measurement("Last point X", true);
    public static final Measurement LastPointY = new Measurement("Last point Y", true);
    public static final Measurement LineLength = new Measurement("Line length", true);
    public static final Measurement Orientation = new Measurement("Orientation", true);
    public static final Measurement OrientationSignificance = new Measurement("Orientation significance", true);
    public static final Measurement Azimuth = new Measurement("Azimuth", true);
    public static final Measurement AzimuthSignificance = new Measurement("Azimuth significance", true);
    public static final Measurement BarycenterX = new Measurement("Barycenter X", true);
    public static final Measurement BarycenterY = new Measurement("Barycenter Y", true);
    public static final Measurement ColorRGB = new Measurement("Color (RGB)", true);

    public LineGraphic(float lineThickness, Color paintColor, boolean labelVisible) {
        super(2, paintColor, lineThickness, labelVisible);
    }

    public Icon getIcon() {
        return ICON;
    }

    public String getUIName() {
        return Messages.getString("MeasureToolBar.line");
    }

    @Override
    protected void updateShapeOnDrawing(MouseEvent mouseEvent) {
        GeneralPath generalpath = new GeneralPath(1, this.handlePointList.size());
        if (this.handlePointList.size() >= 1) {
            Point2D A = (Point2D)this.handlePointList.get(0);
            generalpath.moveTo(A.getX(), A.getY());
            if (this.handlePointList.size() >= 2) {
                Point2D B = (Point2D)this.handlePointList.get(1);
                generalpath.lineTo(B.getX(), B.getY());
            }
        }
        this.setShape(generalpath, mouseEvent);
        this.updateLabel(mouseEvent, this.getDefaultView2d(mouseEvent));
    }

    @Override
    public LineGraphic clone() {
        return (LineGraphic)super.clone();
    }

    @Override
    public Graphic clone(int xPos, int yPos) {
        LineGraphic newGraphic = this.clone();
        newGraphic.updateStroke();
        newGraphic.updateShapeOnDrawing(null);
        return newGraphic;
    }

    public static Area createAreaForLine(float x1, float y1, float x2, float y2, int width) {
        int i = width;
        int j = 0;
        int or = (int)MathUtil.getOrientation((double)x1, (double)y1, (double)x2, (double)y2);
        if (or < 45 || or > 135) {
            j = i;
            i = 0;
        }
        GeneralPath generalpath = new GeneralPath();
        generalpath.moveTo(x1 - (float)i, y1 - (float)j);
        generalpath.lineTo(x1 + (float)i, y1 + (float)j);
        generalpath.lineTo(x2 + (float)i, y2 + (float)j);
        generalpath.lineTo(x2 - (float)i, y2 - (float)j);
        generalpath.lineTo(x1 - (float)i, y1 - (float)j);
        generalpath.closePath();
        return new Area(generalpath);
    }

    public double getSegmentLength() {
        if (this.handlePointList.size() >= 1) {
            Point2D A = (Point2D)this.handlePointList.get(0);
            if (this.handlePointList.size() >= 2) {
                Point2D B = (Point2D)this.handlePointList.get(1);
                return A.distance(B);
            }
        }
        return -1.0;
    }

    public double getSegmentLength(double scalex, double scaley) {
        if (this.handlePointList.size() >= 1) {
            Point2D A = (Point2D)this.handlePointList.get(0);
            if (this.handlePointList.size() >= 2) {
                Point2D B = (Point2D)this.handlePointList.get(1);
                return Point2D.distance(scalex * A.getX(), scaley * A.getY(), scalex * B.getX(), scaley * B.getY());
            }
        }
        return -1.0;
    }

    public Point2D getStartPoint() {
        if (this.handlePointList.size() >= 1) {
            return (Point2D)((Point2D)this.handlePointList.get(0)).clone();
        }
        return null;
    }

    public Point2D getEndPoint() {
        if (this.handlePointList.size() > 1) {
            return (Point2D)((Point2D)this.handlePointList.get(1)).clone();
        }
        return null;
    }

    @Override
    public List<MeasureItem> getMeasurements(ImageElement imageElement, boolean releaseEvent) {
        MeasurementsAdapter adapter;
        if (imageElement != null && (adapter = imageElement.getMeasurementAdapter()) != null) {
            Double val;
            Point2D p;
            ArrayList<MeasureItem> measVal = new ArrayList<MeasureItem>();
            if (FirstPointX.isComputed() || FirstPointY.isComputed()) {
                p = this.getStartPoint();
                if (FirstPointX.isComputed() && (releaseEvent || FirstPointX.isGraphicLabel())) {
                    val = releaseEvent || FirstPointX.isQuickComputing() ? Double.valueOf(adapter.getXCalibratedValue(p.getX())) : null;
                    measVal.add(new MeasureItem(FirstPointX, val, adapter.getUnit()));
                }
                if (FirstPointY.isComputed() && (releaseEvent || FirstPointY.isGraphicLabel())) {
                    val = releaseEvent || FirstPointY.isQuickComputing() ? Double.valueOf(adapter.getXCalibratedValue(p.getY())) : null;
                    measVal.add(new MeasureItem(FirstPointY, val, adapter.getUnit()));
                }
            }
            if (LastPointX.isComputed() || LastPointY.isComputed()) {
                p = this.getEndPoint();
                if (LastPointX.isComputed() && (releaseEvent || LastPointX.isGraphicLabel())) {
                    val = releaseEvent || LastPointX.isQuickComputing() ? Double.valueOf(adapter.getXCalibratedValue(p.getX())) : null;
                    measVal.add(new MeasureItem(LastPointX, val, adapter.getUnit()));
                }
                if (LastPointY.isComputed() && (releaseEvent || LastPointY.isGraphicLabel())) {
                    val = releaseEvent || LastPointY.isQuickComputing() ? Double.valueOf(adapter.getXCalibratedValue(p.getY())) : null;
                    measVal.add(new MeasureItem(LastPointY, val, adapter.getUnit()));
                }
            }
            if (LineLength.isComputed() && (releaseEvent || LineLength.isGraphicLabel())) {
                Double val2 = releaseEvent || LineLength.isQuickComputing() ? Double.valueOf(this.getSegmentLength(adapter.getCalibRatio(), adapter.getCalibRatio())) : null;
                measVal.add(new MeasureItem(LineLength, val2, adapter.getUnit()));
            }
            return measVal;
        }
        return null;
    }
}

