/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.ui.graphic;

import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import org.weasis.core.api.gui.util.JMVUtils;
import org.weasis.core.api.gui.util.MathUtil;
import org.weasis.core.api.image.measure.MeasurementsAdapter;
import org.weasis.core.ui.graphic.AbstractDragGraphic;
import org.weasis.core.ui.graphic.ChainPoint;
import org.weasis.core.ui.graphic.LineGraphic;
import org.weasis.core.ui.graphic.PolygonGraphic;
import org.weasis.core.ui.graphic.RasterizeGraphicsToCoord;

public class Measure1DAnalyse {
    public static final String[] measurList = new String[]{"First point X", "First point Y", "Last point X", "Last point Y", "Line length", "Orientation", "Orientation significance", "Azimuth", "Azimuth significance", "Barycenter x", "Barycenter y", "Color (RGB)"};
    private MeasurementsAdapter adapter;
    private AbstractDragGraphic line;
    private double[] regression;
    private ArrayList<ChainPoint> pointList = null;
    private double length = -1.0;

    public Measure1DAnalyse(AbstractDragGraphic line, MeasurementsAdapter adapter) {
        this.line = line;
        this.adapter = adapter;
    }

    public ArrayList getMeasure1DAnalyse(boolean[] selected, int nbMeasures) {
        ArrayList<Object> measVal = new ArrayList<Object>(nbMeasures);
        if (selected[0]) {
            measVal.add(this.adapter.getXCalibratedValue(this.getStartPointX()));
        }
        if (selected[1]) {
            measVal.add(this.adapter.getYCalibratedValue(this.getStartPointY()));
        }
        if (selected[2]) {
            measVal.add(this.adapter.getXCalibratedValue(this.getEndPointX()));
        }
        if (selected[3]) {
            measVal.add(this.adapter.getYCalibratedValue(this.getEndPointY()));
        }
        if (selected[4]) {
            measVal.add(this.getSegmentLength());
        }
        if (selected[5]) {
            measVal.add(this.getSegmentOrientation());
        }
        if (selected[6]) {
            measVal.add(this.getCorrelationCoefficient());
        }
        if (selected[7]) {
            measVal.add(this.getSegmentAzimuth());
        }
        if (selected[8]) {
            measVal.add(this.getOrientationIndice());
        }
        if (selected[9]) {
            measVal.add(this.adapter.getXCalibratedValue(this.getBarycenterX()));
        }
        if (selected[10]) {
            measVal.add(this.adapter.getYCalibratedValue(this.getBarycenterY()));
        }
        if (selected[11]) {
            measVal.add(JMVUtils.getValueRGBasText2((Color)((Color)this.line.getColorPaint())));
        }
        return measVal;
    }

    public double getStartPointX() {
        if (this.line instanceof LineGraphic) {
            return ((LineGraphic)this.line).getStartPoint().getX();
        }
        return 0.0;
    }

    public double getStartPointY() {
        if (this.line instanceof LineGraphic) {
            return ((LineGraphic)this.line).getStartPoint().getY();
        }
        return 0.0;
    }

    public double getEndPointX() {
        if (this.line instanceof LineGraphic) {
            return ((LineGraphic)this.line).getEndPoint().getX();
        }
        return 0.0;
    }

    public double getEndPointY() {
        if (this.line instanceof LineGraphic) {
            return ((LineGraphic)this.line).getEndPoint().getY();
        }
        return 0.0;
    }

    public double getBarycenterX() {
        if (this.line instanceof LineGraphic) {
            double x2;
            LineGraphic graph = (LineGraphic)this.line;
            double x1 = graph.getStartPoint().getX();
            double offset = x1 > (x2 = graph.getEndPoint().getX()) ? x2 : x1;
            return offset + Math.abs((x2 - x1) / 2.0);
        }
        return 0.0;
    }

    public double getBarycenterY() {
        if (this.line instanceof LineGraphic) {
            double y2;
            LineGraphic graph = (LineGraphic)this.line;
            double y1 = graph.getStartPoint().getY();
            double offset = y1 > (y2 = graph.getEndPoint().getY()) ? y2 : y1;
            return offset + Math.abs((y2 - y1) / 2.0);
        }
        return 0.0;
    }

    public static Point2D getBaryCenter(ArrayList<ChainPoint> list) {
        double x = 0.0;
        double y = 0.0;
        for (int i = 0; i < list.size(); ++i) {
            ChainPoint p = list.get(i);
            x += (double)p.x;
            y += (double)p.y;
        }
        return new Point2D.Double(x /= (double)list.size(), y /= (double)list.size());
    }

    public double getSegmentLength() {
        if (this.line instanceof LineGraphic) {
            return ((LineGraphic)this.line).getSegmentLength(this.adapter.getCalibRatio(), this.adapter.getCalibRatio());
        }
        return 0.0;
    }

    public double getOrientationIndice() {
        if (this.line instanceof LineGraphic) {
            return 1.0;
        }
        return 0.0;
    }

    public ArrayList<ChainPoint> getPointList(float[] points) {
        if (this.pointList == null) {
            this.pointList = RasterizeGraphicsToCoord.rasterizeFreehandline(points);
        }
        return this.pointList;
    }

    public double getCorrelationCoefficient() {
        if (this.line instanceof LineGraphic) {
            return 1.0;
        }
        return 0.0;
    }

    private double getCorrelationCoefficient(float[] points) {
        double angle;
        if (this.regression == null) {
            this.regression = Measure1DAnalyse.regression(this.getPointList(points));
        }
        if ((angle = this.getSegmentOrientation(points)) < 5.0 || angle > 175.0 || angle > 85.0 && angle < 95.0) {
            AffineTransform trans = AffineTransform.getRotateInstance(0.7853981633974483, points[0], points[1]);
            Shape r = trans.createTransformedShape(this.line.getShape());
            double[] reg = Measure1DAnalyse.regression(RasterizeGraphicsToCoord.rasterizeFreehandline(this.getCoordinates(r, points.length)));
            this.regression[2] = reg[2];
        }
        return Math.abs(this.regression[2]);
    }

    private float[] getCoordinates(Shape shape, int nbPoints) {
        PathIterator iterator = shape.getPathIterator(null);
        float[] points = new float[nbPoints];
        float[] floats = new float[6];
        int nbSeg = 0;
        while (!iterator.isDone()) {
            int segType = iterator.currentSegment(floats);
            switch (segType) {
                case 0: 
                case 1: {
                    points[nbSeg++] = floats[0];
                    points[nbSeg++] = floats[1];
                }
            }
            iterator.next();
        }
        return points;
    }

    public double getSegmentOrientation() {
        if (this.line instanceof LineGraphic) {
            Point2D p1 = ((LineGraphic)this.line).getStartPoint();
            Point2D p2 = ((LineGraphic)this.line).getEndPoint();
            return MathUtil.getOrientation((double)p1.getX(), (double)p1.getY(), (double)p2.getX(), (double)p2.getY());
        }
        return 0.0;
    }

    public double getSegmentOrientation(float[] points) {
        double x1 = points[0];
        double x2 = points[points.length - 2];
        if (this.regression == null) {
            this.regression = Measure1DAnalyse.regression(this.getPointList(points));
        }
        if (x1 == x2) {
            double d = x2 = (double)points[points.length - 4] < x2 ? x2 + 5.0 : x2 - 5.0;
        }
        if (this.regression[0] == 0.0) {
            return MathUtil.getOrientation((double)x1, (double)points[1], (double)x2, (double)points[points.length - 1]);
        }
        return MathUtil.getOrientation((double)x1, (double)(this.regression[0] * x1 + this.regression[1]), (double)x2, (double)(this.regression[0] * x2 + this.regression[1]));
    }

    public double getSegmentAzimuth() {
        if (this.line instanceof LineGraphic) {
            Point2D p1 = ((LineGraphic)this.line).getStartPoint();
            Point2D p2 = ((LineGraphic)this.line).getEndPoint();
            return MathUtil.getAzimuth((double)p1.getX(), (double)p1.getY(), (double)p2.getX(), (double)p2.getY());
        }
        return 0.0;
    }

    public double getSegmentAzimuth(float[] points) {
        double x1 = points[0];
        double x2 = points[points.length - 2];
        if (this.regression == null) {
            this.regression = Measure1DAnalyse.regression(this.getPointList(points));
        }
        if (x1 == x2) {
            double d = x2 = (double)points[points.length - 4] < x2 ? x2 + 5.0 : x2 - 5.0;
        }
        if (this.regression[0] == 0.0) {
            return MathUtil.getAzimuth((double)x1, (double)points[1], (double)x2, (double)points[points.length - 1]);
        }
        return MathUtil.getAzimuth((double)x1, (double)(this.regression[0] * x1 + this.regression[1]), (double)x2, (double)(this.regression[0] * x2 + this.regression[1]));
    }

    public static double getPolygonPerimeter(PolygonGraphic graph) {
        float[] coord = graph.getPoints();
        double perimeter = 0.0;
        if (coord != null && coord.length > 2) {
            float x1 = coord[0];
            float y1 = coord[1];
            for (int m = 2; m < coord.length; m += 2) {
                float x2 = coord[m];
                float y2 = coord[m + 1];
                perimeter += (double)((float)Math.sqrt((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2)));
                x1 = x2;
                y1 = y2;
            }
        }
        return perimeter;
    }

    public static ArrayList<String> getObjectMeasureList(boolean[] select) {
        ArrayList<String> list = new ArrayList<String>(select.length);
        for (int i = 0; i < select.length; ++i) {
            if (!select[i]) continue;
            list.add(measurList[i]);
        }
        list.trimToSize();
        return list;
    }

    public static String[] createHeaders(boolean[] selected) {
        ArrayList<String> measures = Measure1DAnalyse.getObjectMeasureList(selected);
        return measures.toArray(new String[measures.size()]);
    }

    public static double[] regression(ArrayList<ChainPoint> list) {
        double mean_x = 0.0;
        double mean_y = 0.0;
        for (int i = 0; i < list.size(); ++i) {
            ChainPoint p = list.get(i);
            mean_x += (double)p.x;
            mean_y += (double)p.y;
        }
        mean_x /= (double)list.size();
        mean_y /= (double)list.size();
        double mean_x2 = 0.0;
        double mean_y2 = 0.0;
        double mean_xy = 0.0;
        for (int i = 0; i < list.size(); ++i) {
            ChainPoint p = list.get(i);
            double xi = p.x;
            double yi = p.y;
            mean_x2 += (xi -= mean_x) * xi;
            mean_y2 += yi * yi;
            mean_xy += xi * yi;
        }
        mean_y2 /= (double)list.size();
        double[] val = new double[3];
        val[0] = (mean_xy /= (double)list.size()) / (mean_x2 /= (double)list.size());
        if (Double.isNaN(val[0])) {
            val[0] = 0.0;
        }
        val[1] = mean_y - mean_x * val[0];
        val[2] = mean_xy / Math.sqrt(mean_x2 * (mean_y2 - mean_y * mean_y));
        if (Double.isInfinite(val[2]) || Double.isNaN(val[2])) {
            val[2] = 1.0;
        }
        return val;
    }

    public static double computePerimeter(byte[] chain) {
        double perimeter = 0.0;
        int corner = 0;
        int evenCode = 0;
        int oddCode = 0;
        if (chain.length == 0) {
            perimeter = 2.0;
            return 2.0;
        }
        if (chain[0] % 2 != 0) {
            ++oddCode;
        } else {
            ++evenCode;
        }
        for (int i = 1; i < chain.length; ++i) {
            byte code = chain[i];
            if (code % 2 != 0) {
                ++oddCode;
            } else {
                ++evenCode;
            }
            if (code == chain[i - 1]) continue;
            ++corner;
        }
        perimeter = 0.98 * (double)evenCode + 1.406 * (double)oddCode - 0.091 * (double)corner;
        return perimeter;
    }
}

