/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.ui.graphic;

import java.awt.Color;
import java.awt.Window;
import org.weasis.core.ui.graphic.AbstractDragGraphic;
import org.weasis.core.ui.graphic.LineGraphic;
import org.weasis.core.ui.graphic.PropertiesDialog;

public class MeasureDialog
extends PropertiesDialog {
    private AbstractDragGraphic graphic;

    public MeasureDialog(Window parent, AbstractDragGraphic graphic) {
        super(parent, "Drawing Properties");
        this.graphic = graphic;
        this.iniGraphicDialog();
        this.pack();
    }

    @Override
    protected boolean hasChanged() {
        boolean hasChanged = false;
        if (this.jCheckBoxFilled.isSelected() != this.graphic.isFilled() || !this.graphic.getColorPaint().equals(this.jPVButtonColor.getBackground()) || ((Integer)this.jPVSpinLineWidth.getValue()).floatValue() != this.graphic.getLineThickness()) {
            hasChanged = true;
        }
        return hasChanged;
    }

    public void iniGraphicDialog() {
        if (this.graphic == null) {
            return;
        }
        if (this.graphic instanceof LineGraphic) {
            this.jLabelLineColor1.setText("Line color :");
            this.jCheckBoxFilled.setEnabled(false);
        } else {
            this.jCheckBoxFilled.setSelected(this.graphic.isFilled());
        }
        this.jPVButtonColor.setBackground((Color)this.graphic.getColorPaint());
        this.jPVSpinLineWidth.setValue((int)this.graphic.getLineThickness());
    }

    @Override
    protected void okAction() {
        this.graphic.setLineThickness(((Integer)this.jPVSpinLineWidth.getValue()).floatValue());
        this.graphic.setPaint(this.jPVButtonColor.getBackground());
        if (this.jCheckBoxFilled.isEnabled()) {
            this.graphic.setFilled(this.jCheckBoxFilled.isSelected());
        }
        this.dispose();
    }
}

