/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.ui.graphic;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.weasis.core.api.gui.util.DecFormater;
import org.weasis.core.api.gui.util.GeomUtil;
import org.weasis.core.api.media.data.ImageElement;
import org.weasis.core.ui.graphic.AbstractDragGraphic;
import org.weasis.core.ui.graphic.MeasureItem;
import org.weasis.core.ui.graphic.Measurement;

public class OpenAngleToolGraphic
extends AbstractDragGraphic {
    public static final Icon ICON = new ImageIcon(OpenAngleToolGraphic.class.getResource("/icon/22x22/draw-open-angle.png"));
    public static final Measurement Angle = new Measurement("Angle", true);
    public static final Measurement ComplementaryAngle = new Measurement("Complementary Angle", true);
    protected Stroke strokeDecorator;
    protected Stroke strokeDecorator2;

    public OpenAngleToolGraphic(float lineThickness, Color paintColor, boolean labelVisible) {
        super(4, paintColor, lineThickness, labelVisible);
    }

    public Icon getIcon() {
        return ICON;
    }

    public String getUIName() {
        return "Open Angle";
    }

    @Override
    protected void updateStroke() {
        super.updateStroke();
        this.strokeDecorator = new BasicStroke(this.lineThickness, 0, 0, 10.0f, new float[]{5.0f, 5.0f}, 0.0f);
        this.strokeDecorator2 = new BasicStroke(0.5f, 0, 0);
    }

    @Override
    protected void updateShapeOnDrawing(MouseEvent mouseEvent) {
        if (this.handlePointList.size() >= 1) {
            Point2D A = (Point2D)this.handlePointList.get(0);
            if (this.handlePointList.size() >= 2) {
                AbstractDragGraphic.AdvancedShape newShape = new AbstractDragGraphic.AdvancedShape(5);
                Path2D.Double generalpath = new Path2D.Double(1, this.handlePointList.size());
                newShape.addShape(generalpath);
                Point2D B = (Point2D)this.handlePointList.get(1);
                ((Path2D)generalpath).moveTo(A.getX(), A.getY());
                ((Path2D)generalpath).lineTo(B.getX(), B.getY());
                if (this.handlePointList.size() >= 3) {
                    Point2D C = (Point2D)this.handlePointList.get(2);
                    if (this.handlePointList.size() == 4) {
                        Point2D D = (Point2D)this.handlePointList.get(3);
                        ((Path2D)generalpath).moveTo(C.getX(), C.getY());
                        ((Path2D)generalpath).lineTo(D.getX(), D.getY());
                        double Ax = A.getX();
                        double Ay = A.getY();
                        double Bx = B.getX();
                        double By = B.getY();
                        double Cx = C.getX();
                        double Cy = C.getY();
                        double Dx = D.getX();
                        double Dy = D.getY();
                        double denominator = (Bx - Ax) * (Dy - Cy) - (By - Ay) * (Dx - Cx);
                        if (denominator != 0.0) {
                            Point2D switchPoint;
                            double r = ((Ay - Cy) * (Dx - Cx) - (Ax - Cx) * (Dy - Cy)) / denominator;
                            double s = ((Ay - Cy) * (Bx - Ax) - (Ax - Cx) * (By - Ay)) / denominator;
                            Point2D.Double P = new Point2D.Double(Ax + r * (Bx - Ax), Ay + r * (By - Ay));
                            Point2D[] pts1 = new Point2D[3];
                            Point2D[] pts2 = new Point2D[3];
                            Point2D point2D = pts1[0] = r >= 0.0 ? A : B;
                            Point2D point2D2 = r < 0.0 ? A : (pts1[1] = r > 1.0 ? B : P);
                            Point2D point2D3 = r < 0.0 ? P : (pts1[2] = r > 1.0 ? P : B);
                            if (pts1[1].equals(P) && pts1[1].distance(pts1[0]) < pts1[1].distance(pts1[2])) {
                                switchPoint = (Point2D)pts1[2].clone();
                                pts1[2] = (Point2D)pts1[0].clone();
                                pts1[0] = switchPoint;
                            }
                            Point2D point2D4 = pts2[0] = s >= 0.0 ? C : D;
                            Point2D point2D5 = s < 0.0 ? C : (pts2[1] = s > 1.0 ? D : P);
                            Point2D point2D6 = s < 0.0 ? P : (pts2[2] = s > 1.0 ? P : D);
                            if (pts2[1].equals(P) && pts2[1].distance(pts2[0]) < pts2[1].distance(pts2[2])) {
                                switchPoint = (Point2D)pts2[2].clone();
                                pts2[2] = (Point2D)pts2[0].clone();
                                pts2[0] = switchPoint;
                            }
                            Point2D I1 = GeomUtil.getColinearPointWithRatio((Point2D)pts1[1], (Point2D)pts1[0], (double)0.25);
                            Point2D J1 = GeomUtil.getColinearPointWithRatio((Point2D)pts2[1], (Point2D)pts2[0], (double)0.25);
                            Point2D I2 = GeomUtil.getColinearPointWithRatio((Point2D)pts1[0], (Point2D)pts1[1], (double)0.25);
                            Point2D J2 = GeomUtil.getColinearPointWithRatio((Point2D)pts2[0], (Point2D)pts2[1], (double)0.25);
                            double maxRadius = Math.min(P.distance(I2), P.distance(J2));
                            double radius = Math.min(maxRadius, (P.distance(I1) + P.distance(J1)) / 2.0);
                            double angularExtent = GeomUtil.getAngleDeg((Point2D)pts1[0], (Point2D)P, (Point2D)pts2[0]);
                            angularExtent = GeomUtil.getSmallestRotationAngleDeg((double)angularExtent);
                            double startingAngle = GeomUtil.getAngleDeg((Point2D)P, (Point2D)pts1[0]);
                            Rectangle2D.Double arcAngleBounds = new Rectangle2D.Double(((Point2D)P).getX() - radius, ((Point2D)P).getY() - radius, 2.0 * radius, 2.0 * radius);
                            Arc2D.Double arcAngle = new Arc2D.Double(arcAngleBounds, startingAngle, angularExtent, 0);
                            newShape.addShape(arcAngle);
                            if (pts1[2].equals(P)) {
                                newShape.addShape(new Line2D.Double(pts1[2], pts1[1]), this.strokeDecorator);
                            }
                            if (pts2[2].equals(P)) {
                                newShape.addShape(new Line2D.Double(pts2[2], pts2[1]), this.strokeDecorator);
                            }
                            int size = 8;
                            Point2D.Double K = new Point2D.Double(((Point2D)P).getX() - (double)size, ((Point2D)P).getY());
                            Point2D.Double L = new Point2D.Double(((Point2D)P).getX() + (double)size, ((Point2D)P).getY());
                            Point2D.Double M = new Point2D.Double(((Point2D)P).getX(), ((Point2D)P).getY() - (double)size);
                            Point2D.Double N = new Point2D.Double(((Point2D)P).getX(), ((Point2D)P).getY() + (double)size);
                            Path2D.Double intersectPtShape = new Path2D.Double(1, 3);
                            intersectPtShape.append(new Line2D.Double(K, L), false);
                            intersectPtShape.append(new Line2D.Double(M, N), false);
                            Point2D intersecPt = GeomUtil.getIntersectPoint((Point2D)K, (Point2D)L, (Point2D)M, (Point2D)N);
                            Rectangle2D.Double intersecPtBounds = new Rectangle2D.Double(intersecPt.getX() - (double)size / 2.0, intersecPt.getY() - (double)size / 2.0, size, size);
                            intersectPtShape.append(new Arc2D.Double(intersecPtBounds, 0.0, 360.0, 0), false);
                            newShape.addInvShape((Shape)intersectPtShape, (Point2D)P.clone(), this.strokeDecorator2);
                            Rectangle rect = generalpath.getBounds();
                            int xPos = rect.x + rect.width;
                            int yPos = (int)Math.ceil((double)rect.y + (double)rect.height * 0.5);
                            String label = this.getRealAngleLabel(this.getImageElement(mouseEvent), pts1[0], P, pts2[0]);
                            this.setLabel(new String[]{label}, this.getDefaultView2d(mouseEvent), xPos, yPos);
                        }
                    }
                }
                this.setShape(newShape, mouseEvent);
            }
        }
    }

    @Override
    public List<MeasureItem> getMeasurements(ImageElement imageElement, boolean releaseEvent) {
        return null;
    }

    protected String getRealAngleLabel(ImageElement image, Point2D A, Point2D O, Point2D B) {
        String label = "";
        if (image != null) {
            AffineTransform rescale = AffineTransform.getScaleInstance(image.getPixelSize(), image.getPixelSize());
            Point2D At = rescale.transform(A, null);
            Point2D Ot = rescale.transform(O, null);
            Point2D Bt = rescale.transform(B, null);
            double realAngle = GeomUtil.getSmallestRotationAngleDeg((double)GeomUtil.getAngleDeg((Point2D)At, (Point2D)Ot, (Point2D)Bt));
            label = "Angle : " + DecFormater.twoDecimal((double)Math.abs(realAngle)) + "\u00b0";
            label = label + " / " + DecFormater.twoDecimal((double)(180.0 - Math.abs(realAngle))) + "\u00b0";
        }
        return label;
    }
}

