/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.ui.graphic;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.weasis.core.api.gui.util.DecFormater;
import org.weasis.core.api.gui.util.GeomUtil;
import org.weasis.core.api.image.util.Unit;
import org.weasis.core.api.media.data.ImageElement;
import org.weasis.core.ui.Messages;
import org.weasis.core.ui.graphic.AbstractDragGraphic;
import org.weasis.core.ui.graphic.MeasureItem;

public class PerpendicularLineGraphic
extends AbstractDragGraphic {
    public static final Icon ICON = new ImageIcon(PerpendicularLineGraphic.class.getResource("/icon/22x22/draw-perpendicular.png"));
    private Stroke strokeDecorator;

    public PerpendicularLineGraphic(float lineThickness, Color paintColor, boolean labelVisible) {
        super(4, paintColor, lineThickness, labelVisible);
    }

    public Icon getIcon() {
        return ICON;
    }

    public String getUIName() {
        return Messages.getString("MeasureToolBar.perpendicular");
    }

    @Override
    protected void updateStroke() {
        super.updateStroke();
        this.strokeDecorator = new BasicStroke(this.lineThickness, 0, 0, 10.0f, new float[]{5.0f, 5.0f}, 0.0f);
    }

    @Override
    protected int moveAndResizeOnDrawing(int handlePointIndex, int deltaX, int deltaY, MouseEvent mouseEvent) {
        if (handlePointIndex == -1) {
            handlePointIndex = super.moveAndResizeOnDrawing(handlePointIndex, deltaX, deltaY, mouseEvent);
        } else if (!this.isGraphicComplete()) {
            ((Point2D)this.handlePointList.get(handlePointIndex)).setLocation(mouseEvent.getPoint());
            if (this.handlePointList.size() >= 3) {
                Point2D A = (Point2D)this.handlePointList.get(0);
                Point2D B = (Point2D)this.handlePointList.get(1);
                Point2D C = (Point2D)this.handlePointList.get(2);
                while (this.handlePointList.size() < this.handlePointTotalNumber) {
                    this.handlePointList.add(new Point2D.Double());
                }
                Point2D D = (Point2D)this.handlePointList.get(3);
                D.setLocation(GeomUtil.getPerpendicularPointToLine((Point2D)A, (Point2D)B, (Point2D)C));
            }
        } else {
            Point2D A = (Point2D)this.handlePointList.get(0);
            Point2D B = (Point2D)this.handlePointList.get(1);
            Point2D C = (Point2D)this.handlePointList.get(2);
            Point2D D = (Point2D)this.handlePointList.get(3);
            if (handlePointIndex == 0 || handlePointIndex == 1) {
                double theta = GeomUtil.getAngleRad((Point2D)A, (Point2D)B);
                ((Point2D)this.handlePointList.get(handlePointIndex)).setLocation(mouseEvent.getPoint());
                Point2D anchor = handlePointIndex == 0 ? B : A;
                AffineTransform transform = AffineTransform.getRotateInstance(theta -= GeomUtil.getAngleRad((Point2D)A, (Point2D)B), anchor.getX(), anchor.getY());
                transform.transform(C, C);
                transform.transform(D, D);
            } else if (handlePointIndex == 2) {
                ((Point2D)this.handlePointList.get(handlePointIndex)).setLocation(mouseEvent.getPoint());
                D.setLocation(GeomUtil.getPerpendicularPointToLine((Point2D)A, (Point2D)B, (Point2D)C));
            } else if (handlePointIndex == 3) {
                double tx = D.getX();
                double ty = D.getY();
                D.setLocation(GeomUtil.getPerpendicularPointToLine((Point2D)A, (Point2D)B, (Point2D)mouseEvent.getPoint()));
                AffineTransform.getTranslateInstance(-(tx -= D.getX()), -(ty -= D.getY())).transform(C, C);
            }
        }
        return handlePointIndex;
    }

    @Override
    protected void updateShapeOnDrawing(MouseEvent mouseEvent) {
        if (this.handlePointList.size() >= 1) {
            Point2D A = (Point2D)this.handlePointList.get(0);
            if (this.handlePointList.size() >= 2) {
                Point2D B = (Point2D)this.handlePointList.get(1);
                AbstractDragGraphic.AdvancedShape newShape = new AbstractDragGraphic.AdvancedShape(3);
                if (!A.equals(B)) {
                    GeneralPath generalpath = new GeneralPath(1, this.handlePointList.size() / 2);
                    newShape.addShape(generalpath);
                    generalpath.moveTo(A.getX(), A.getY());
                    generalpath.lineTo(B.getX(), B.getY());
                    if (this.handlePointList.size() >= 3) {
                        Point2D D;
                        Point2D C = (Point2D)this.handlePointList.get(2);
                        if (this.handlePointList.size() == 4 && !C.equals(D = (Point2D)this.handlePointList.get(3))) {
                            generalpath.moveTo(C.getX(), C.getY());
                            generalpath.lineTo(D.getX(), D.getY());
                            String label = "";
                            label = this.getRealDistanceLabel(this.getImageElement(mouseEvent), C, D);
                            this.setLabel(new String[]{label}, this.getDefaultView2d(mouseEvent));
                            if (Math.signum(GeomUtil.getAngleDeg((Point2D)D, (Point2D)A)) == Math.signum(GeomUtil.getAngleDeg((Point2D)D, (Point2D)B))) {
                                Point2D E;
                                Point2D point2D = E = D.distance(A) < D.distance(B) ? A : B;
                                if (!D.equals(E)) {
                                    newShape.addShape(new Line2D.Double(D, E), this.strokeDecorator);
                                }
                            }
                            double cornerLength = 10.0;
                            double dMin = 0.6666666666666666 * Math.min(D.distance(C), Math.max(D.distance(A), D.distance(B)));
                            double scalingMin = cornerLength / dMin;
                            Point2D F = GeomUtil.getMidPoint((Point2D)A, (Point2D)B);
                            if (!D.equals(C) && !F.equals(D)) {
                                newShape.addInvShape(GeomUtil.getCornerShape((Point2D)F, (Point2D)D, (Point2D)C, (double)cornerLength), (Point2D)D.clone(), scalingMin);
                            }
                        }
                    }
                }
                this.setShape(newShape, mouseEvent);
            }
        }
    }

    @Override
    public List<MeasureItem> getMeasurements(ImageElement imageElement, boolean releaseEvent) {
        return null;
    }

    protected String getRealDistanceLabel(ImageElement image, Point2D A, Point2D B) {
        String label = "";
        if (image != null) {
            AffineTransform rescale = AffineTransform.getScaleInstance(image.getPixelSize(), image.getPixelSize());
            Point2D At = rescale.transform(A, null);
            Point2D Bt = rescale.transform(B, null);
            Unit unit = image.getPixelSpacingUnit();
            label = "Dist : " + DecFormater.twoDecimal((double)At.distance(Bt)) + " " + unit.getAbbreviation();
        }
        return label;
    }
}

