/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.ui.graphic;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.weasis.core.api.media.data.ImageElement;
import org.weasis.core.ui.Messages;
import org.weasis.core.ui.editor.image.DefaultView2d;
import org.weasis.core.ui.graphic.AbstractDragGraphicOld;
import org.weasis.core.ui.graphic.DragSequence;
import org.weasis.core.ui.graphic.Graphic;
import org.weasis.core.ui.graphic.LineGraphic;
import org.weasis.core.ui.graphic.MeasureItem;

public class PolygonGraphic
extends AbstractDragGraphicOld {
    public static final Icon ICON = new ImageIcon(PolygonGraphic.class.getResource("/icon/22x22/draw-polyline.png"));
    protected float[] points;
    protected int numPoints;
    protected boolean closed;
    protected transient boolean closeShape;

    public PolygonGraphic(float lineThickness, Color paint, boolean fill, boolean closedPath) {
        this.setShape(new GeneralPath(), null);
        this.setPaint(paint);
        this.lineThickness = lineThickness;
        this.numPoints = 2;
        this.points = new float[this.numPoints * 2];
        this.points[0] = 0.0f;
        this.points[1] = 0.0f;
        this.points[2] = 0.0f;
        this.points[3] = 100.0f;
        this.closed = closedPath;
        this.setFilled(fill);
        this.updateStroke();
        this.updateShapeOnDrawing(null);
    }

    public PolygonGraphic(float[] points, float lineThickness, Color paint, boolean fill, boolean closedPath) {
        this.setShape(new GeneralPath(), null);
        this.setPaint(paint);
        this.lineThickness = lineThickness;
        this.numPoints = 2;
        this.points = points;
        this.closed = closedPath;
        this.setFilled(fill);
        this.updateStroke();
        this.updateShapeOnDrawing(null);
    }

    public void setClosed(boolean flag) {
        this.closed = flag;
        this.updateShape();
    }

    public boolean isClosed() {
        return this.closed;
    }

    public float[] getPoints() {
        return this.points;
    }

    @Override
    public Area getArea() {
        Area area = new Area(this.getShape());
        if (area.isEmpty()) {
            float x1 = this.points[0];
            float y1 = this.points[1];
            float x2 = this.points[0];
            float y2 = this.points[1];
            for (int m = 2; m < this.points.length; m += 2) {
                if (this.points[m] < x1) {
                    x1 = this.points[m];
                }
                if (this.points[m + 1] < y1) {
                    y1 = this.points[m + 1];
                }
                if (this.points[m] > x2) {
                    x2 = this.points[m];
                }
                if (!(this.points[m + 1] > y2)) continue;
                y2 = this.points[m + 1];
            }
            area = LineGraphic.createAreaForLine(x1, y1, x2, y2, this.getHandleSize());
        }
        return area;
    }

    @Override
    protected DragSequence createResizeDrag(MouseEvent mouseevent, int i) {
        return new PolygonDragSequence(mouseevent == null, i);
    }

    @Override
    protected void updateShapeOnDrawing(MouseEvent mouseevent) {
        GeneralPath generalpath = new GeneralPath();
        generalpath.moveTo(this.points[0], this.points[1]);
        int j = this.numPoints * 2;
        for (int i = 2; i < j; ++i) {
            generalpath.lineTo(this.points[i], this.points[++i]);
        }
        if (this.isClosed()) {
            generalpath.closePath();
        }
        this.setShape(generalpath, mouseevent);
        this.updateShape();
    }

    @Override
    protected int resizeOnDrawing(int i, int j, int k, MouseEvent mouseevent) {
        return -2;
    }

    @Override
    public void move(int i, int j, int k, MouseEvent mouseevent) {
        Point p = this.needToMoveCanvas(j, k);
        if (p != null) {
            j = p.x;
            k = p.y;
            super.move(i, j, k, mouseevent);
        }
        for (int m = 0; m < this.points.length; m += 2) {
            int n = m;
            this.points[n] = this.points[n] + (float)j;
            int n2 = m + 1;
            this.points[n2] = this.points[n2] + (float)k;
        }
    }

    @Override
    protected void updateShape() {
        super.updateShape();
    }

    @Override
    public void updateLabel(Object source, DefaultView2d view2d) {
    }

    @Override
    public int getResizeCorner(MouseEvent mouseevent) {
        Point pos = mouseevent.getPoint();
        int k = this.getHandleSize() + 2;
        AffineTransform affineTransform = this.getAffineTransform(mouseevent);
        if (affineTransform != null) {
            double scale = affineTransform.getScaleX();
            k = (int)Math.ceil((double)k / scale + 1.0);
        }
        int i = pos.x;
        int j = pos.y;
        int i1 = this.numPoints + this.numPoints;
        for (int l = 0; l < i1; ++l) {
            int k1;
            int l1;
            int j1 = (int)this.points[l];
            if ((l1 = (i - j1) * (i - j1) + (j - (k1 = (int)this.points[++l])) * (j - k1)) > k) continue;
            return l / 2;
        }
        return -1;
    }

    @Override
    public void paintHandles(Graphics2D graphics2d, AffineTransform transform) {
        int k;
        graphics2d.setPaint(Color.black);
        int i = this.getHandleSize();
        int j = i / 2;
        int l = this.numPoints + this.numPoints;
        for (k = 0; k < l; ++k) {
            graphics2d.fillRect((int)this.points[k] - j, (int)this.points[++k] - j, i, i);
        }
        graphics2d.setPaint(Color.white);
        graphics2d.setStroke(new BasicStroke(1.0f));
        l = this.numPoints + this.numPoints;
        for (k = 0; k < l; ++k) {
            graphics2d.drawRect((int)this.points[k] - j, (int)this.points[++k] - j, i, i);
        }
    }

    @Override
    public void showProperties() {
        if (!this.closeShape) {
            super.showProperties();
        }
        this.closeShape = false;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        PolygonGraphic polygongraphic = (PolygonGraphic)super.clone();
        return super.clone();
    }

    @Override
    public Graphic clone(int xPos, int yPos) {
        PolygonGraphic polygongraphic;
        try {
            polygongraphic = (PolygonGraphic)this.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
        polygongraphic.points = new float[4];
        polygongraphic.numPoints = 2;
        polygongraphic.points[0] = polygongraphic.points[2] = (float)xPos;
        polygongraphic.points[1] = polygongraphic.points[3] = (float)yPos;
        polygongraphic.updateStroke();
        polygongraphic.updateShapeOnDrawing(null);
        return polygongraphic;
    }

    public float getFirstX() {
        return this.points[0];
    }

    public float getFirstY() {
        return this.points[1];
    }

    public float getLastX() {
        return this.points[this.points.length - 2];
    }

    public float getLastY() {
        return this.points[this.points.length - 1];
    }

    public double getAreaValue() {
        Rectangle2D.Float bounds = this.getBoundValue();
        double x = bounds.x;
        double y = bounds.y;
        double sum = 0.0;
        for (int m = 0; m < this.points.length - 2; m += 2) {
            sum = sum + ((double)this.points[m] - x) * ((double)this.points[m + 3] - y) - ((double)this.points[m + 1] - y) * ((double)this.points[m + 2] - x);
        }
        return Math.abs(0.5 * sum);
    }

    public Point2D.Double getCentroid() {
        Rectangle2D.Float bounds = this.getBoundValue();
        double x = bounds.x;
        double y = bounds.y;
        double cx = 0.0;
        double cy = 0.0;
        for (int m = 0; m < this.points.length - 2; m += 2) {
            cx += ((double)(this.points[m] + this.points[m + 2]) - 2.0 * x) * (((double)this.points[m + 1] - y) * ((double)this.points[m + 2] - x) - ((double)this.points[m] - x) * ((double)this.points[m + 3] - y));
            cy += ((double)(this.points[m + 1] + this.points[m + 3]) - 2.0 * y) * (((double)this.points[m + 1] - y) * ((double)this.points[m + 2] - x) - ((double)this.points[m] - x) * ((double)this.points[m + 3] - y));
        }
        double area = this.getAreaValue();
        return new Point2D.Double(x + (cx /= 6.0 * area), y + (cy /= 6.0 * area));
    }

    public Rectangle2D.Float getBoundValue() {
        float[] rect = new float[]{Float.MAX_VALUE, Float.MAX_VALUE, -3.4028235E38f, -3.4028235E38f};
        for (int m = 0; m < this.points.length; m += 2) {
            if (this.points[m] < rect[0]) {
                rect[0] = this.points[m];
            }
            if (this.points[m + 1] < rect[1]) {
                rect[1] = this.points[m + 1];
            }
            if (this.points[m] > rect[2]) {
                rect[2] = this.points[m];
            }
            if (!(this.points[m + 1] > rect[3])) continue;
            rect[3] = this.points[m + 1];
        }
        return new Rectangle2D.Float(rect[0], rect[1], rect[2], rect[3]);
    }

    public Icon getIcon() {
        return ICON;
    }

    public String getUIName() {
        return Messages.getString("PolygonGraphic.title");
    }

    public String getDescription() {
        return null;
    }

    @Override
    public List<MeasureItem> getMeasurements(ImageElement imageElement, boolean b) {
        return null;
    }

    protected class PolygonDragSequence
    extends AbstractDragGraphicOld.DefaultDragSequence {
        private int point;

        protected PolygonDragSequence() {
        }

        protected PolygonDragSequence(boolean flag, int i) {
            this();
            polygonGraphic.createPoints = flag;
            this.point = polygonGraphic.createPoints ? 1 : i;
        }

        @Override
        public void startDrag(MouseEvent mouseevent) {
            this.update(mouseevent);
        }

        @Override
        public void drag(MouseEvent mouseevent) {
            int tx = mouseevent.getX() - this.getLastX();
            int ty = mouseevent.getY() - this.getLastY();
            if (tx != 0 || ty != 0) {
                Point p = PolygonGraphic.this.needToMoveCanvas(tx, ty);
                if (p != null) {
                    tx = p.x;
                    ty = p.y;
                    PolygonGraphic.super.move(0, tx, ty, mouseevent);
                }
                int n = this.point + this.point;
                PolygonGraphic.this.points[n] = PolygonGraphic.this.points[n] + (float)tx;
                int n2 = this.point + this.point + 1;
                PolygonGraphic.this.points[n2] = PolygonGraphic.this.points[n2] + (float)ty;
                PolygonGraphic.this.updateShapeOnDrawing(mouseevent);
                this.update(mouseevent);
            }
        }

        @Override
        public boolean completeDrag(MouseEvent mouseevent) {
            if (mouseevent.getID() == 502) {
                if (PolygonGraphic.this.createPoints) {
                    int i = PolygonGraphic.this.numPoints + PolygonGraphic.this.numPoints;
                    float[] af = new float[i + 2];
                    System.arraycopy(PolygonGraphic.this.points, 0, af, 0, i);
                    af[i] = mouseevent.getX();
                    af[i + 1] = mouseevent.getY();
                    this.point = PolygonGraphic.this.numPoints++;
                    PolygonGraphic.this.points = af;
                    PolygonGraphic.this.updateShapeOnDrawing(mouseevent);
                    this.update(mouseevent);
                    return false;
                }
                return true;
            }
            if (mouseevent.getID() == 501) {
                if (mouseevent.getClickCount() == 2) {
                    if (PolygonGraphic.this.numPoints > 3) {
                        int pointToRemove = PolygonGraphic.this.points[0] == PolygonGraphic.this.points[2] && PolygonGraphic.this.points[1] == PolygonGraphic.this.points[3] ? 4 : 2;
                        int j = PolygonGraphic.this.numPoints + PolygonGraphic.this.numPoints - pointToRemove;
                        float[] af1 = new float[j];
                        System.arraycopy(PolygonGraphic.this.points, pointToRemove == 4 ? 2 : 0, af1, 0, j);
                        PolygonGraphic.this.numPoints -= pointToRemove / 2;
                        PolygonGraphic.this.points = af1;
                        if (PolygonGraphic.this.closed) {
                            PolygonGraphic.this.points[0] = PolygonGraphic.this.points[0] == PolygonGraphic.this.points[2] ? PolygonGraphic.this.points[0] - 1.0f : PolygonGraphic.this.points[0];
                            PolygonGraphic.this.points[1] = PolygonGraphic.this.points[1] == PolygonGraphic.this.points[3] ? PolygonGraphic.this.points[1] - 1.0f : PolygonGraphic.this.points[1];
                        }
                        PolygonGraphic.this.closeShape = true;
                        PolygonGraphic.this.updateShapeOnDrawing(mouseevent);
                        PolygonGraphic.this.createPoints = false;
                    }
                    this.update(mouseevent);
                    return true;
                }
                this.update(mouseevent);
                return false;
            }
            return true;
        }
    }
}

