/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.ui.graphic;

import java.awt.Color;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.media.jai.PlanarImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.weasis.core.api.image.measure.MeasurementsAdapter;
import org.weasis.core.api.media.data.ImageElement;
import org.weasis.core.api.media.data.TagW;
import org.weasis.core.ui.Messages;
import org.weasis.core.ui.graphic.AbstractDragGraphicArea;
import org.weasis.core.ui.graphic.MeasureItem;
import org.weasis.core.ui.graphic.Measurement;

public class RectangleGraphic
extends AbstractDragGraphicArea {
    public static final Icon ICON = new ImageIcon(RectangleGraphic.class.getResource("/icon/22x22/draw-rectangle.png"));
    public static final Measurement TopLeftPointX = new Measurement("Top Left X", true);
    public static final Measurement TopLeftPointY = new Measurement("Top Left Y", true);
    public static final Measurement CenterX = new Measurement("Center X", true);
    public static final Measurement CenterY = new Measurement("Center Y", true);
    public static final Measurement Width = new Measurement("Width", true);
    public static final Measurement Height = new Measurement("Height", true);
    public static final Measurement Area = new Measurement("Area", true);
    public static final Measurement Perimeter = new Measurement("Perimeter", true);
    public static final Measurement ColorRGB = new Measurement("Color (RGB)", true);
    public static final Measurement ImageMin = new Measurement("Min", false);
    public static final Measurement ImageMax = new Measurement("Max", false);
    public static final Measurement ImageSTD = new Measurement("StDev", false);
    public static final Measurement ImageMean = new Measurement("Mean", false);

    public RectangleGraphic(float lineThickness, Color paintColor, boolean labelVisible) {
        super(8, paintColor, lineThickness, labelVisible);
    }

    public Icon getIcon() {
        return ICON;
    }

    public String getUIName() {
        return Messages.getString("MeasureToolBar.rect");
    }

    @Override
    protected int moveAndResizeOnDrawing(int handlePointIndex, int deltaX, int deltaY, MouseEvent mouseEvent) {
        if (handlePointIndex == -1) {
            for (Point2D point : this.handlePointList) {
                point.setLocation(point.getX() + (double)deltaX, point.getY() + (double)deltaY);
            }
        } else {
            Rectangle2D.Double rectangle = new Rectangle2D.Double();
            rectangle.setFrameFromDiagonal((Point2D)this.handlePointList.get(eHandlePoint.NW.index), (Point2D)this.handlePointList.get(eHandlePoint.SE.index));
            double x = ((RectangularShape)rectangle).getX();
            double y = ((RectangularShape)rectangle).getY();
            double w = ((RectangularShape)rectangle).getWidth();
            double h = ((RectangularShape)rectangle).getHeight();
            eHandlePoint pt = eHandlePoint.valueFromIndex(handlePointIndex);
            if (pt.equals((Object)eHandlePoint.W) || pt.equals((Object)eHandlePoint.NW) || pt.equals((Object)eHandlePoint.SW)) {
                x += (double)deltaX;
                w -= (double)deltaX;
            }
            if (pt.equals((Object)eHandlePoint.N) || pt.equals((Object)eHandlePoint.NW) || pt.equals((Object)eHandlePoint.NE)) {
                y += (double)deltaY;
                h -= (double)deltaY;
            }
            if (pt.equals((Object)eHandlePoint.E) || pt.equals((Object)eHandlePoint.NE) || pt.equals((Object)eHandlePoint.SE)) {
                w += (double)deltaX;
            }
            if (pt.equals((Object)eHandlePoint.S) || pt.equals((Object)eHandlePoint.SW) || pt.equals((Object)eHandlePoint.SE)) {
                h += (double)deltaY;
            }
            if (w < 0.0) {
                w = -w;
                x -= w;
                pt = pt.getVerticalMirror();
            }
            if (h < 0.0) {
                h = -h;
                y -= h;
                pt = pt.getHorizontalMirror();
            }
            handlePointIndex = pt.index;
            rectangle.setFrame(x, y, w, h);
            this.setHandlePointList(rectangle);
        }
        return handlePointIndex;
    }

    protected void setHandlePointList(Rectangle2D rectangle) {
        double x = rectangle.getX();
        double y = rectangle.getY();
        double w = rectangle.getWidth();
        double h = rectangle.getHeight();
        while (this.handlePointList.size() < this.handlePointTotalNumber) {
            this.handlePointList.add(new Point2D.Double());
        }
        ((Point2D)this.handlePointList.get(eHandlePoint.NW.index)).setLocation(new Point2D.Double(x, y));
        ((Point2D)this.handlePointList.get(eHandlePoint.N.index)).setLocation(new Point2D.Double(x + w / 2.0, y));
        ((Point2D)this.handlePointList.get(eHandlePoint.NE.index)).setLocation(new Point2D.Double(x + w, y));
        ((Point2D)this.handlePointList.get(eHandlePoint.E.index)).setLocation(new Point2D.Double(x + w, y + h / 2.0));
        ((Point2D)this.handlePointList.get(eHandlePoint.SE.index)).setLocation(new Point2D.Double(x + w, y + h));
        ((Point2D)this.handlePointList.get(eHandlePoint.S.index)).setLocation(new Point2D.Double(x + w / 2.0, y + h));
        ((Point2D)this.handlePointList.get(eHandlePoint.SW.index)).setLocation(new Point2D.Double(x, y + h));
        ((Point2D)this.handlePointList.get(eHandlePoint.W.index)).setLocation(new Point2D.Double(x, y + h / 2.0));
    }

    @Override
    protected void updateShapeOnDrawing(MouseEvent mouseevent) {
        Rectangle2D.Double rectangle = new Rectangle2D.Double();
        if (this.handlePointList.size() > 1) {
            rectangle.setFrameFromDiagonal((Point2D)this.handlePointList.get(eHandlePoint.NW.index), (Point2D)this.handlePointList.get(eHandlePoint.SE.index));
        }
        this.setShape(rectangle, mouseevent);
        this.updateLabel(mouseevent, this.getDefaultView2d(mouseevent));
    }

    @Override
    public List<MeasureItem> getMeasurements(ImageElement imageElement, boolean releaseEvent) {
        MeasurementsAdapter adapter;
        if (imageElement != null && this.handlePointList.size() > 1 && (adapter = imageElement.getMeasurementAdapter()) != null) {
            Double val;
            ArrayList<MeasureItem> measVal = new ArrayList<MeasureItem>();
            Rectangle2D.Double rect = new Rectangle2D.Double();
            rect.setFrameFromDiagonal((Point2D)this.handlePointList.get(eHandlePoint.NW.index), (Point2D)this.handlePointList.get(eHandlePoint.SE.index));
            double ratio = adapter.getCalibRatio();
            if (TopLeftPointX.isComputed() && (releaseEvent || TopLeftPointX.isGraphicLabel())) {
                val = releaseEvent || TopLeftPointX.isQuickComputing() ? Double.valueOf(adapter.getXCalibratedValue(((RectangularShape)rect).getX())) : null;
                measVal.add(new MeasureItem(TopLeftPointX, val, adapter.getUnit()));
            }
            if (TopLeftPointY.isComputed() && (releaseEvent || TopLeftPointY.isGraphicLabel())) {
                val = releaseEvent || TopLeftPointY.isQuickComputing() ? Double.valueOf(adapter.getYCalibratedValue(((RectangularShape)rect).getY())) : null;
                measVal.add(new MeasureItem(TopLeftPointY, val, adapter.getUnit()));
            }
            if (CenterX.isComputed() && (releaseEvent || CenterX.isGraphicLabel())) {
                val = releaseEvent || CenterX.isQuickComputing() ? Double.valueOf(adapter.getXCalibratedValue(rect.getCenterX())) : null;
                measVal.add(new MeasureItem(CenterX, val, adapter.getUnit()));
            }
            if (CenterY.isComputed() && (releaseEvent || CenterY.isGraphicLabel())) {
                val = releaseEvent || CenterY.isQuickComputing() ? Double.valueOf(adapter.getYCalibratedValue(rect.getCenterY())) : null;
                measVal.add(new MeasureItem(CenterY, val, adapter.getUnit()));
            }
            if (Width.isComputed() && (releaseEvent || Width.isGraphicLabel())) {
                val = releaseEvent || Width.isQuickComputing() ? Double.valueOf(ratio * ((RectangularShape)rect).getWidth()) : null;
                measVal.add(new MeasureItem(Width, val, adapter.getUnit()));
            }
            if (Height.isComputed() && (releaseEvent || Height.isGraphicLabel())) {
                val = releaseEvent || Height.isQuickComputing() ? Double.valueOf(ratio * ((RectangularShape)rect).getHeight()) : null;
                measVal.add(new MeasureItem(Height, val, adapter.getUnit()));
            }
            if (Area.isComputed() && (releaseEvent || Area.isGraphicLabel())) {
                val = releaseEvent || Area.isQuickComputing() ? Double.valueOf(((RectangularShape)rect).getWidth() * ((RectangularShape)rect).getHeight() * ratio * ratio) : null;
                String unit = "pix".equals(adapter.getUnit()) ? adapter.getUnit() : adapter.getUnit() + "2";
                measVal.add(new MeasureItem(Area, val, unit));
            }
            if (ImageMin.isComputed() || ImageMax.isComputed() || ImageMean.isComputed() || ImageSTD.isComputed()) {
                Double val2;
                String unit;
                Double min = null;
                Double max = null;
                Double stdv = null;
                Double mean = null;
                if (releaseEvent) {
                    PlanarImage image = imageElement.getImage();
                    try {
                        int band;
                        ArrayList<Integer> pList = this.getValueFromArea(image);
                        if (pList != null && pList.size() > 0 && (band = image.getSampleModel().getNumBands()) == 1) {
                            double v;
                            Float slope = (Float)imageElement.getTagValue(TagW.RescaleSlope);
                            Float intercept = (Float)imageElement.getTagValue(TagW.RescaleIntercept);
                            min = Double.MAX_VALUE;
                            max = -1.7976931348623157E308;
                            double sum = 0.0;
                            for (Integer val3 : pList) {
                                v = val3.doubleValue();
                                if (v < min) {
                                    min = v;
                                }
                                if (v > max) {
                                    max = v;
                                }
                                sum += v;
                            }
                            mean = sum / (double)pList.size();
                            stdv = 0.0;
                            for (Integer val3 : pList) {
                                v = val3.doubleValue();
                                if (v < min) {
                                    min = v;
                                }
                                if (v > max) {
                                    max = v;
                                }
                                stdv = stdv + (v - mean) * (v - mean);
                            }
                            stdv = Math.sqrt(stdv / ((double)pList.size() - 1.0));
                            if (slope != null || intercept != null) {
                                slope = Float.valueOf(slope == null ? 1.0f : slope.floatValue());
                                intercept = Float.valueOf(intercept == null ? 0.0f : intercept.floatValue());
                                mean = mean * (double)slope.floatValue() + (double)intercept.floatValue();
                                stdv = stdv * (double)slope.floatValue() + (double)intercept.floatValue();
                                min = min * (double)slope.floatValue() + (double)intercept.floatValue();
                                max = max * (double)slope.floatValue() + (double)intercept.floatValue();
                            }
                        }
                    }
                    catch (ArrayIndexOutOfBoundsException ex) {
                        // empty catch block
                    }
                }
                String string = unit = imageElement.getPixelValueUnit() == null ? "" : imageElement.getPixelValueUnit();
                if (ImageMin.isComputed() && (releaseEvent || ImageMin.isGraphicLabel())) {
                    val2 = releaseEvent || ImageMin.isQuickComputing() ? min : null;
                    measVal.add(new MeasureItem(ImageMin, val2, unit));
                }
                if (ImageMax.isComputed() && (releaseEvent || ImageMax.isGraphicLabel())) {
                    val2 = releaseEvent || ImageMax.isQuickComputing() ? max : null;
                    measVal.add(new MeasureItem(ImageMax, val2, unit));
                }
                if (ImageMean.isComputed() && (releaseEvent || ImageMean.isGraphicLabel())) {
                    val2 = releaseEvent || ImageMean.isQuickComputing() ? mean : null;
                    measVal.add(new MeasureItem(ImageMean, val2, unit));
                }
                if (ImageSTD.isComputed() && (releaseEvent || ImageSTD.isGraphicLabel())) {
                    val2 = releaseEvent || ImageSTD.isQuickComputing() ? stdv : null;
                    measVal.add(new MeasureItem(ImageSTD, val2, unit));
                }
            }
            return measVal;
        }
        return null;
    }

    protected static enum eHandlePoint {
        NONE(-1),
        NW(0),
        SE(1),
        NE(2),
        SW(3),
        N(4),
        S(5),
        E(6),
        W(7);

        final int index;
        static final Map<Integer, eHandlePoint> map;

        private eHandlePoint(int index) {
            this.index = index;
        }

        static eHandlePoint valueFromIndex(int index) {
            eHandlePoint point = map.get(index);
            if (point == null) {
                throw new RuntimeException("Not a valid index for a rectangular DragGraphic : " + index);
            }
            return point;
        }

        eHandlePoint getVerticalMirror() {
            switch (this) {
                case NW: {
                    return NE;
                }
                case NE: {
                    return NW;
                }
                case W: {
                    return E;
                }
                case E: {
                    return W;
                }
                case SW: {
                    return SE;
                }
                case SE: {
                    return SW;
                }
            }
            return this;
        }

        eHandlePoint getHorizontalMirror() {
            switch (this) {
                case NW: {
                    return SW;
                }
                case SW: {
                    return NW;
                }
                case N: {
                    return S;
                }
                case S: {
                    return N;
                }
                case NE: {
                    return SE;
                }
                case SE: {
                    return NE;
                }
            }
            return this;
        }

        static {
            map = new HashMap<Integer, eHandlePoint>(eHandlePoint.values().length);
            for (eHandlePoint corner : eHandlePoint.values()) {
                map.put(corner.index, corner);
            }
        }
    }
}

