/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.ui.graphic;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.weasis.core.ui.Messages;
import org.weasis.core.ui.graphic.AbstractDragGraphic;
import org.weasis.core.ui.graphic.DragSequence;
import org.weasis.core.ui.graphic.RectangleGraphic;

public class SelectGraphic
extends RectangleGraphic {
    public static final Icon ICON = new ImageIcon(SelectGraphic.class.getResource("/icon/22x22/draw-selection.png"));

    public SelectGraphic() {
        this(1.0f, Color.WHITE);
    }

    public SelectGraphic(float lineThickness, Color paint) {
        super(lineThickness, paint, false);
    }

    @Override
    public Icon getIcon() {
        return ICON;
    }

    @Override
    public String getUIName() {
        return Messages.getString("MeasureToolBar.sel");
    }

    @Override
    public Rectangle getBounds(AffineTransform transform) {
        Rectangle bound = super.getBounds(transform);
        if (bound != null) {
            bound.grow(bound.width < 1 ? 1 : 0, bound.height < 1 ? 1 : 0);
        }
        return bound;
    }

    @Override
    public void paint(Graphics2D g2d, AffineTransform transform) {
        Color oldColor = g2d.getColor();
        Stroke oldStroke = g2d.getStroke();
        g2d.setPaint(Color.white);
        float[] dash = new float[]{5.0f};
        Shape transformedShape = transform == null ? this.shape : transform.createTransformedShape(this.shape);
        g2d.setStroke(new BasicStroke(1.0f, 0, 0, 5.0f, dash, 0.0f));
        g2d.draw(transformedShape);
        g2d.setColor(Color.black);
        g2d.setStroke(new BasicStroke(1.0f, 0, 0, 5.0f, dash, 5.0f));
        g2d.draw(transformedShape);
        g2d.setColor(oldColor);
        g2d.setStroke(oldStroke);
    }

    @Override
    protected DragSequence createResizeDrag(MouseEvent mouseevent, int i) {
        return new SelectedDragSequence();
    }

    protected class SelectedDragSequence
    extends AbstractDragGraphic.DefaultDragSequence {
        protected SelectedDragSequence() {
        }

        @Override
        public boolean completeDrag(MouseEvent mouseEvent) {
            SelectGraphic.this.fireRemoveAndRepaintAction();
            return true;
        }
    }
}

