/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.ui.graphic;

import java.awt.Color;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.List;
import javax.media.jai.PlanarImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.weasis.core.api.gui.util.GeomUtil;
import org.weasis.core.api.image.measure.MeasurementsAdapter;
import org.weasis.core.api.media.data.ImageElement;
import org.weasis.core.api.media.data.TagW;
import org.weasis.core.ui.graphic.AbstractDragGraphicArea;
import org.weasis.core.ui.graphic.MeasureItem;
import org.weasis.core.ui.graphic.Measurement;

public class ThreePointsCircleGraphic
extends AbstractDragGraphicArea {
    public static final Icon ICON = new ImageIcon(ThreePointsCircleGraphic.class.getResource("/icon/22x22/draw-circle.png"));
    public static final Measurement CenterX = new Measurement("Center X", true);
    public static final Measurement CenterY = new Measurement("Center Y", true);
    public static final Measurement Radius = new Measurement("Radius", true);
    public static final Measurement Diameter = new Measurement("Diameter", true);
    public static final Measurement Area = new Measurement("Area", true);
    public static final Measurement Perimeter = new Measurement("Perimeter", true);
    public static final Measurement ColorRGB = new Measurement("Color (RGB)", true);
    public static final Measurement ImageMin = new Measurement("Min", false);
    public static final Measurement ImageMax = new Measurement("Max", false);
    public static final Measurement ImageSTD = new Measurement("StDev", false);
    public static final Measurement ImageMean = new Measurement("Mean", false);

    public ThreePointsCircleGraphic(float lineThickness, Color paintColor, boolean labelVisible) {
        super(3, paintColor, lineThickness, labelVisible);
    }

    public Icon getIcon() {
        return ICON;
    }

    public String getUIName() {
        return "Three Points Circle";
    }

    @Override
    protected void updateShapeOnDrawing(MouseEvent mouseEvent) {
        double radius;
        Point2D centerPt;
        Ellipse2D.Double newShape = null;
        if (this.handlePointList.size() > 1 && (centerPt = GeomUtil.getCircleCenter((List)this.handlePointList)) != null && (radius = centerPt.distance((Point2D)this.handlePointList.get(0))) < 5000.0) {
            Rectangle2D.Double rectangle = new Rectangle2D.Double();
            rectangle.setFrameFromCenter(centerPt.getX(), centerPt.getY(), centerPt.getX() - radius, centerPt.getY() - radius);
            newShape = new Ellipse2D.Double(((RectangularShape)rectangle).getX(), ((RectangularShape)rectangle).getY(), ((RectangularShape)rectangle).getWidth(), ((RectangularShape)rectangle).getHeight());
        }
        this.setShape(newShape, mouseEvent);
        this.updateLabel(mouseEvent, this.getDefaultView2d(mouseEvent));
    }

    @Override
    public List<MeasureItem> getMeasurements(ImageElement imageElement, boolean releaseEvent) {
        MeasurementsAdapter adapter;
        if (imageElement != null && this.handlePointList.size() > 1 && (adapter = imageElement.getMeasurementAdapter()) != null) {
            Double val;
            ArrayList<MeasureItem> measVal = new ArrayList<MeasureItem>();
            Point2D centerPt = GeomUtil.getCircleCenter((List)this.handlePointList);
            double radius = centerPt.distance((Point2D)this.handlePointList.get(0));
            double ratio = adapter.getCalibRatio();
            if (CenterX.isComputed() && (releaseEvent || CenterX.isGraphicLabel())) {
                val = releaseEvent || CenterX.isQuickComputing() ? Double.valueOf(adapter.getXCalibratedValue(centerPt.getX())) : null;
                measVal.add(new MeasureItem(CenterX, val, adapter.getUnit()));
            }
            if (CenterY.isComputed() && (releaseEvent || CenterY.isGraphicLabel())) {
                val = releaseEvent || CenterY.isQuickComputing() ? Double.valueOf(adapter.getYCalibratedValue(centerPt.getY())) : null;
                measVal.add(new MeasureItem(CenterY, val, adapter.getUnit()));
            }
            if (Radius.isComputed() && (releaseEvent || Radius.isGraphicLabel())) {
                val = releaseEvent || Radius.isQuickComputing() ? Double.valueOf(ratio * radius) : null;
                measVal.add(new MeasureItem(Radius, val, adapter.getUnit()));
            }
            if (Diameter.isComputed() && (releaseEvent || Diameter.isGraphicLabel())) {
                val = releaseEvent || Diameter.isQuickComputing() ? Double.valueOf(ratio * radius * 2.0) : null;
                measVal.add(new MeasureItem(Diameter, val, adapter.getUnit()));
            }
            if (Area.isComputed() && (releaseEvent || Area.isGraphicLabel())) {
                val = releaseEvent || Area.isQuickComputing() ? Double.valueOf(Math.PI * radius * radius * ratio * ratio) : null;
                String unit = "pix".equals(adapter.getUnit()) ? adapter.getUnit() : adapter.getUnit() + "2";
                measVal.add(new MeasureItem(Area, val, unit));
            }
            if (ImageMin.isComputed() || ImageMax.isComputed() || ImageMean.isComputed() || ImageSTD.isComputed()) {
                Double val2;
                String unit;
                Double min = null;
                Double max = null;
                Double stdv = null;
                Double mean = null;
                if (releaseEvent) {
                    PlanarImage image = imageElement.getImage();
                    try {
                        int band;
                        ArrayList<Integer> pList = this.getValueFromArea(image);
                        if (pList != null && pList.size() > 0 && (band = image.getSampleModel().getNumBands()) == 1) {
                            double v;
                            Float slope = (Float)imageElement.getTagValue(TagW.RescaleSlope);
                            Float intercept = (Float)imageElement.getTagValue(TagW.RescaleIntercept);
                            min = Double.MAX_VALUE;
                            max = -1.7976931348623157E308;
                            double sum = 0.0;
                            for (Integer val3 : pList) {
                                v = val3.doubleValue();
                                if (v < min) {
                                    min = v;
                                }
                                if (v > max) {
                                    max = v;
                                }
                                sum += v;
                            }
                            mean = sum / (double)pList.size();
                            stdv = 0.0;
                            for (Integer val3 : pList) {
                                v = val3.doubleValue();
                                if (v < min) {
                                    min = v;
                                }
                                if (v > max) {
                                    max = v;
                                }
                                stdv = stdv + (v - mean) * (v - mean);
                            }
                            stdv = Math.sqrt(stdv / ((double)pList.size() - 1.0));
                            if (slope != null || intercept != null) {
                                slope = Float.valueOf(slope == null ? 1.0f : slope.floatValue());
                                intercept = Float.valueOf(intercept == null ? 0.0f : intercept.floatValue());
                                mean = mean * (double)slope.floatValue() + (double)intercept.floatValue();
                                stdv = stdv * (double)slope.floatValue() + (double)intercept.floatValue();
                                min = min * (double)slope.floatValue() + (double)intercept.floatValue();
                                max = max * (double)slope.floatValue() + (double)intercept.floatValue();
                            }
                        }
                    }
                    catch (ArrayIndexOutOfBoundsException ex) {
                        // empty catch block
                    }
                }
                String string = unit = imageElement.getPixelValueUnit() == null ? "" : imageElement.getPixelValueUnit();
                if (ImageMin.isComputed() && (releaseEvent || ImageMin.isGraphicLabel())) {
                    val2 = releaseEvent || ImageMin.isQuickComputing() ? min : null;
                    measVal.add(new MeasureItem(ImageMin, val2, unit));
                }
                if (ImageMax.isComputed() && (releaseEvent || ImageMax.isGraphicLabel())) {
                    val2 = releaseEvent || ImageMax.isQuickComputing() ? max : null;
                    measVal.add(new MeasureItem(ImageMax, val2, unit));
                }
                if (ImageMean.isComputed() && (releaseEvent || ImageMean.isGraphicLabel())) {
                    val2 = releaseEvent || ImageMean.isQuickComputing() ? mean : null;
                    measVal.add(new MeasureItem(ImageMean, val2, unit));
                }
                if (ImageSTD.isComputed() && (releaseEvent || ImageSTD.isGraphicLabel())) {
                    val2 = releaseEvent || ImageSTD.isQuickComputing() ? stdv : null;
                    measVal.add(new MeasureItem(ImageSTD, val2, unit));
                }
            }
            return measVal;
        }
        return null;
    }
}

