/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.ui.graphic.model;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.media.jai.PlanarImage;
import javax.media.jai.TiledImage;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import org.weasis.core.api.gui.util.ActionW;
import org.weasis.core.api.image.util.LayoutUtil;
import org.weasis.core.api.media.data.ImageElement;
import org.weasis.core.ui.Messages;
import org.weasis.core.ui.graphic.AbstractDragGraphic;
import org.weasis.core.ui.graphic.DragLayer;
import org.weasis.core.ui.graphic.Graphic;
import org.weasis.core.ui.graphic.PolygonGraphic;
import org.weasis.core.ui.graphic.SelectGraphic;
import org.weasis.core.ui.graphic.TempLayer;
import org.weasis.core.ui.graphic.model.AbstractLayer;
import org.weasis.core.ui.graphic.model.GraphicsListener;
import org.weasis.core.ui.graphic.model.GraphicsPane;
import org.weasis.core.ui.graphic.model.LayerModel;
import org.weasis.core.ui.graphic.model.LayerModelChangeListener;
import org.weasis.core.ui.graphic.model.Tools;

public class AbstractLayerModel
implements LayerModel {
    private static final SelectGraphic selectGraphic = new SelectGraphic();
    public static final Cursor DEFAULT_CURSOR = new Cursor(0);
    public static final Cursor HAND_CURSOR = AbstractLayerModel.getCustomCursor("hand.gif", "hand", 16, 16);
    public static final Cursor MOVE_CURSOR = new Cursor(13);
    public static final Cursor N_CURSOR = new Cursor(8);
    public static final Cursor S_CURSOR = new Cursor(9);
    public static final Cursor E_CURSOR = new Cursor(11);
    public static final Cursor W_CURSOR = new Cursor(10);
    public static final Cursor NE_CURSOR = new Cursor(7);
    public static final Cursor NW_CURSOR = new Cursor(6);
    public static final Cursor SE_CURSOR = new Cursor(5);
    public static final Cursor SW_CURSOR = new Cursor(4);
    public static final Cursor CROSS_CURSOR = new Cursor(1);
    public static final Cursor WAIT_CURSOR = new Cursor(3);
    protected Cursor cursor = DEFAULT_CURSOR;
    protected final GraphicsPane canvas;
    protected boolean shapeAction = false;
    private final ArrayList<AbstractLayer> layers;
    private final ArrayList<Graphic> singleList;
    private final ArrayList<Graphic> selectedGraphics;
    private final ArrayList<GraphicsListener> selectedGraphicsListener;
    private Graphic createGraphic;
    private final ArrayList listenerList;
    private boolean layerModelChangeFireingSuspended;
    private float alpha;
    public Object antialiasingOn = RenderingHints.VALUE_ANTIALIAS_ON;
    public Object antialiasingOff = RenderingHints.VALUE_ANTIALIAS_OFF;
    private final boolean crossHairMode = false;
    private Object antialiasing;

    public AbstractLayerModel(GraphicsPane canvas) {
        this.canvas = canvas;
        this.layers = new ArrayList();
        this.selectedGraphics = new ArrayList();
        this.singleList = new ArrayList(1);
        this.listenerList = new ArrayList();
        this.selectedGraphicsListener = new ArrayList();
        this.setAlpha(0.0f);
        this.setAntialiasing(false);
    }

    public void changeCursorDesign(MouseEvent mouseevent) {
        Point p = mouseevent.getPoint();
        this.shapeAction = false;
        boolean shift = mouseevent.isShiftDown();
        List<Graphic> dragGaphs = this.getSelectedDragableGraphics();
        if (dragGaphs.size() == 1 && !shift) {
            if (dragGaphs.get(0) instanceof AbstractDragGraphic) {
                AbstractDragGraphic graph = (AbstractDragGraphic)dragGaphs.get(0);
                if (graph instanceof SelectGraphic) {
                    this.canvas.setCursor(this.cursor);
                    return;
                }
                int handlePointIndex = graph.getHandlePointIndex(mouseevent);
                if (handlePointIndex < 0) {
                    if (graph.getArea(mouseevent).contains(p) || graph.isOnGraphicLabel(mouseevent)) {
                        this.canvas.setCursor(MOVE_CURSOR);
                        this.shapeAction = true;
                    }
                } else {
                    this.shapeAction = true;
                    if (dragGaphs.get(0) instanceof PolygonGraphic) {
                        this.canvas.setCursor(HAND_CURSOR);
                    } else if (handlePointIndex >= 0) {
                        this.canvas.setCursor(CROSS_CURSOR);
                    } else {
                        this.shapeAction = false;
                    }
                }
            }
        } else if (dragGaphs.size() > 1 && !shift) {
            for (int i = 0; i < dragGaphs.size(); ++i) {
                AbstractDragGraphic graph = (AbstractDragGraphic)dragGaphs.get(i);
                if (graph.getHandlePointIndex(mouseevent) >= 0 || !graph.getArea(mouseevent).contains(p)) continue;
                this.canvas.setCursor(MOVE_CURSOR);
                this.shapeAction = true;
            }
        }
        if (!this.shapeAction) {
            this.canvas.setCursor(this.cursor);
        }
    }

    public AbstractDragGraphic createGraphic(MouseEvent mouseevent) {
        Graphic obj = this.getCreateGraphic();
        Tools tool = Tools.MEASURE;
        if (obj == null || obj instanceof SelectGraphic) {
            tool = Tools.TEMPDRAGLAYER;
            obj = selectGraphic;
        }
        if ((obj = ((AbstractDragGraphic)obj).clone(mouseevent.getX(), mouseevent.getY())) != null) {
            AbstractLayer layer = this.getLayer(tool);
            if (!layer.isVisible() || !((Boolean)this.canvas.getActionValue(ActionW.DRAW.cmd())).booleanValue()) {
                JOptionPane.showMessageDialog(this.canvas, Messages.getString("AbstractLayerModel.msg_not_vis"), Messages.getString("AbstractLayerModel.draw"), 0);
                return null;
            }
            layer.addGraphic(obj);
        }
        return (AbstractDragGraphic)obj;
    }

    public boolean isShapeAction() {
        return this.shapeAction;
    }

    @Override
    public void repaint() {
        this.canvas.repaint();
    }

    @Override
    public void repaint(Rectangle rectangle) {
        if (rectangle != null) {
            double viewScale = this.canvas.getViewModel().getViewScale();
            int x = (int)((double)rectangle.x - this.canvas.getViewModel().getModelOffsetX() * viewScale);
            int y = (int)((double)rectangle.y - this.canvas.getViewModel().getModelOffsetY() * viewScale);
            this.canvas.repaint(new Rectangle(x, y, rectangle.width, rectangle.height));
        }
    }

    public static Cursor getCustomCursor(String filename, String cursorName, int hotSpotX, int hotSpotY) {
        Toolkit defaultToolkit = Toolkit.getDefaultToolkit();
        ImageIcon icon = new ImageIcon(AbstractLayerModel.class.getResource("/icon/cursor/" + filename));
        Dimension bestCursorSize = defaultToolkit.getBestCursorSize(icon.getIconWidth(), icon.getIconHeight());
        Point hotSpot = new Point(hotSpotX * bestCursorSize.width / icon.getIconWidth(), hotSpotY * bestCursorSize.height / icon.getIconHeight());
        return defaultToolkit.createCustomCursor(icon.getImage(), hotSpot, cursorName);
    }

    public void setCursor(Cursor cursor) {
        this.cursor = cursor;
    }

    public void resetCursor() {
        this.cursor = DEFAULT_CURSOR;
        this.canvas.setCursor(this.cursor);
    }

    private void layerVisibilityChanged(AbstractLayer layer) {
        this.repaint();
    }

    @Override
    public void setSelectedGraphics(List<Graphic> list) {
        for (int i = this.selectedGraphics.size() - 1; i >= 0; --i) {
            Graphic graphic = this.selectedGraphics.get(i);
            if (list != null && list.contains(graphic)) continue;
            graphic.setSelected(false);
        }
        this.selectedGraphics.clear();
        if (list != null) {
            this.selectedGraphics.addAll(list);
            for (int j = this.selectedGraphics.size() - 1; j >= 0; --j) {
                this.selectedGraphics.get(j).setSelected(true);
            }
        }
    }

    @Override
    public ArrayList<Graphic> getSelectedGraphics() {
        return this.selectedGraphics;
    }

    @Override
    public Rectangle getBounds() {
        return this.canvas.getBounds();
    }

    @Override
    public GraphicsPane getGraphicsPane() {
        return this.canvas;
    }

    public void repaintWithRelativeCoord(Rectangle rectangle) {
        this.canvas.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    @Override
    public void addLayer(AbstractLayer layer) {
        this.layers.add(layer);
        layer.setShowDrawing(this);
    }

    @Override
    public void removeLayer(AbstractLayer layer) {
        this.layers.remove(layer);
        this.repaint();
    }

    public void setLayers(List list) {
        for (int i = this.layers.size() - 1; i >= 0; --i) {
            this.layers.remove(i);
        }
        if (list != null) {
            for (int j = list.size() - 1; j >= 0; --j) {
                this.addLayer((AbstractLayer)list.get(j));
            }
        }
    }

    public AbstractLayer[] getLayers() {
        return this.layers.toArray(new AbstractLayer[this.layers.size()]);
    }

    public SelectGraphic getSelectionGraphic() {
        for (Graphic gr : this.selectedGraphics) {
            if (!(gr instanceof SelectGraphic)) continue;
            return (SelectGraphic)gr;
        }
        return null;
    }

    public List<Graphic> getSelectedDragableGraphics() {
        ArrayList<Graphic> arraylist = new ArrayList<Graphic>();
        for (int i = this.selectedGraphics.size() - 1; i >= 0; --i) {
            Graphic graphic = this.selectedGraphics.get(i);
            if (!(graphic instanceof AbstractDragGraphic)) continue;
            arraylist.add(graphic);
        }
        return arraylist;
    }

    public List<Graphic> getSelectedClassifGraphics() {
        ArrayList<Graphic> arraylist = new ArrayList<Graphic>();
        for (int i = this.selectedGraphics.size() - 1; i >= 0; --i) {
            Graphic graphic = this.selectedGraphics.get(i);
        }
        return arraylist;
    }

    public List<Graphic> getSelectedAllGraphicsIntersecting(Rectangle rectangle, AffineTransform transform) {
        ArrayList<Graphic> arraylist = new ArrayList<Graphic>();
        for (int i = this.layers.size() - 1; i >= 0; --i) {
            AbstractLayer layer = this.layers.get(i);
            if (!layer.isVisible()) continue;
            arraylist.addAll(layer.getGraphicsSurfaceInArea(rectangle, transform));
        }
        return arraylist;
    }

    public List<Graphic> getdAllGraphics() {
        ArrayList<Graphic> arraylist = new ArrayList<Graphic>();
        for (int i = this.layers.size() - 1; i >= 0; --i) {
            AbstractLayer layer = this.layers.get(i);
            if (!layer.isVisible()) continue;
            arraylist.addAll(layer.getGraphics());
        }
        return arraylist;
    }

    public Graphic getFirstGraphicIntersecting(MouseEvent mouseevent) {
        for (int i = this.layers.size() - 1; i >= 0; --i) {
            Graphic graph;
            AbstractLayer layer = this.layers.get(i);
            if (!layer.isVisible() || (graph = layer.getGraphicContainPoint(mouseevent)) == null) continue;
            return graph;
        }
        return null;
    }

    public void setSelectedGraphic(Graphic graphic) {
        this.singleList.clear();
        if (graphic != null) {
            this.singleList.add(graphic);
        }
        this.setSelectedGraphics(this.singleList);
    }

    public void deleteAllGraphics() {
        AbstractLayer[] layerList = this.getLayers();
        int n = layerList.length;
        for (int i = n - 1; i >= 0; --i) {
            layerList[i].deleteAllGraphic();
        }
    }

    public void deleteSelectedGraphics() {
        int response;
        ArrayList<Graphic> list = this.getSelectedGraphics();
        if (list != null && list.size() > 0 && (response = JOptionPane.showConfirmDialog(this.canvas, String.format(Messages.getString("AbstractLayerModel.del_conf"), list.size()), Messages.getString("AbstractLayerModel.del_graphs"), 0, 2)) == 0) {
            ArrayList<Graphic> selectionList = new ArrayList<Graphic>(list);
            for (Graphic graphic : selectionList) {
                graphic.fireRemoveAction();
            }
            this.repaint();
        }
    }

    public static PlanarImage getGraphicAsImage(Shape shape) {
        Rectangle bound = shape.getBounds();
        TiledImage image = new TiledImage(0, 0, bound.width + 1, bound.height + 1, 0, 0, LayoutUtil.createBinarySampelModel(), LayoutUtil.createBinaryIndexColorModel());
        Graphics2D g2d = image.createGraphics();
        g2d.translate(-bound.x, -bound.y);
        g2d.setPaint(Color.white);
        g2d.setStroke(new BasicStroke(1.0f));
        g2d.fill(shape);
        g2d.draw(shape);
        return image;
    }

    @Override
    public int getLayerCount() {
        return this.layers.size();
    }

    @Override
    public void draw(Graphics2D g2d, AffineTransform transform, AffineTransform inverseTransform) {
        Rectangle2D bound = null;
        Shape area = inverseTransform.createTransformedShape(g2d.getClipBounds());
        bound = area.getBounds2D();
        g2d.translate(0.5, 0.5);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, this.antialiasingOn);
        for (int i = 0; i < this.layers.size(); ++i) {
            AbstractLayer layer = this.layers.get(i);
            if (!layer.isVisible()) continue;
            layer.paint(g2d, transform, inverseTransform, bound);
        }
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, this.antialiasingOff);
        g2d.translate(-0.5, -0.5);
    }

    @Override
    public void dispose() {
        AbstractLayer[] layerList = this.getLayers();
        this.layers.clear();
        this.listenerList.clear();
        this.selectedGraphicsListener.clear();
        int n = layerList.length;
        for (int i = n - 1; i >= 0; --i) {
            layerList[i].deleteAllGraphic();
        }
    }

    @Override
    public boolean isLayerModelChangeFireingSuspended() {
        return this.layerModelChangeFireingSuspended;
    }

    @Override
    public void setLayerModelChangeFireingSuspended(boolean layerModelChangeFireingSuspended) {
        this.layerModelChangeFireingSuspended = layerModelChangeFireingSuspended;
    }

    public void setAlpha(float alpha) {
        this.alpha = alpha;
    }

    public void setAntialiasing(boolean antialiasing) {
        this.antialiasing = antialiasing ? this.antialiasingOn : this.antialiasingOff;
    }

    @Override
    public LayerModelChangeListener[] getLayerModelChangeListeners() {
        return this.listenerList.toArray(new LayerModelChangeListener[this.listenerList.size()]);
    }

    @Override
    public void addLayerModelChangeListener(LayerModelChangeListener listener) {
        if (listener != null && !this.listenerList.contains(listener)) {
            this.listenerList.add(listener);
        }
    }

    @Override
    public void removeLayerModelChangeListener(LayerModelChangeListener listener) {
        if (listener != null) {
            this.listenerList.remove(listener);
        }
    }

    @Override
    public void fireLayerModelChanged() {
        if (!this.isLayerModelChangeFireingSuspended()) {
            for (int i = 0; i < this.listenerList.size(); ++i) {
                ((LayerModelChangeListener)this.listenerList.get(i)).handleLayerModelChanged(this);
            }
        }
    }

    public GraphicsListener[] getGraphicSelectionListeners() {
        return this.selectedGraphicsListener.toArray(new GraphicsListener[this.selectedGraphicsListener.size()]);
    }

    public void addGraphicSelectionListener(GraphicsListener listener) {
        if (listener != null && !this.selectedGraphicsListener.contains(listener)) {
            this.selectedGraphicsListener.add(listener);
        }
    }

    public void removeGraphicSelectionListener(GraphicsListener listener) {
        if (listener != null) {
            this.selectedGraphicsListener.remove(listener);
        }
    }

    public void fireGraphicsSelectionChanged(ImageElement img) {
        for (int i = 0; i < this.selectedGraphicsListener.size(); ++i) {
            this.selectedGraphicsListener.get(i).handle((List)this.selectedGraphics.clone(), img);
        }
    }

    public static PlanarImage getGraphicsAsImage(Rectangle bound, List graphics2dlist) {
        TiledImage image = new TiledImage(0, 0, bound.width + 1, bound.height + 1, 0, 0, LayoutUtil.createBinarySampelModel(), LayoutUtil.createBinaryIndexColorModel());
        Graphics2D g2d = image.createGraphics();
        g2d.translate(-bound.x, -bound.y);
        g2d.setPaint(Color.white);
        g2d.setStroke(new BasicStroke(1.0f));
        for (int i = 0; i < graphics2dlist.size(); ++i) {
            Graphic graph = (Graphic)graphics2dlist.get(i);
            g2d.fill(graph.getShape());
            g2d.draw(graph.getShape());
        }
        return image;
    }

    public void setActiveLayer(int drawType) {
        Tools.setLevelToLayers(this.layers);
        for (int j = this.layers.size() - 1; j >= 0; --j) {
            AbstractLayer layerTemp = this.layers.get(j);
            if (layerTemp.getDrawType() != drawType) continue;
            layerTemp.setLevel(9);
        }
        Collections.sort(this.layers);
        this.repaint();
    }

    public AbstractLayer getLayer(Tools tool) {
        if (tool.isLayer()) {
            return this.getLayer(tool.getId());
        }
        return this.getLayer(Tools.TEMPDRAGLAYER);
    }

    @Override
    public AbstractLayer getLayer(int drawType) {
        for (int j = this.layers.size() - 1; j >= 0; --j) {
            AbstractLayer layerTemp = this.layers.get(j);
            if (layerTemp.getDrawType() != drawType) continue;
            return layerTemp;
        }
        return this.getLayer(Tools.TEMPDRAGLAYER);
    }

    public DragLayer getMeasureLayer() {
        return (DragLayer)this.getLayer(Tools.MEASURE);
    }

    public DragLayer getNoteLayer() {
        return (DragLayer)this.getLayer(Tools.NOTE);
    }

    public TempLayer getTemporyDragLayer() {
        return (TempLayer)this.getLayer(Tools.TEMPDRAGLAYER);
    }

    public void setCreateGraphic(Graphic graphic) {
        this.createGraphic = graphic;
    }

    public Graphic getCreateGraphic() {
        return this.createGraphic;
    }
}

