/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.ui.graphic.model;

import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import org.weasis.core.api.gui.model.ViewModel;
import org.weasis.core.api.gui.model.ViewModelChangeListener;

public class DefaultViewModel
implements ViewModel {
    private double modelOffsetX = 0.0;
    private double modelOffsetY = 0.0;
    private double viewScale = 1.0;
    private double viewScaleMax;
    private double viewScaleMin;
    public static final double SCALE_MIN = 0.08333333333333333;
    public static final double SCALE_MAX = 12.0;
    private Rectangle2D modelArea;
    private final ArrayList viewModelChangeListenerList;

    public DefaultViewModel(double viewScaleMin, double viewScaleMax) {
        this.viewScaleMin = viewScaleMin;
        this.viewScaleMax = viewScaleMax;
        this.modelArea = new Rectangle2D.Double();
        this.viewModelChangeListenerList = new ArrayList();
    }

    public DefaultViewModel() {
        this(0.08333333333333333, 12.0);
    }

    public double getModelOffsetX() {
        return this.modelOffsetX;
    }

    public double getModelOffsetY() {
        return this.modelOffsetY;
    }

    public void setModelOffset(double modelOffsetX, double modelOffsetY) {
        if (this.modelOffsetX != modelOffsetX || this.modelOffsetY != modelOffsetY) {
            this.modelOffsetX = modelOffsetX;
            this.modelOffsetY = modelOffsetY;
            this.fireViewModelChanged();
        }
    }

    public void setModelOffset(double modelOffsetX, double modelOffsetY, double viewScale) {
        viewScale = this.maybeCropViewScale(viewScale);
        if (this.modelOffsetX != modelOffsetX || this.modelOffsetY != modelOffsetY || this.viewScale != viewScale) {
            this.modelOffsetX = modelOffsetX;
            this.modelOffsetY = modelOffsetY;
            this.viewScale = viewScale;
            this.fireViewModelChanged();
        }
    }

    public double getViewScale() {
        return this.viewScale;
    }

    public void setViewScale(double viewScale) {
        if (this.viewScale != (viewScale = this.maybeCropViewScale(viewScale))) {
            this.viewScale = viewScale;
            this.fireViewModelChanged();
        }
    }

    public double getViewScaleMax() {
        return this.viewScaleMax;
    }

    public void setViewScaleMax(double viewScaleMax) {
        this.viewScaleMax = viewScaleMax;
    }

    public Rectangle2D getModelArea() {
        return new Rectangle2D.Double(this.modelArea.getX(), this.modelArea.getY(), this.modelArea.getWidth(), this.modelArea.getHeight());
    }

    public double getViewScaleMin() {
        return this.viewScaleMin;
    }

    public void setModelArea(Rectangle2D modelArea) {
        if (!this.modelArea.equals(modelArea)) {
            this.modelArea = new Rectangle2D.Double(modelArea.getX(), modelArea.getY(), modelArea.getWidth(), modelArea.getHeight());
            this.fireViewModelChanged();
        }
    }

    public void setViewScaleMin(double viewScaleMin) {
        this.viewScaleMin = viewScaleMin;
    }

    public ViewModelChangeListener[] getViewModelChangeListeners() {
        ViewModelChangeListener[] viewModelChangeListeners = new ViewModelChangeListener[this.viewModelChangeListenerList.size()];
        return this.viewModelChangeListenerList.toArray(viewModelChangeListeners);
    }

    public void addViewModelChangeListener(ViewModelChangeListener l) {
        if (l != null && !this.viewModelChangeListenerList.contains(l)) {
            this.viewModelChangeListenerList.add(l);
        }
    }

    public void removeViewModelChangeListener(ViewModelChangeListener l) {
        if (l != null) {
            this.viewModelChangeListenerList.remove(l);
        }
    }

    protected void fireViewModelChanged() {
        for (int i = 0; i < this.viewModelChangeListenerList.size(); ++i) {
            ViewModelChangeListener l = (ViewModelChangeListener)this.viewModelChangeListenerList.get(i);
            l.handleViewModelChanged((ViewModel)this);
        }
    }

    public static double cropViewScale(double viewScale, double viewScaleMin, double viewScaleMax) {
        if (viewScaleMax > 1.0) {
            if (viewScale < viewScaleMin) {
                viewScale = viewScaleMin;
            } else if (viewScale > viewScaleMax) {
                viewScale = viewScaleMax;
            }
        }
        return viewScale;
    }

    private double maybeCropViewScale(double viewScale) {
        return DefaultViewModel.cropViewScale(viewScale, this.getViewScaleMin(), this.getViewScaleMax());
    }

    public void adjustMinViewScaleFromImage(int width, int height) {
        double ratio = 250.0 / (double)(width > height ? width : height);
        if (ratio < this.viewScaleMin) {
            this.viewScaleMin = ratio;
        }
    }
}

