/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.ui.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import javax.swing.JCheckBox;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.weasis.core.ui.util.CheckNode;

public class TreeLayer
extends JTree {
    public void constructTree(DefaultTreeModel model) {
        this.setModel(model);
        this.setCellRenderer(new CheckBoxNodeRenderer());
        this.setShowsRootHandles(true);
        this.setRootVisible(false);
    }

    public void addCheckedListener() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                Object object;
                TreeLayer layer = (TreeLayer)e.getSource();
                TreePath path = layer.getPathForLocation(e.getX(), e.getY());
                if (path != null && (object = path.getLastPathComponent()) instanceof CheckNode) {
                    CheckNode node;
                    node.setSelected(!(node = (CheckNode)object).isSelected());
                    if (node.getChildCount() > 0) {
                        TreeLayer.fireToChildren(node.children(), node.isSelected());
                    } else {
                        TreeLayer.fireParentChecked(node);
                    }
                    TreeLayer.this.upadateNode(node);
                }
            }
        });
    }

    public void upadateNode(CheckNode node) {
        ((DefaultTreeModel)this.getModel()).reload(node);
    }

    public void upadateAllNodes() {
        ((DefaultTreeModel)this.getModel()).reload();
    }

    public DefaultMutableTreeNode getRoot() {
        return (DefaultMutableTreeNode)this.getModel().getRoot();
    }

    public static void fireToChildren(Enumeration children, boolean checked) {
        while (children.hasMoreElements()) {
            CheckNode item = (CheckNode)children.nextElement();
            item.setSelected(checked);
        }
    }

    public static void fireParentChecked(CheckNode node) {
        if (node.getParent() != null && node.getParent() instanceof CheckNode) {
            CheckNode parent = (CheckNode)node.getParent();
            if (node.isSelected()) {
                parent.setSelected(true);
            } else {
                boolean needtobeChecked = true;
                Enumeration<TreeNode> children = parent.children();
                while (children.hasMoreElements()) {
                    CheckNode item = (CheckNode)children.nextElement();
                    if (!item.isSelected()) continue;
                    needtobeChecked = false;
                    break;
                }
                if (needtobeChecked) {
                    parent.setSelected(false);
                }
            }
        }
    }

    public static void iniParent(DefaultMutableTreeNode root) {
        Enumeration<TreeNode> children = root.children();
        block0: while (children.hasMoreElements()) {
            CheckNode item = (CheckNode)children.nextElement();
            Enumeration<TreeNode> children2 = item.children();
            if (children2.hasMoreElements()) {
                item.setSelected(false);
            }
            while (children2.hasMoreElements()) {
                CheckNode item2 = (CheckNode)children2.nextElement();
                if (!item2.isSelected()) continue;
                item.setSelected(true);
                continue block0;
            }
        }
    }

    static class CheckBoxNodeRenderer
    implements TreeCellRenderer {
        private final JCheckBox leafRenderer = new JCheckBox();
        private final DefaultTreeCellRenderer nonLeafRenderer = new DefaultTreeCellRenderer();
        Color selectionBorderColor;
        Color selectionForeground;
        Color selectionBackground;
        Color textForeground;
        Color textBackground;

        protected JCheckBox getLeafRenderer() {
            return this.leafRenderer;
        }

        public CheckBoxNodeRenderer() {
            Boolean booleanValue;
            Font fontValue = UIManager.getFont("Tree.font");
            if (fontValue != null) {
                this.leafRenderer.setFont(fontValue);
            }
            this.leafRenderer.setFocusPainted((booleanValue = (Boolean)UIManager.get("Tree.drawsFocusBorderAroundIcon")) != null && booleanValue != false);
            this.selectionBorderColor = UIManager.getColor("Tree.selectionBorderColor");
            this.selectionForeground = UIManager.getColor("Tree.selectionForeground");
            this.selectionBackground = UIManager.getColor("Tree.selectionBackground");
            this.textForeground = UIManager.getColor("Tree.textForeground");
            this.textBackground = UIManager.getColor("Tree.textBackground");
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Component returnValue;
            String stringValue = tree.convertValueToText(value, selected, expanded, leaf, row, false);
            this.leafRenderer.setText(stringValue);
            this.leafRenderer.setSelected(false);
            this.leafRenderer.setEnabled(tree.isEnabled());
            if (selected) {
                this.leafRenderer.setForeground(this.selectionForeground);
                this.leafRenderer.setBackground(this.selectionBackground);
            } else {
                this.leafRenderer.setForeground(this.textForeground);
                this.leafRenderer.setBackground(this.textBackground);
            }
            if (value instanceof CheckNode) {
                CheckNode node = (CheckNode)value;
                this.leafRenderer.setText(node.toString());
                this.leafRenderer.setSelected(node.isSelected());
                returnValue = this.leafRenderer;
            } else {
                returnValue = this.nonLeafRenderer.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            }
            return returnValue;
        }
    }
}

