/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.io;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Stack;
import org.dcm4che2.data.BasicDicomObject;
import org.dcm4che2.data.DicomElement;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.SpecificCharacterSet;
import org.dcm4che2.data.VR;
import org.dcm4che2.util.CloseUtils;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ContentHandlerAdapter
extends DefaultHandler {
    private State state = State.EXPECT_ELM;
    private final ByteArrayOutputStream out = new ByteArrayOutputStream();
    private final StringBuffer sb = new StringBuffer();
    private final Stack<DicomElement> sqStack = new Stack();
    private DicomObject attrs;
    private int tag;
    private VR vr;
    private String src;
    private Locator locator;
    private static final byte[] EMPTY_VALUE = new byte[0];

    public ContentHandlerAdapter(DicomObject attrs) {
        this.attrs = attrs;
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) {
        if ("attr".equals(qName)) {
            this.onStartElement(atts.getValue("tag"), atts.getValue("vr"), atts.getValue("src"));
        } else if ("item".equals(qName)) {
            this.onStartItem(atts.getValue("off"), atts.getValue("src"));
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if ("attr".equals(qName)) {
            this.onEndElement();
        } else if ("item".equals(qName)) {
            this.onEndItem();
        }
    }

    public void characters(char[] ch, int start, int length) {
        if (this.state == State.EXPECT_VAL_OR_FIRST_ITEM && this.vr != VR.SQ || this.state == State.EXPECT_FRAG) {
            this.sb.append(ch, start, length);
            this.vr.parseXMLValue(this.sb, this.out, false, this.attrs.getSpecificCharacterSet());
        }
    }

    private void onStartElement(String tagStr, String vrStr, String src) {
        if (this.state != State.EXPECT_ELM) {
            throw new IllegalStateException("state:" + (Object)((Object)this.state));
        }
        this.tag = (int)Long.parseLong(tagStr, 16);
        this.vr = vrStr == null ? this.attrs.vrOf(this.tag) : VR.valueOf(vrStr.charAt(0) << 8 | vrStr.charAt(1));
        this.state = State.EXPECT_VAL_OR_FIRST_ITEM;
        this.src = src;
    }

    private void onStartItem(String offStr, String src) {
        DicomElement sq;
        this.src = src;
        if (this.state != State.EXPECT_VAL_OR_FIRST_ITEM && this.state != State.EXPECT_NEXT_ITEM) {
            throw new IllegalStateException("state:" + (Object)((Object)this.state));
        }
        if (this.state == State.EXPECT_VAL_OR_FIRST_ITEM) {
            this.sqStack.push(this.vr == VR.SQ ? this.attrs.putSequence(this.tag) : this.attrs.putFragments(this.tag, this.vr, false));
        }
        if ((sq = this.sqStack.peek()).vr() == VR.SQ) {
            DicomObject parent = this.attrs;
            this.attrs = new BasicDicomObject();
            ((BasicDicomObject)this.attrs).setParent(parent);
            if (offStr != null) {
                this.attrs.setItemOffset(Long.parseLong(offStr));
            }
            sq.addDicomObject(this.attrs);
            this.state = State.EXPECT_ELM;
        } else {
            this.sb.setLength(0);
            this.state = State.EXPECT_FRAG;
        }
    }

    private void onEndItem() throws SAXException {
        switch (this.state) {
            case EXPECT_ELM: {
                this.attrs = this.attrs.getParent();
                break;
            }
            case EXPECT_FRAG: {
                DicomElement sq = this.sqStack.peek();
                byte[] data = this.getValue(sq.vr(), null);
                sq.addFragment(data != null ? data : EMPTY_VALUE);
                this.sb.setLength(0);
                this.out.reset();
                break;
            }
            default: {
                throw new IllegalStateException("state:" + (Object)((Object)this.state));
            }
        }
        this.state = State.EXPECT_NEXT_ITEM;
    }

    private void onEndElement() throws SAXException {
        switch (this.state) {
            case EXPECT_VAL_OR_FIRST_ITEM: {
                if (this.vr == VR.SQ) {
                    this.attrs.putNull(this.tag, VR.SQ);
                    break;
                }
                this.attrs.putBytes(this.tag, this.vr, this.getValue(this.vr, this.attrs.getSpecificCharacterSet()), false);
                this.sb.setLength(0);
                this.out.reset();
                break;
            }
            case EXPECT_NEXT_ITEM: {
                this.sqStack.pop();
                break;
            }
            default: {
                throw new IllegalStateException("state:" + (Object)((Object)this.state));
            }
        }
        this.state = State.EXPECT_ELM;
    }

    private byte[] getValue(VR vr, SpecificCharacterSet cs) throws SAXException {
        if (this.src == null) {
            return vr.parseXMLValue(this.sb, this.out, true, cs);
        }
        if (this.src.length() == 0) {
            return EMPTY_VALUE;
        }
        return this.readFromSrc();
    }

    private byte[] readFromSrc() throws SAXException {
        byte[] byArray;
        URL url;
        try {
            url = new URL(this.src);
        }
        catch (MalformedURLException e) {
            String systemId = this.locator.getSystemId();
            if (systemId == null) {
                throw new SAXException("Missing systemId which is needed for resolving relative src: " + this.src);
            }
            try {
                url = new URL(systemId.substring(0, systemId.lastIndexOf(47) + 1) + this.src);
            }
            catch (MalformedURLException e1) {
                throw new SAXException("Invalid reference to external value src: " + this.src);
            }
        }
        DataInputStream in = null;
        try {
            URLConnection con = url.openConnection();
            in = new DataInputStream(con.getInputStream());
            int len = con.getContentLength();
            byte[] data = new byte[len + 1 & 0xFFFFFFFE];
            in.readFully(data, 0, len);
            byArray = data;
        }
        catch (IOException e) {
            try {
                throw new SAXException("Failed to read value from external src: " + url, e);
            }
            catch (Throwable throwable) {
                CloseUtils.safeClose(in);
                throw throwable;
            }
        }
        CloseUtils.safeClose(in);
        return byArray;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        EXPECT_ELM,
        EXPECT_VAL_OR_FIRST_ITEM,
        EXPECT_FRAG,
        EXPECT_NEXT_ITEM;

    }
}

