/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.dicom.codec;

import com.sun.media.jai.util.ImageUtil;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.renderable.ParameterBlock;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.NullDescriptor;
import org.dcm4che2.data.DicomElement;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;
import org.dcm4che2.imageio.ImageReaderFactory;
import org.dcm4che2.imageio.plugins.dcm.DicomStreamMetaData;
import org.dcm4che2.imageioimpl.plugins.dcm.DicomImageReader;
import org.dcm4che2.imageioimpl.plugins.dcm.DicomImageReaderSpi;
import org.dcm4che2.io.DicomInputStream;
import org.dcm4che2.io.DicomOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.weasis.core.api.explorer.model.DataExplorerModel;
import org.weasis.core.api.image.op.RectifyUShortToShortDataDescriptor;
import org.weasis.core.api.image.util.LayoutUtil;
import org.weasis.core.api.media.data.Codec;
import org.weasis.core.api.media.data.MediaElement;
import org.weasis.core.api.media.data.MediaReader;
import org.weasis.core.api.media.data.MediaSeries;
import org.weasis.core.api.media.data.MediaSeriesGroup;
import org.weasis.core.api.media.data.Series;
import org.weasis.core.api.media.data.TagW;
import org.weasis.core.api.service.BundleTools;
import org.weasis.core.api.util.FileUtil;
import org.weasis.dicom.codec.DicomEncapDocElement;
import org.weasis.dicom.codec.DicomEncapDocSeries;
import org.weasis.dicom.codec.DicomImageElement;
import org.weasis.dicom.codec.DicomSeries;
import org.weasis.dicom.codec.DicomSpecialElement;
import org.weasis.dicom.codec.DicomVideoElement;
import org.weasis.dicom.codec.DicomVideoSeries;
import org.weasis.dicom.codec.Messages;
import org.weasis.dicom.codec.geometry.ImageOrientation;

public class DicomMediaIO
extends DicomImageReader
implements MediaReader<PlanarImage> {
    private static final Logger logger = LoggerFactory.getLogger(DicomMediaIO.class);
    public static final String MIMETYPE = "application/dicom";
    public static final String IMAGE_MIMETYPE = "image/dicom";
    public static final String SERIES_VIDEO_MIMETYPE = "video/dicom";
    public static final String SERIES_MIMETYPE = "series/dicom";
    public static final String SERIES_PR_MIMETYPE = "pr/dicom";
    public static final String SERIES_KO_MIMETYPE = "ko/dicom";
    public static final String SERIES_SR_MIMETYPE = "sr/dicom";
    public static final String SERIES_ENCAP_DOC_MIMETYPE = "encap/dicom";
    public static final String SERIES_XDSI = "xds-i/dicom";
    public static final Codec CODEC = BundleTools.getCodec((String)"application/dicom", (String)"dcm4che 2.0.24 (modified)");
    private static final DicomImageReaderSpi readerSpi = new DicomImageReaderSpi();
    private URI uri;
    private DicomObject dicomObject = null;
    private int numberOfFrame;
    private int stored;
    private final HashMap<TagW, Object> tags;
    private MediaElement[] image = null;
    private ImageInputStream imageStream = null;
    private volatile String mimeType;
    private ImageReader jpipReader;

    public DicomMediaIO(URI uri) {
        super(readerSpi);
        this.uri = uri;
        this.numberOfFrame = 0;
        this.tags = new HashMap();
        this.mimeType = MIMETYPE;
    }

    public DicomMediaIO(File source) {
        this(source.toURI());
    }

    public DicomMediaIO(URL url) throws URISyntaxException {
        this(url.toURI());
    }

    public synchronized void replaceURI(URI uri) {
        if (uri != null && !uri.equals(this.uri)) {
            this.uri = uri;
            this.reset();
        }
    }

    public boolean readMediaTags() {
        if (this.dicomObject == null && this.uri != null) {
            try {
                this.imageStream = this.uri.toString().startsWith("file:/") ? ImageIO.createImageInputStream(new File(this.uri)) : ImageIO.createImageInputStream(this.uri.toURL().openStream());
                this.setInput(this.imageStream, false, false);
                if (this.getStreamMetadata() instanceof DicomStreamMetaData) {
                    this.dicomObject = ((DicomStreamMetaData)this.getStreamMetadata()).getDicomObject();
                }
                if (this.dicomObject == null || this.dicomObject.getString(131074, "").equals("1.2.840.10008.1.3.10")) {
                    this.close();
                    return false;
                }
                this.stored = this.dicomObject.getInt(2621697, this.dicomObject.getInt(2621696, 0));
                if (this.stored > 0) {
                    this.numberOfFrame = this.getNumImages(false);
                    this.mimeType = "1.2.840.10008.1.2.4.100".equals(this.dicomObject.getString(131088)) ? SERIES_VIDEO_MIMETYPE : IMAGE_MIMETYPE;
                } else {
                    boolean special = this.setDicomSpecialType(this.dicomObject);
                    if (!special) {
                        this.close();
                        return false;
                    }
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
                this.close();
                return false;
            }
            this.writeInstanceTags();
        }
        return true;
    }

    @Override
    protected void initImageReader(int imageIndex) throws IOException {
        super.initImageReader(imageIndex);
        if ("1.2.840.10008.1.2.4.94".equals(this.tsuid)) {
            this.setTagNoNull(TagW.PixelDataProviderURL, this.dicomObject.getString(2654176));
            MediaElement[] elements = this.getMediaElement();
            if (elements != null && elements.length > 0) {
                this.reader.setInput(elements[0]);
            }
        }
    }

    private boolean setDicomSpecialType(DicomObject dicom) {
        String modality = dicom.getString(524384);
        if (modality != null) {
            if ("PR".equals(modality)) {
                this.mimeType = SERIES_PR_MIMETYPE;
                return true;
            }
            if ("KO".equals(modality)) {
                this.mimeType = SERIES_KO_MIMETYPE;
                return true;
            }
            if ("SR".equals(modality)) {
                this.mimeType = SERIES_SR_MIMETYPE;
                return true;
            }
            String encap = this.dicomObject.getString(4325394);
            if (encap != null) {
                this.mimeType = SERIES_ENCAP_DOC_MIMETYPE;
                return true;
            }
        }
        return false;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setTag(TagW tag, Object value) {
        if (tag != null) {
            this.tags.put(tag, value);
        }
    }

    public void setTagNoNull(TagW tag, Object value) {
        if (tag != null && value != null) {
            this.tags.put(tag, value);
        }
    }

    public static void setTag(HashMap<TagW, Object> tags, TagW tag, Object value) {
        if (tag != null) {
            tags.put(tag, value);
        }
    }

    public static void setTagNoNull(HashMap<TagW, Object> tags, TagW tag, Object value) {
        if (tag != null && value != null) {
            tags.put(tag, value);
        }
    }

    public Object getTagValue(TagW tag) {
        return this.tags.get(tag);
    }

    private void writeTag(MediaSeriesGroup group, TagW tag) {
        group.setTag(tag, this.getTagValue(tag));
    }

    public void writeMetaData(MediaSeriesGroup group) {
        if (group == null) {
            return;
        }
        DicomObject header = this.getDicomObject();
        if (TagW.PatientPseudoUID.equals((Object)group.getTagID())) {
            group.setTag(TagW.PatientID, this.getTagValue(TagW.PatientID));
            group.setTag(TagW.PatientName, this.getTagValue(TagW.PatientName));
            group.setTagNoNull(TagW.PatientBirthDate, this.getTagValue(TagW.PatientBirthDate));
            group.setTagNoNull(TagW.PatientBirthTime, (Object)this.getDateFromDicomElement(header, 1048626, null));
            String val = header.getString(0x100040, "O");
            group.setTag(TagW.PatientSex, (Object)(val.startsWith("F") ? Messages.getString("DicomMediaIO.female") : (val.startsWith("M") ? Messages.getString("DicomMediaIO.Male") : Messages.getString("DicomMediaIO.other"))));
            group.setTagNoNull(TagW.IssuerOfPatientID, (Object)header.getString(0x100021));
            group.setTagNoNull(TagW.PatientComments, (Object)header.getString(0x104000));
        } else if (TagW.StudyInstanceUID.equals((Object)group.getTagID())) {
            group.setTagNoNull(TagW.StudyID, (Object)header.getString(0x200010));
            group.setTagNoNull(TagW.StudyDate, (Object)this.getDateFromDicomElement(header, 524320, null));
            group.setTagNoNull(TagW.StudyTime, (Object)this.getDateFromDicomElement(header, 524336, null));
            group.setTagNoNull(TagW.StudyDescription, (Object)header.getString(528432));
            group.setTagNoNull(TagW.AccessionNumber, (Object)header.getString(524368));
            group.setTagNoNull(TagW.ModalitiesInStudy, (Object)header.getString(524385));
            group.setTagNoNull(TagW.NumberOfStudyRelatedInstances, (Object)this.getIntegerFromDicomElement(header, 2101768, null));
            group.setTagNoNull(TagW.NumberOfStudyRelatedSeries, (Object)this.getIntegerFromDicomElement(header, 2101766, null));
            group.setTagNoNull(TagW.StudyStatusID, (Object)header.getString(3276810));
            group.setTagNoNull(TagW.ProcedureCodeSequence, (Object)header.get(528434));
        } else if (TagW.SubseriesInstanceUID.equals((Object)group.getTagID())) {
            MediaElement[] elements;
            group.setTag(TagW.SeriesInstanceUID, this.getTagValue(TagW.SeriesInstanceUID));
            group.setTag(TagW.Modality, this.getTagValue(TagW.Modality));
            group.setTagNoNull(TagW.SeriesDate, (Object)header.getDate(524321, this.getDateFromDicomElement(header, 524320, null)));
            group.setTagNoNull(TagW.SeriesDescription, (Object)header.getString(528446));
            group.setTagNoNull(TagW.RetrieveAETitle, (Object)header.getString(524372));
            group.setTagNoNull(TagW.ReferringPhysicianName, (Object)header.getString(524432));
            group.setTagNoNull(TagW.InstitutionName, (Object)header.getString(524416));
            group.setTagNoNull(TagW.InstitutionalDepartmentName, (Object)header.getString(528448));
            group.setTagNoNull(TagW.StationName, (Object)header.getString(528400));
            group.setTagNoNull(TagW.Manufacturer, (Object)header.getString(524400));
            group.setTagNoNull(TagW.ManufacturerModelName, (Object)header.getString(528528));
            group.setTagNoNull(TagW.ReferencedPerformedProcedureStepSequence, (Object)header.get(528657));
            group.setTagNoNull(TagW.SeriesNumber, (Object)this.getIntegerFromDicomElement(header, 0x200011, null));
            group.setTagNoNull(TagW.PreferredPlaybackSequencing, (Object)this.getIntegerFromDicomElement(header, 1577540, null));
            group.setTagNoNull(TagW.CineRate, (Object)this.getIntegerFromDicomElement(header, 1572928, this.getIntegerFromDicomElement(header, 532804, null)));
            group.setTagNoNull(TagW.KVP, (Object)this.getFloatFromDicomElement(header, 1572960, null));
            group.setTagNoNull(TagW.Laterality, (Object)header.getString(0x200060));
            group.setTagNoNull(TagW.BodyPartExamined, (Object)header.getString(1572885));
            group.setTagNoNull(TagW.ReferencedImageSequence, (Object)header.get(528704));
            group.setTagNoNull(TagW.FrameOfReferenceUID, (Object)header.getString(0x200052));
            group.setTagNoNull(TagW.NumberOfSeriesRelatedInstances, (Object)this.getIntegerFromDicomElement(header, 2101769, null));
            group.setTagNoNull(TagW.PerformedProcedureStepStartDate, (Object)this.getDateFromDicomElement(header, 0x400244, null));
            group.setTagNoNull(TagW.PerformedProcedureStepStartTime, (Object)this.getDateFromDicomElement(header, 4194885, null));
            group.setTagNoNull(TagW.RequestAttributesSequence, (Object)header.get(4194933));
            group.setTagNoNull(TagW.PatientName, this.getTagValue(TagW.PatientName));
            group.setTagNoNull(TagW.StudyDescription, (Object)header.getString(528432));
            if ("1.2.840.10008.1.2.4.94".equals(this.tsuid) && (elements = this.getMediaElement()) != null) {
                for (MediaElement m : elements) {
                    m.setTag(TagW.ExplorerModel, group.getTagValue(TagW.ExplorerModel));
                }
            }
        }
    }

    private void writeInstanceTags() {
        if (this.dicomObject != null && this.tags.size() == 0) {
            this.setTag(TagW.PatientID, this.dicomObject.getString(0x100020, Messages.getString("DicomMediaIO.unknown")));
            String name = this.dicomObject.getString(0x100010, Messages.getString("DicomMediaIO.unknown"));
            if (name.trim().equals("")) {
                name = Messages.getString("DicomMediaIO.unknown");
            }
            name = name.replace("^", " ");
            this.setTag(TagW.PatientName, name);
            this.setTagNoNull(TagW.PatientBirthDate, this.getDateFromDicomElement(this.dicomObject, 0x100030, null));
            this.setTag(TagW.PatientPseudoUID, this.getTagValue(TagW.PatientID).toString() + TagW.formatDate((Date)((Date)this.getTagValue(TagW.PatientBirthDate))));
            this.setTag(TagW.StudyInstanceUID, this.dicomObject.getString(0x20000D, Messages.getString("DicomMediaIO.unknown")));
            this.setTag(TagW.SeriesInstanceUID, this.dicomObject.getString(0x20000E, Messages.getString("DicomMediaIO.unknown")));
            this.setTag(TagW.Modality, this.dicomObject.getString(524384, Messages.getString("DicomMediaIO.unknown")));
            this.setTag(TagW.InstanceNumber, this.dicomObject.getInt(2097171, TagW.AppID.incrementAndGet()));
            this.setTag(TagW.SOPInstanceUID, this.dicomObject.getString(524312, this.getTagValue(TagW.InstanceNumber).toString()));
            this.writeOnlyinstance(this.dicomObject);
            this.writeSharedFunctionalGroupsSequence(this.dicomObject);
            this.writePerFrameFunctionalGroupsSequence(this.tags, this.dicomObject, 0);
            DicomMediaIO.validateDicomImageValues(this.tags);
            DicomMediaIO.computeSlicePositionVector(this.tags);
        }
    }

    private void writeSharedFunctionalGroupsSequence(DicomObject dicomObject) {
        DicomElement seq;
        if (dicomObject != null && (seq = dicomObject.get(1375769129)) != null && seq.vr() == VR.SQ) {
            DicomObject dcm = null;
            try {
                dcm = seq.getDicomObject(0);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (dcm != null) {
                this.writeFunctionalGroupsSequence(this.tags, dcm);
            }
        }
    }

    private void writeOnlyinstance(DicomObject dicomObject) {
        if (dicomObject != null && this.tags != null) {
            this.setTagNoNull(TagW.ImageType, dicomObject.getString(524296));
            this.setTagNoNull(TagW.ImageComments, dicomObject.getString(0x204000));
            this.setTagNoNull(TagW.ContrastBolusAgent, dicomObject.getString(0x180010));
            this.setTagNoNull(TagW.TransferSyntaxUID, dicomObject.getString(131088));
            this.setTagNoNull(TagW.SOPClassUID, dicomObject.getString(524310));
            this.setTagNoNull(TagW.ScanningSequence, dicomObject.getString(1572896));
            this.setTagNoNull(TagW.SequenceVariant, dicomObject.getString(1572897));
            this.setTagNoNull(TagW.ScanOptions, dicomObject.getString(1572898));
            this.setTagNoNull(TagW.RepetitionTime, this.getFloatFromDicomElement(dicomObject, 0x180080, null));
            this.setTagNoNull(TagW.EchoTime, this.getFloatFromDicomElement(dicomObject, 0x180081, null));
            this.setTagNoNull(TagW.InversionTime, this.getFloatFromDicomElement(dicomObject, 1572994, null));
            this.setTagNoNull(TagW.EchoNumbers, this.getIntegerFromDicomElement(dicomObject, 1572998, null));
            this.setTagNoNull(TagW.GantryDetectorTilt, this.getFloatFromDicomElement(dicomObject, 1577248, null));
            this.setTagNoNull(TagW.ConvolutionKernel, dicomObject.getString(1577488));
            this.setTagNoNull(TagW.FlipAngle, this.getFloatFromDicomElement(dicomObject, 1577748, null));
            this.setTagNoNull(TagW.SliceLocation, this.getFloatFromDicomElement(dicomObject, 2101313, null));
            this.setTagNoNull(TagW.SliceThickness, this.getFloatFromDicomElement(dicomObject, 1572944, null));
            this.setTagNoNull(TagW.AcquisitionDate, this.getDateFromDicomElement(dicomObject, 524322, null));
            this.setTagNoNull(TagW.AcquisitionTime, this.getDateFromDicomElement(dicomObject, 524338, null));
            this.setTagNoNull(TagW.ImagePositionPatient, dicomObject.getDoubles(0x200032, (double[])null));
            this.setTagNoNull(TagW.ImageOrientationPatient, dicomObject.getDoubles(2097207, (double[])null));
            this.setTagNoNull(TagW.ImageOrientationPlane, ImageOrientation.makeImageOrientationLabelFromImageOrientationPatient((double[])this.getTagValue(TagW.ImageOrientationPatient)));
            this.setTagNoNull(TagW.ImagerPixelSpacing, dicomObject.getDoubles(1577316, (double[])null));
            this.setTagNoNull(TagW.PixelSpacing, dicomObject.getDoubles(2621488, (double[])null));
            this.setTagNoNull(TagW.PixelSpacingCalibrationDescription, dicomObject.getString(2624004));
            this.setTagNoNull(TagW.WindowWidth, this.getFloatFromDicomElement(dicomObject, 2625617, null));
            this.setTagNoNull(TagW.WindowCenter, this.getFloatFromDicomElement(dicomObject, 2625616, null));
            this.setTagNoNull(TagW.RescaleSlope, this.getFloatFromDicomElement(dicomObject, 2625619, null));
            this.setTagNoNull(TagW.RescaleIntercept, this.getFloatFromDicomElement(dicomObject, 2625618, null));
            this.setTagNoNull(TagW.RescaleType, dicomObject.getString(2625620));
            this.setTagNoNull(TagW.Units, dicomObject.getString(5509121));
            this.setTagNoNull(TagW.SmallestImagePixelValue, this.getIntegerFromDicomElement(dicomObject, 2621702, null));
            this.setTagNoNull(TagW.LargestImagePixelValue, this.getIntegerFromDicomElement(dicomObject, 2621703, null));
            this.setTagNoNull(TagW.PixelPaddingValue, this.getIntegerFromDicomElement(dicomObject, 2621728, null));
            this.setTagNoNull(TagW.NumberOfFrames, this.getIntegerFromDicomElement(dicomObject, 0x280008, null));
            this.setTagNoNull(TagW.PixelPaddingRangeLimit, this.getIntegerFromDicomElement(dicomObject, 2621729, null));
            this.setTagNoNull(TagW.OverlayRows, this.getIntegerFromDicomElement(dicomObject, 0x60000010, null));
            Integer samplesPerPixel = this.getIntegerFromDicomElement(dicomObject, 0x280002, null);
            this.setTagNoNull(TagW.SamplesPerPixel, samplesPerPixel);
            String photometricInterpretation = dicomObject.getString(2621444);
            this.setTagNoNull(TagW.PhotometricInterpretation, photometricInterpretation);
            if (samplesPerPixel != null) {
                this.setTag(TagW.MonoChrome, samplesPerPixel == 1 && !"PALETTE COLOR".equalsIgnoreCase(photometricInterpretation));
            }
            this.setTagNoNull(TagW.Rows, this.getIntegerFromDicomElement(dicomObject, 2621456, null));
            this.setTagNoNull(TagW.Columns, this.getIntegerFromDicomElement(dicomObject, 2621457, null));
            this.setTagNoNull(TagW.BitsAllocated, this.getIntegerFromDicomElement(dicomObject, 2621696, null));
            this.setTagNoNull(TagW.BitsStored, this.getIntegerFromDicomElement(dicomObject, 2621697, (Integer)this.getTagValue(TagW.BitsAllocated)));
            this.setTagNoNull(TagW.PixelRepresentation, this.getIntegerFromDicomElement(dicomObject, 2621699, null));
            this.setTagNoNull(TagW.MIMETypeOfEncapsulatedDocument, dicomObject.getString(4325394));
        }
    }

    private static void validateDicomImageValues(HashMap<TagW, Object> tagList) {
        if (tagList != null) {
            Float window = (Float)tagList.get(TagW.WindowWidth);
            Float level = (Float)tagList.get(TagW.WindowCenter);
            if (window != null && level != null) {
                Integer bitsStored;
                Integer minValue = (Integer)tagList.get(TagW.SmallestImagePixelValue);
                Integer maxValue = (Integer)tagList.get(TagW.LargestImagePixelValue);
                if (minValue != null && maxValue != null) {
                    float min = DicomMediaIO.pixel2rescale(tagList, minValue.floatValue());
                    float max = DicomMediaIO.pixel2rescale(tagList, maxValue.floatValue());
                    float low = level.floatValue() - window.floatValue() / 4.0f;
                    float high = level.floatValue() + window.floatValue() / 4.0f;
                    if (low < min || high > max) {
                        tagList.remove(TagW.SmallestImagePixelValue);
                        tagList.remove(TagW.LargestImagePixelValue);
                    }
                }
                if ((bitsStored = (Integer)tagList.get(TagW.BitsStored)) != null && window.floatValue() > (float)(1 << bitsStored)) {
                    tagList.remove(TagW.WindowCenter);
                    tagList.remove(TagW.WindowWidth);
                }
            }
        }
    }

    private static float pixel2rescale(HashMap<TagW, Object> tagList, float pixelValue) {
        if (tagList != null) {
            Float slope = (Float)tagList.get(TagW.RescaleSlope);
            Float intercept = (Float)tagList.get(TagW.RescaleIntercept);
            if (slope != null || intercept != null) {
                return pixelValue * (slope == null ? 1.0f : slope.floatValue()) + (intercept == null ? 0.0f : intercept.floatValue());
            }
        }
        return pixelValue;
    }

    private static void computeSlicePositionVector(HashMap<TagW, Object> tagList) {
        double[] imgOrientation;
        double[] patientPos = (double[])tagList.get(TagW.ImagePositionPatient);
        if (patientPos != null && patientPos.length == 3 && (imgOrientation = ImageOrientation.computeNormalVectorOfPlan((double[])tagList.get(TagW.ImageOrientationPatient))) != null) {
            double[] slicePosition = new double[]{imgOrientation[0] * patientPos[0], imgOrientation[1] * patientPos[1], imgOrientation[2] * patientPos[2]};
            DicomMediaIO.setTag(tagList, TagW.SlicePosition, slicePosition);
        }
    }

    private Date getDateFromDicomElement(DicomObject dicom, int tag, Date defaultValue) {
        DicomElement element = dicom.get(tag);
        if (element == null || element.isEmpty()) {
            return defaultValue;
        }
        try {
            return dicom.getDate(tag);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private Float getFloatFromDicomElement(DicomObject dicom, int tag, Float defaultValue) {
        DicomElement element = dicom.get(tag);
        if (element == null || element.isEmpty()) {
            return defaultValue;
        }
        return Float.valueOf(dicom.getFloat(tag));
    }

    private Integer getIntegerFromDicomElement(DicomObject dicom, int tag, Integer defaultValue) {
        DicomElement element = dicom.get(tag);
        if (element == null || element.isEmpty()) {
            return defaultValue;
        }
        return dicom.getInt(tag);
    }

    private Double getDoubleFromDicomElement(DicomObject dicom, int tag, Double defaultValue) {
        DicomElement element = dicom.get(tag);
        if (element == null || element.isEmpty()) {
            return defaultValue;
        }
        return dicom.getDouble(tag);
    }

    public boolean containTag(int id) {
        Iterator<TagW> it = this.tags.keySet().iterator();
        while (it.hasNext()) {
            if (it.next().getId() != id) continue;
            return true;
        }
        return false;
    }

    public int getStored() {
        return this.stored;
    }

    @Override
    public void reset() {
        FileUtil.safeClose((ImageInputStream)this.imageStream);
        this.imageStream = null;
        this.dicomObject = null;
        super.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeDICOM(File destination) throws Exception {
        DicomOutputStream out = null;
        DicomInputStream dis = null;
        try {
            out = new DicomOutputStream(new BufferedOutputStream(new FileOutputStream(destination)));
            dis = this.uri.toString().startsWith("file:/") ? new DicomInputStream(new File(this.uri)) : new DicomInputStream(this.uri.toURL().openStream());
            DicomObject dcm = dis.readDicomObject();
            out.writeDicomFile(dcm);
        }
        catch (IOException e) {
            boolean bl;
            try {
                e.printStackTrace();
                destination.delete();
                bl = false;
            }
            catch (Throwable throwable) {
                FileUtil.safeClose(out);
                FileUtil.safeClose(dis);
                throw throwable;
            }
            FileUtil.safeClose((Closeable)out);
            FileUtil.safeClose(dis);
            return bl;
        }
        FileUtil.safeClose((Closeable)out);
        FileUtil.safeClose((Closeable)dis);
        return true;
    }

    public DicomObject getDicomObject() {
        if (this.dicomObject == null) {
            this.readMediaTags();
            DicomObject dcm = this.dicomObject;
            this.reset();
            return dcm;
        }
        return this.dicomObject;
    }

    public URI getUri() {
        return this.uri;
    }

    public PlanarImage getMediaFragment(MediaElement<PlanarImage> media) throws Exception {
        if (media != null && media.getKey() instanceof Integer) {
            int frame;
            if (this.dicomObject == null) {
                this.readMediaTags();
            }
            if ((frame = ((Integer)media.getKey()).intValue()) >= 0 && frame < this.numberOfFrame && this.stored > 0) {
                logger.debug("read dicom image frame: {} sopUID: {}", (Object)frame, (Object)this.dicomObject.getString(524312));
                RenderedImage buffer = null;
                if ("1.2.840.10008.1.2.4.94".equals(this.tsuid)) {
                    if (this.jpipReader == null) {
                        ImageReaderFactory f = ImageReaderFactory.getInstance();
                        this.jpipReader = f.getReaderForTransferSyntax(this.tsuid);
                    }
                    this.setTagNoNull(TagW.PixelDataProviderURL, this.dicomObject.getString(2654176));
                    MediaElement[] elements = this.getMediaElement();
                    if (elements != null && elements.length > frame) {
                        this.jpipReader.setInput(elements);
                        buffer = this.jpipReader.readAsRenderedImage(frame, null);
                    }
                } else {
                    buffer = this.readAsRenderedImage(frame, null);
                }
                RenderedOp img = null;
                if (buffer != null) {
                    img = NullDescriptor.create((RenderedImage)buffer, (RenderingHints)LayoutUtil.createTiledLayoutHints((RenderedImage)buffer));
                    if (this.getDataType() == 2 && img.getSampleModel().getDataType() == 1) {
                        img = RectifyUShortToShortDataDescriptor.create((RenderedImage)img, null);
                    } else if (ImageUtil.isBinary((SampleModel)img.getSampleModel())) {
                        ParameterBlock pb = new ParameterBlock();
                        pb.addSource(img);
                        img = JAI.create((String)"formatbinary", (ParameterBlock)pb, null);
                    }
                }
                return img;
            }
        }
        return null;
    }

    private MediaElement getSingleImage() {
        MediaElement[] elements = this.getMediaElement();
        if (elements != null && elements.length > 0) {
            return elements[0];
        }
        return null;
    }

    public MediaElement getPreview() {
        return this.getSingleImage();
    }

    public boolean delegate(DataExplorerModel explorerModel) {
        return false;
    }

    public MediaElement[] getMediaElement() {
        if (this.image == null && this.readMediaTags()) {
            if (SERIES_VIDEO_MIMETYPE.equals(this.mimeType)) {
                this.image = new MediaElement[]{new DicomVideoElement(this, null)};
            } else if (SERIES_ENCAP_DOC_MIMETYPE.equals(this.mimeType)) {
                this.image = new MediaElement[]{new DicomEncapDocElement(this, null)};
            } else if (this.numberOfFrame > 0) {
                this.image = new MediaElement[this.numberOfFrame];
                for (int i = 0; i < this.image.length; ++i) {
                    this.image[i] = new DicomImageElement(this, i);
                }
            } else {
                boolean ps;
                this.image = new MediaElement[1];
                String modality = (String)this.getTagValue(TagW.Modality);
                boolean bl = ps = modality != null && ("PR".equals(modality) || "KO".equals(modality) || "SR".equals(modality));
                if (ps) {
                    this.image[0] = new DicomSpecialElement(this, null);
                }
            }
        }
        return this.image;
    }

    public MediaSeries getMediaSeries() {
        Series series = null;
        if (this.readMediaTags()) {
            String seriesUID = (String)this.getTagValue(TagW.SeriesInstanceUID);
            series = this.buildSeries(seriesUID);
            this.writeMetaData((MediaSeriesGroup)series);
            MediaElement[] elements = this.getMediaElement();
            if (elements != null) {
                for (MediaElement media : elements) {
                    series.addMedia(media);
                }
            }
        }
        return series;
    }

    public int getMediaElementNumber() {
        return this.numberOfFrame;
    }

    public String getMediaFragmentMimeType(Object key) {
        return this.mimeType;
    }

    public HashMap<TagW, Object> getMediaFragmentTags(Object key) {
        if (key instanceof Integer && (Integer)key > 0) {
            HashMap tagList = (HashMap)this.tags.clone();
            if (this.writePerFrameFunctionalGroupsSequence(tagList, this.dicomObject, (Integer)key)) {
                DicomMediaIO.validateDicomImageValues(tagList);
                DicomMediaIO.computeSlicePositionVector(tagList);
            }
            return tagList;
        }
        return this.tags;
    }

    private boolean writePerFrameFunctionalGroupsSequence(HashMap<TagW, Object> tagList, DicomObject dicomObject, int index) {
        DicomElement seq;
        if (dicomObject != null && tagList != null && (seq = dicomObject.get(1375769136)) != null && seq.vr() == VR.SQ) {
            DicomObject dcm = null;
            try {
                dcm = seq.getDicomObject(index);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (dcm != null) {
                this.writeFunctionalGroupsSequence(tagList, dcm);
                return true;
            }
        }
        return false;
    }

    private void writeFunctionalGroupsSequence(HashMap<TagW, Object> tagList, DicomObject dcm) {
        if (dcm != null && tagList != null && dcm != null) {
            DicomObject frame;
            DicomElement seq = dcm.get(2134291);
            if (seq != null && seq.vr() == VR.SQ && seq.countItems() > 0) {
                DicomMediaIO.setTagNoNull(tagList, TagW.ImagePositionPatient, seq.getDicomObject(0).getDoubles(0x200032, (double[])null));
            }
            if ((seq = dcm.get(2134294)) != null && seq.vr() == VR.SQ && seq.countItems() > 0) {
                double[] imgOrientation = seq.getDicomObject(0).getDoubles(2097207, (double[])null);
                DicomMediaIO.setTagNoNull(tagList, TagW.ImageOrientationPatient, imgOrientation);
                DicomMediaIO.setTagNoNull(tagList, TagW.ImageOrientationPlane, ImageOrientation.makeImageOrientationLabelFromImageOrientationPatient(imgOrientation));
            }
            if ((seq = dcm.get(2658610)) != null && seq.vr() == VR.SQ && seq.countItems() > 0) {
                DicomObject lut = seq.getDicomObject(0);
                DicomMediaIO.setTagNoNull(tagList, TagW.WindowWidth, this.getFloatFromDicomElement(lut, 2625617, null));
                DicomMediaIO.setTagNoNull(tagList, TagW.WindowCenter, this.getFloatFromDicomElement(lut, 2625616, null));
            }
            if ((seq = dcm.get(2658629)) != null && seq.vr() == VR.SQ && seq.countItems() > 0) {
                DicomObject pix = seq.getDicomObject(0);
                DicomMediaIO.setTagNoNull(tagList, TagW.RescaleSlope, this.getFloatFromDicomElement(pix, 2625619, null));
                DicomMediaIO.setTagNoNull(tagList, TagW.RescaleIntercept, this.getFloatFromDicomElement(pix, 2625618, null));
                DicomMediaIO.setTagNoNull(tagList, TagW.RescaleType, pix.getString(2625620));
            }
            if ((seq = dcm.get(2658576)) != null && seq.vr() == VR.SQ && seq.countItems() > 0) {
                DicomObject measure = seq.getDicomObject(0);
                DicomMediaIO.setTagNoNull(tagList, TagW.PixelSpacing, measure.getDoubles(2621488, (double[])null));
                DicomMediaIO.setTagNoNull(tagList, TagW.SliceThickness, this.getFloatFromDicomElement(measure, 1572944, null));
            }
            if ((seq = dcm.get(1610278)) == null) {
                seq = dcm.get(1610537);
            }
            if (seq == null) {
                seq = dcm.get(1610279);
            }
            if (seq != null && seq.vr() == VR.SQ && seq.countItems() > 0) {
                frame = seq.getDicomObject(0);
                DicomMediaIO.setTagNoNull(tagList, TagW.FrameType, frame.getString(561159));
            }
            if ((seq = dcm.get(2134289)) != null && seq.vr() == VR.SQ && seq.countItems() > 0) {
                frame = seq.getDicomObject(0);
                DicomMediaIO.setTagNoNull(tagList, TagW.FrameAcquisitionNumber, this.getIntegerFromDicomElement(frame, 2134358, null));
                DicomMediaIO.setTagNoNull(tagList, TagW.StackID, frame.getString(2134102));
                DicomMediaIO.setTagNoNull(tagList, TagW.InstanceNumber, this.getIntegerFromDicomElement(frame, 2134103, null));
            }
        }
    }

    public URI getMediaFragmentURI(Object key) {
        return this.uri;
    }

    public void close() {
        this.reset();
        this.dispose();
    }

    public Codec getCodec() {
        return CODEC;
    }

    public String[] getReaderDescription() {
        String[] desc = new String[3];
        desc[0] = "DICOM Codec: " + CODEC.getCodecName();
        ImageReader imgReader = null;
        try {
            imgReader = ImageReaderFactory.getInstance().getReaderForTransferSyntax((String)this.getTagValue(TagW.TransferSyntaxUID));
        }
        catch (Exception e1) {
            // empty catch block
        }
        if (imgReader != null) {
            desc[1] = "Image Reader Class: " + imgReader.getClass().getName();
            try {
                desc[2] = "Image Format: " + imgReader.getFormatName();
            }
            catch (IOException e) {
                desc[2] = "Image Format: unknown";
            }
        }
        if (desc[1] == null) {
            desc[1] = Messages.getString("DicomMediaIO.msg_no_reader") + this.tsuid;
        }
        return desc;
    }

    public Series buildSeries(String seriesUID) {
        if (IMAGE_MIMETYPE.equals(this.mimeType)) {
            return new DicomSeries(seriesUID);
        }
        if (SERIES_VIDEO_MIMETYPE.equals(this.mimeType)) {
            return new DicomVideoSeries(seriesUID);
        }
        if (SERIES_ENCAP_DOC_MIMETYPE.equals(this.mimeType)) {
            return new DicomEncapDocSeries(seriesUID);
        }
        return new DicomSeries(seriesUID);
    }
}

