/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.dicom.codec.geometry;

import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class GeometryOfSlice {
    protected double[] rowArray;
    protected Vector3d row;
    protected double[] columnArray;
    protected Vector3d column;
    protected Point3d tlhc;
    protected double[] tlhcArray;
    protected Tuple3d voxelSpacing;
    protected double[] voxelSpacingArray;
    protected double sliceThickness;
    protected Tuple3d dimensions;
    protected Vector3d normal;
    protected double[] normalArray;

    protected final void makeNormal() {
        this.normal = new Vector3d();
        this.normal.cross(this.row, this.column);
        this.normal.normalize();
        this.normalArray = new double[3];
        this.normal.get(this.normalArray);
        this.normalArray[2] = this.normalArray[2] * -1.0;
        this.normal = new Vector3d(this.normalArray);
    }

    public GeometryOfSlice() {
    }

    public GeometryOfSlice(Vector3d row, Vector3d column, Point3d tlhc, Tuple3d voxelSpacing, double sliceThickness, Tuple3d dimensions) {
        this.row = row;
        this.rowArray = new double[3];
        row.get(this.rowArray);
        this.column = column;
        this.columnArray = new double[3];
        column.get(this.columnArray);
        this.tlhc = tlhc;
        this.tlhcArray = new double[3];
        tlhc.get(this.tlhcArray);
        this.voxelSpacing = voxelSpacing;
        this.voxelSpacingArray = new double[3];
        voxelSpacing.get(this.voxelSpacingArray);
        this.sliceThickness = sliceThickness;
        this.dimensions = dimensions;
        this.makeNormal();
    }

    public GeometryOfSlice(double[] rowArray, double[] columnArray, double[] tlhcArray, double[] voxelSpacingArray, double sliceThickness, double[] dimensions) {
        this.rowArray = rowArray;
        this.row = new Vector3d(rowArray);
        this.columnArray = columnArray;
        this.column = new Vector3d(columnArray);
        this.tlhcArray = tlhcArray;
        this.tlhc = new Point3d(tlhcArray);
        this.voxelSpacingArray = voxelSpacingArray;
        this.voxelSpacing = new Vector3d(voxelSpacingArray);
        this.sliceThickness = sliceThickness;
        this.dimensions = new Vector3d(dimensions);
        this.makeNormal();
    }

    public final Vector3d getRow() {
        return this.row;
    }

    public final double[] getRowArray() {
        return this.rowArray;
    }

    public final Vector3d getColumn() {
        return this.column;
    }

    public final double[] getColumnArray() {
        return this.columnArray;
    }

    public final Vector3d getNormal() {
        return this.normal;
    }

    public final double[] getNormalArray() {
        return this.normalArray;
    }

    public final Point3d getTLHC() {
        return this.tlhc;
    }

    public final double[] getTLHCArray() {
        return this.tlhcArray;
    }

    public final Tuple3d getVoxelSpacing() {
        return this.voxelSpacing;
    }

    public final double[] getVoxelSpacingArray() {
        return this.voxelSpacingArray;
    }

    public final double getSliceThickness() {
        return this.sliceThickness;
    }

    public final Tuple3d getDimensions() {
        return this.dimensions;
    }

    final void setVoxelSpacingBetweenSlices(double spacing) {
        this.voxelSpacingArray[2] = spacing;
        this.voxelSpacing.set(this.voxelSpacingArray);
    }

    public final double[] lookupImageCoordinate(int column, int row) {
        double[] location = new double[3];
        this.lookupImageCoordinate(location, column, row);
        return location;
    }

    public final void lookupImageCoordinate(double[] location, int column, int row) {
        location[0] = this.tlhcArray[0] + (double)row * this.columnArray[0] * this.voxelSpacingArray[0] + (double)column * this.rowArray[0] * this.voxelSpacingArray[1];
        location[1] = this.tlhcArray[1] + (double)row * this.columnArray[1] * this.voxelSpacingArray[0] + (double)column * this.rowArray[1] * this.voxelSpacingArray[1];
        location[2] = this.tlhcArray[2] + (double)row * this.columnArray[2] * this.voxelSpacingArray[0] + (double)column * this.rowArray[2] * this.voxelSpacingArray[1];
    }

    public final double[] lookupImageCoordinate(double[] location) {
        double[] offsets = new double[2];
        this.lookupImageCoordinate(offsets, location);
        return offsets;
    }

    public final void lookupImageCoordinate(double[] offsets, double[] location) {
        double column = ((location[1] - this.tlhcArray[1]) * (this.columnArray[0] * this.voxelSpacingArray[0]) - (location[0] - this.tlhcArray[0]) * (this.columnArray[1] * this.voxelSpacingArray[0])) / (this.rowArray[1] * this.voxelSpacingArray[1] * this.columnArray[0] * this.voxelSpacingArray[0] - this.rowArray[0] * this.voxelSpacingArray[1] * this.columnArray[1] * this.voxelSpacingArray[0]);
        double row = (location[1] - this.tlhcArray[1] - column * this.rowArray[1] * this.voxelSpacingArray[1]) / (this.columnArray[1] * this.voxelSpacingArray[0]);
        offsets[0] = column;
        offsets[1] = row;
    }

    public final double getDistanceAlongNormalFromOrigin(Point3d point) {
        Vector3d fromOrigin = new Vector3d((Tuple3d)point);
        double distance = this.normal.dot(fromOrigin);
        return distance;
    }

    public final double getDistanceAlongNormalFromOrigin() {
        Vector3d fromOrigin = new Vector3d((Tuple3d)this.tlhc);
        double distance = this.normal.dot(fromOrigin);
        return distance;
    }

    public final boolean isPointInSlicePlane(Point3d point) {
        double distanceTLHC;
        double distancePoint = this.getDistanceAlongNormalFromOrigin(point);
        double delta = Math.abs(distancePoint - (distanceTLHC = this.getDistanceAlongNormalFromOrigin()));
        boolean inplane = delta < 0.001;
        return inplane;
    }

    public static final boolean areSlicesParallel(GeometryOfSlice slice1, GeometryOfSlice slice2) {
        boolean parallel = false;
        if (slice1 != null && slice2 != null) {
            double[] normal1 = slice1.getNormalArray();
            double[] normal2 = slice2.getNormalArray();
            if (normal1 != null && normal2 != null) {
                parallel = Math.abs(normal1[0] - normal2[0]) < 0.001 && Math.abs(normal1[1] - normal2[1]) < 0.001 && Math.abs(normal1[2] - normal2[2]) < 0.001;
            }
        }
        return parallel;
    }

    public final String toString() {
        double[] dimensionsArray = new double[3];
        this.dimensions.get(dimensionsArray);
        StringBuffer str = new StringBuffer();
        str.append("Row (");
        str.append(this.rowArray[0]);
        str.append(",");
        str.append(this.rowArray[1]);
        str.append(",");
        str.append(this.rowArray[2]);
        str.append(") Column (");
        str.append(this.columnArray[0]);
        str.append(",");
        str.append(this.columnArray[1]);
        str.append(",");
        str.append(this.columnArray[2]);
        str.append(") Normal (");
        str.append(this.normalArray[0]);
        str.append(",");
        str.append(this.normalArray[1]);
        str.append(",");
        str.append(this.normalArray[2]);
        str.append(") TLHC (");
        str.append(this.tlhcArray[0]);
        str.append(",");
        str.append(this.tlhcArray[1]);
        str.append(",");
        str.append(this.tlhcArray[2]);
        str.append(") Spacing (");
        str.append(this.voxelSpacingArray[0]);
        str.append(",");
        str.append(this.voxelSpacingArray[1]);
        str.append(",");
        str.append(this.voxelSpacingArray[2]);
        str.append(") Thickness (");
        str.append(this.sliceThickness);
        str.append(") Dimensions (");
        str.append(dimensionsArray[0]);
        str.append(",");
        str.append(dimensionsArray[1]);
        str.append(",");
        str.append(dimensionsArray[2]);
        str.append(")");
        return str.toString();
    }

    public static final String getOrientation(double[] orientation) {
        StringBuffer strbuf = new StringBuffer();
        if (orientation != null && orientation.length == 3) {
            char orientationX = orientation[0] < 0.0 ? (char)'R' : 'L';
            char orientationY = orientation[1] < 0.0 ? (char)'A' : 'P';
            char orientationZ = orientation[2] < 0.0 ? (char)'F' : 'H';
            double absX = Math.abs(orientation[0]);
            double absY = Math.abs(orientation[1]);
            double absZ = Math.abs(orientation[2]);
            for (int i = 0; i < 3; ++i) {
                if (absX > 1.0E-4 && absX > absY && absX > absZ) {
                    strbuf.append(orientationX);
                    absX = 0.0;
                    continue;
                }
                if (absY > 1.0E-4 && absY > absX && absY > absZ) {
                    strbuf.append(orientationY);
                    absY = 0.0;
                    continue;
                }
                if (!(absZ > 1.0E-4) || !(absZ > absX) || !(absZ > absY)) continue;
                strbuf.append(orientationZ);
                absZ = 0.0;
            }
        }
        return strbuf.toString();
    }

    public final String getRowOrientation() {
        return GeometryOfSlice.getOrientation(this.rowArray);
    }

    public final String getColumnOrientation() {
        return GeometryOfSlice.getOrientation(this.columnArray);
    }
}

