/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.dicom.codec.geometry;

import java.awt.geom.Line2D;
import java.util.Vector;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.weasis.dicom.codec.geometry.GeometryOfSlice;
import org.weasis.dicom.codec.geometry.LocalizerPoster;

public class IntersectSlice
extends LocalizerPoster {
    public IntersectSlice(Vector3d row, Vector3d column, Point3d tlhc, Tuple3d voxelSpacing, Tuple3d dimensions) {
        this.localizerRow = row;
        this.localizerColumn = column;
        this.localizerTLHC = tlhc;
        this.localizerVoxelSpacing = voxelSpacing;
        this.localizerDimensions = dimensions;
        this.doCommonConstructorStuff();
    }

    public IntersectSlice(GeometryOfSlice geometry) {
        this.localizerRow = geometry.getRow();
        this.localizerColumn = geometry.getColumn();
        this.localizerTLHC = geometry.getTLHC();
        this.localizerVoxelSpacing = geometry.getVoxelSpacing();
        this.localizerDimensions = geometry.getDimensions();
        this.doCommonConstructorStuff();
    }

    private boolean allTrue(boolean[] array) {
        boolean all = true;
        for (int i = 0; i < array.length; ++i) {
            if (array[i]) continue;
            all = false;
            break;
        }
        return all;
    }

    private boolean oppositeEdges(boolean[] array) {
        return array[0] && array[2] || array[1] && array[3];
    }

    private boolean adjacentEdges(boolean[] array) {
        return array[0] && array[1] || array[1] && array[2] || array[2] && array[3] || array[3] && array[0];
    }

    private boolean[] classifyCornersOfRectangleIntoEdgesCrossingZPlane(Point3d[] corners) {
        int size = corners.length;
        double[] thisArray = new double[3];
        double[] nextArray = new double[3];
        boolean[] classification = new boolean[size];
        for (int i = 0; i < size; ++i) {
            int next = i == size - 1 ? 0 : i + 1;
            classification[i] = IntersectSlice.classifyCornersIntoEdgeCrossingZPlane(corners[i], corners[next]);
        }
        return classification;
    }

    @Override
    public float[] getOutlineOnLocalizerForThisGeometry(Vector3d row, Vector3d column, Point3d tlhc, Tuple3d voxelSpacing, double sliceThickness, Tuple3d dimensions) {
        Point3d[] corners = IntersectSlice.getCornersOfSourceRectangleInSourceSpace(row, column, tlhc, voxelSpacing, dimensions);
        for (int i = 0; i < 4; ++i) {
            corners[i] = this.transformPointFromSourceSpaceIntoLocalizerSpace(corners[i]);
        }
        boolean[] edges = this.classifyCornersOfRectangleIntoEdgesCrossingZPlane(corners);
        Vector shapes = null;
        if (this.allTrue(edges)) {
            shapes = this.drawOutlineOnLocalizer(corners);
        } else if (this.oppositeEdges(edges)) {
            shapes = this.drawLinesBetweenAnyPointsWhichIntersectPlaneWhereZIsZero(corners);
        } else if (this.adjacentEdges(edges)) {
            shapes = this.drawLinesBetweenAnyPointsWhichIntersectPlaneWhereZIsZero(corners);
        }
        if (shapes != null && shapes.size() > 0) {
            int size = shapes.size();
            float[] xyCoord = new float[size * 2];
            for (int i = 0; i < size; ++i) {
                Line2D.Double line = (Line2D.Double)shapes.get(i);
                xyCoord[i * 2] = (float)line.getX2();
                xyCoord[i * 2 + 1] = (float)line.getY2();
            }
            return xyCoord;
        }
        return null;
    }
}

