/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.dicom.codec.geometry;

import java.awt.geom.Point2D;
import java.util.Vector;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.weasis.dicom.codec.geometry.GeometryOfSlice;
import org.weasis.dicom.codec.geometry.LocalizerPoster;

public class IntersectVolume
extends LocalizerPoster {
    public IntersectVolume(GeometryOfSlice geometry) {
        this.localizerRow = geometry.getRow();
        this.localizerColumn = geometry.getColumn();
        this.localizerTLHC = geometry.getTLHC();
        this.localizerVoxelSpacing = geometry.getVoxelSpacing();
        this.localizerDimensions = geometry.getDimensions();
        this.doCommonConstructorStuff();
    }

    @Override
    public float[] getOutlineOnLocalizerForThisGeometry(Vector3d row, Vector3d column, Point3d tlhc, Tuple3d voxelSpacing, double sliceThickness, Tuple3d dimensions) {
        Point3d[] corners = IntersectVolume.getCornersOfSourceCubeInSourceSpace(row, column, tlhc, voxelSpacing, sliceThickness, dimensions);
        for (int i = 0; i < 8; ++i) {
            corners[i] = this.transformPointFromSourceSpaceIntoLocalizerSpace(corners[i]);
        }
        Vector intersections = this.getIntersectionsOfCubeWithZPlane(corners);
        if (intersections != null && intersections.size() > 0) {
            Point3d[] cor = intersections.toArray(new Point3d[intersections.size()]);
            float[] xyCoord = new float[cor.length * 2];
            for (int i = 0; i < cor.length; ++i) {
                Point2D.Double thisPoint = this.transformPointInLocalizerPlaneIntoImageSpace(cor[i]);
                xyCoord[i * 2] = (float)thisPoint.x;
                xyCoord[i * 2 + 1] = (float)thisPoint.y;
            }
            return xyCoord;
        }
        return null;
    }
}

