/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.dicom.codec.pref;

import org.osgi.service.prefs.Preferences;
import org.weasis.core.api.service.BundlePreferences;
import org.weasis.dicom.codec.internal.Activator;

public class DicomPrefManager {
    private static DicomPrefManager instance;
    private String j2kReader;

    public static synchronized DicomPrefManager getInstance() {
        if (instance == null) {
            instance = new DicomPrefManager();
        }
        return instance;
    }

    private DicomPrefManager() {
        Preferences pref = Activator.PREFERENCES.getDefaultPreferences();
        if (pref != null) {
            Preferences prefNode = pref.node("dicom");
            this.j2kReader = prefNode.get("jpeg2000.reader", null);
        }
    }

    public void savePreferences() {
        Preferences prefs = Activator.PREFERENCES.getDefaultPreferences();
        if (prefs != null) {
            Preferences prefNode = prefs.node("dicom");
            BundlePreferences.putStringPreferences((Preferences)prefNode, (String)"jpeg2000.reader", (String)this.j2kReader);
        }
    }

    public String getJ2kReader() {
        return this.j2kReader;
    }

    public void setJ2kReader(String j2kReader) {
        this.j2kReader = j2kReader;
    }
}

