/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.api.gui.util;

import javax.swing.JLabel;
import org.weasis.core.api.gui.util.AnimatedIconStatic;

public class AnimatedLabel
extends JLabel {
    private static final long serialVersionUID = 1L;
    private AnimatedIconStatic ani;
    private Animate an;

    public AnimatedLabel(AnimatedIconStatic icon, long refresh) {
        this.init(icon, refresh);
    }

    protected AnimatedLabel() {
    }

    protected void init(AnimatedIconStatic icon, long refresh) {
        this.ani = icon;
        super.setIcon(icon);
        super.setSize(icon.getIconWidth(), icon.getIconWidth());
        this.an = new Animate(refresh);
    }

    public void start() {
        this.ani.reset();
        this.an.start();
    }

    public void stop() {
        this.an.interrupt();
    }

    public void reset() {
        this.ani.reset();
    }

    protected void finalize() throws Throwable {
        this.an.interrupt();
    }

    protected class Animate
    extends Thread {
        protected final long refresh;

        public Animate(long refresh) {
            super.setDaemon(true);
            super.setName("AnimatorThread_" + this.refresh + "_" + AnimatedLabel.this.ani.getName());
            this.refresh = refresh;
        }

        @Override
        public void run() {
            while (!this.isInterrupted()) {
                AnimatedLabel.this.ani.animate();
                AnimatedLabel.this.repaint();
                try {
                    Thread.sleep(this.refresh);
                }
                catch (InterruptedException e) {
                    this.interrupt();
                }
            }
        }
    }
}

