/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.api.gui.util;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;

public final class GeomUtil {
    public static Point2D getMidPoint(Point2D A, Point2D B) {
        return new Point2D.Double((A.getX() + B.getX()) / 2.0, (A.getY() + B.getY()) / 2.0);
    }

    public static double getAngleRad(Point2D A, Point2D B, Point2D C) {
        return GeomUtil.getAngleRad(B, C) - GeomUtil.getAngleRad(B, A);
    }

    public static double getAngleDeg(Point2D A, Point2D B, Point2D C) {
        return Math.toDegrees(GeomUtil.getAngleRad(A, B, C));
    }

    public static double getAngleRad(Point2D A, Point2D B) {
        return Math.atan2(A.getY() - B.getY(), B.getX() - A.getX());
    }

    public static double getAngleDeg(Point2D A, Point2D B) {
        return Math.toDegrees(GeomUtil.getAngleRad(A, B));
    }

    public static double getSmallestRotationAngleRad(double angle) {
        if (Math.abs(angle %= Math.PI) > Math.PI) {
            angle -= Math.signum(angle) * 2.0 * Math.PI;
        }
        return angle;
    }

    public static double getSmallestRotationAngleDeg(double angle) {
        if (Math.abs(angle %= 360.0) > 180.0) {
            angle -= Math.signum(angle) * 360.0;
        }
        return angle;
    }

    public static Point2D getColinearPointWithLength(Point2D A, Point2D B, double newLength) {
        return GeomUtil.getColinearPointWithRatio(A, B, newLength / A.distance(B));
    }

    public static Point2D getColinearPointWithRatio(Point2D A, Point2D B, double k) {
        return new Point2D.Double(B.getX() * k + A.getX() * (1.0 - k), B.getY() * k + A.getY() * (1.0 - k));
    }

    public static Line2D getMedianLine(Line2D line1, Line2D line2) {
        double Ax = line1.getX1();
        double Ay = line1.getY1();
        double Bx = line1.getX2();
        double By = line1.getY2();
        double Cx = line2.getX1();
        double Cy = line2.getY1();
        double Dx = line2.getX2();
        double Dy = line2.getY2();
        double Mx = (Ax + Cx) / 2.0;
        double My = (Ay + Cy) / 2.0;
        double Nx = (Bx + Dx) / 2.0;
        double Ny = (By + Dy) / 2.0;
        return new Line2D.Double(Mx, My, Nx, Ny);
    }

    public static Line2D getMedianLine(Point2D A, Point2D B, Point2D C, Point2D D) {
        return GeomUtil.getMedianLine(new Line2D.Double(A, B), new Line2D.Double(C, D));
    }

    public static Point2D getIntersectPoint(Point2D A, Point2D B, Point2D C, Point2D D) {
        Point2D.Double P = null;
        double Ax = A.getX();
        double Ay = A.getY();
        double Bx = B.getX();
        double By = B.getY();
        double Cx = C.getX();
        double Cy = C.getY();
        double Dx = D.getX();
        double Dy = D.getY();
        double denominator = (Bx - Ax) * (Dy - Cy) - (By - Ay) * (Dx - Cx);
        if (denominator != 0.0) {
            double r = ((Ay - Cy) * (Dx - Cx) - (Ax - Cx) * (Dy - Cy)) / denominator;
            double s = ((Ay - Cy) * (Bx - Ax) - (Ax - Cx) * (By - Ay)) / denominator;
            P = new Point2D.Double(Ax + r * (Bx - Ax), Ay + r * (By - Ay));
        }
        return P;
    }

    public static Point2D getIntersectPoint(Line2D line1, Line2D line2) {
        return GeomUtil.getIntersectPoint(line1.getP1(), line1.getP2(), line2.getP1(), line2.getP2());
    }

    public static Point2D getPerpendicularPointToLine(Point2D A, Point2D B, Point2D C) {
        double Ax = A.getX();
        double Ay = A.getY();
        double Bx = B.getX();
        double By = B.getY();
        double Cx = C.getX();
        double Cy = C.getY();
        double r = ((Ay - Cy) * (Ay - By) + (Ax - Cx) * (Ax - Bx)) / Point2D.distanceSq(Ax, Ay, Bx, By);
        return new Point2D.Double(Ax + r * (Bx - Ax), Ay + r * (By - Ay));
    }

    public static Point2D getPerpendicularPointToLine(Line2D L, Point2D C) {
        return GeomUtil.getPerpendicularPointToLine(L.getP1(), L.getP2(), C);
    }

    public static Point2D getPerpendicularPointFromLine(Point2D A, Point2D B, Point2D P, double distPC) {
        double AB = A.distance(B);
        double ux = -(B.getY() - A.getY()) / AB;
        double uy = (B.getX() - A.getX()) / AB;
        return new Point2D.Double(P.getX() + distPC * ux, P.getY() + distPC * uy);
    }

    public static Point2D getPerpendicularPointFromLine(Point2D A, Point2D B, double distAP, double distPC) {
        return GeomUtil.getPerpendicularPointFromLine(A, B, GeomUtil.getColinearPointWithLength(A, B, distAP), distPC);
    }

    public static Line2D getParallelLine(Point2D A, Point2D B, double dist) {
        double AB = A.distanceSq(B);
        double ux = -(B.getY() - A.getY()) / AB;
        double uy = (B.getX() - A.getX()) / AB;
        Point2D.Double C = new Point2D.Double(A.getX() + dist * ux, A.getY() + dist * uy);
        Point2D.Double D = new Point2D.Double(B.getX() + dist * ux, B.getY() + dist * uy);
        return new Line2D.Double(C, D);
    }

    public static Point2D getCircleCenter(List<Point2D> ptList) {
        switch (ptList.size()) {
            case 3: {
                return GeomUtil.getCircleCenter(ptList.get(0), ptList.get(1), ptList.get(2));
            }
            case 2: {
                return new Point2D.Double((ptList.get(0).getX() + ptList.get(1).getX()) / 2.0, (ptList.get(0).getY() + ptList.get(1).getY()) / 2.0);
            }
        }
        return null;
    }

    public static Point2D getCircleCenter(Point2D a, Point2D b, Point2D c) {
        double ax = a.getX();
        double ay = a.getY();
        double bx = b.getX();
        double by = b.getY();
        double cx = c.getX();
        double cy = c.getY();
        double A = bx - ax;
        double B = by - ay;
        double C = cx - ax;
        double D = cy - ay;
        double E = A * (ax + bx) + B * (ay + by);
        double F = C * (ax + cx) + D * (ay + cy);
        double G = 2.0 * (A * (cy - by) - B * (cx - bx));
        if (G == 0.0) {
            return null;
        }
        double px = (D * E - B * F) / G;
        double py = (A * F - C * E) / G;
        return new Point2D.Double(px, py);
    }

    public static double extractScalingFactor(AffineTransform transform) {
        double scalingFactor = 1.0;
        if (transform != null) {
            double sx = transform.getScaleX();
            double shx = transform.getShearX();
            if (sx != 0.0 || shx != 0.0) {
                scalingFactor = Math.sqrt(sx * sx + shx * shx);
            }
        }
        return scalingFactor;
    }

    public static Shape getScaledShape(Shape shape, double scalingFactor, Point2D anchorPoint) {
        if (shape == null) {
            return null;
        }
        AffineTransform scaleTransform = new AffineTransform();
        if (scalingFactor != 1.0) {
            if (anchorPoint != null) {
                scaleTransform.translate(anchorPoint.getX(), anchorPoint.getY());
            }
            scaleTransform.scale(scalingFactor, scalingFactor);
            if (anchorPoint != null) {
                scaleTransform.translate(-anchorPoint.getX(), -anchorPoint.getY());
            }
        }
        return scaleTransform.createTransformedShape(shape);
    }

    public static Rectangle2D getScaledRectangle(Rectangle2D rect, double scalingFactor) {
        if (rect == null) {
            return null;
        }
        if (scalingFactor != 1.0) {
            double resizedWidth = rect.getWidth() * scalingFactor;
            double resizedHeight = rect.getHeight() * scalingFactor;
            rect.setRect(rect.getX(), rect.getY(), resizedWidth, resizedHeight);
        }
        return rect;
    }

    public static Shape getCornerShape(Point2D A, Point2D O, Point2D B, double cornerSize) {
        GeneralPath path = new GeneralPath(1, 2);
        Point2D I1 = GeomUtil.getColinearPointWithLength(O, A, cornerSize);
        Point2D I2 = GeomUtil.getColinearPointWithLength(O, B, cornerSize);
        double rotSignum = Math.signum(GeomUtil.getSmallestRotationAngleDeg(GeomUtil.getAngleDeg(B, O, A)));
        Point2D I3 = GeomUtil.getPerpendicularPointFromLine(O, A, I1, rotSignum * cornerSize);
        path.append(new Line2D.Double(I1, I3), false);
        path.append(new Line2D.Double(I2, I3), false);
        return path;
    }

    public static Rectangle2D getGrowingRectangle(Rectangle2D rect, double growingSize) {
        Rectangle2D growingRect = rect != null ? (Rectangle2D)rect.clone() : null;
        GeomUtil.growRectangle(growingRect, growingSize);
        return growingRect;
    }

    public static void growRectangle(Rectangle2D rect, double growingSize) {
        if (rect == null) {
            return;
        }
        if (growingSize != 0.0) {
            double newX = rect.getX() - growingSize;
            double newY = rect.getY() - growingSize;
            double newWidth = rect.getWidth() + 2.0 * growingSize;
            double newHeight = rect.getHeight() + 2.0 * growingSize;
            rect.setRect(newX, newY, newWidth, newHeight);
        }
    }
}

