/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.api.gui.util;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.image.RenderedImage;
import javax.media.jai.PlanarImage;
import javax.media.jai.iterator.RectIter;
import javax.media.jai.iterator.RectIterFactory;
import javax.swing.JPanel;
import org.weasis.core.api.gui.util.PickerOwner;

public class PickerView
extends JPanel {
    private int matrixSize = 3;
    private Rectangle area = null;
    private int nbBand;
    private RectIter rectIter;
    private final PickerOwner pickerOwner;
    private PlanarImage imageView;
    private PlanarImage imageData;

    public PickerView(PickerOwner pickerOwner) {
        this.pickerOwner = pickerOwner;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setPreferredSize(new Dimension(21, 21));
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (!(g instanceof Graphics2D) || this.area == null) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        Color oldColor = g2d.getColor();
        Stroke oldStroke = g2d.getStroke();
        this.drawPickerColor(g2d);
        g2d.setColor(oldColor);
        g2d.setStroke(oldStroke);
    }

    private void drawPickerColor(Graphics2D g2d) {
        if (this.rectIter != null) {
            int[] c = new int[]{0, 0, 0};
            this.rectIter.startBands();
            this.rectIter.startLines();
            int y = 0;
            while (!this.rectIter.finishedLines()) {
                this.rectIter.startPixels();
                int x = 0;
                while (!this.rectIter.finishedPixels()) {
                    this.rectIter.getPixel(c);
                    if (this.nbBand == 1) {
                        g2d.setColor(new Color(c[0], c[0], c[0]));
                    } else {
                        g2d.setColor(new Color(c[0], c[1], c[2]));
                    }
                    g2d.fillRect(x * 7, y * 7, 7, 7);
                    this.rectIter.nextPixel();
                    ++x;
                }
                this.rectIter.nextLine();
                ++y;
            }
        }
    }

    protected int[][] getValueFromArea() {
        RectIter it;
        try {
            it = RectIterFactory.create((RenderedImage)this.imageData, (Rectangle)this.area);
        }
        catch (Exception ex) {
            it = null;
        }
        int[][] val = null;
        if (it != null) {
            val = new int[this.area.width * this.area.height][this.imageData.getSampleModel().getNumBands()];
            int[] c = new int[]{0, 0, 0};
            it.startBands();
            it.startLines();
            int y = 0;
            while (!it.finishedLines()) {
                it.startPixels();
                int x = 0;
                while (!it.finishedPixels()) {
                    it.getPixel(c);
                    for (int i = 0; i < this.imageData.getSampleModel().getNumBands(); ++i) {
                        val[y * this.area.width + x][i] = c[i];
                    }
                    it.nextPixel();
                    ++x;
                }
                it.nextLine();
                ++y;
            }
        }
        return val;
    }

    public int getMatrixSize() {
        return this.matrixSize;
    }

    public void setMatrixSize(int matrixSize) {
        this.matrixSize = matrixSize;
    }

    public void setImageView(PlanarImage imageView) {
        this.imageView = imageView;
    }

    public void setImageData(PlanarImage imageData) {
        this.imageData = imageData;
    }

    public void setArea(Rectangle area, boolean updateTresh) {
        this.area = area;
        try {
            this.rectIter = RectIterFactory.create((RenderedImage)this.imageView, (Rectangle)area);
            this.nbBand = this.imageView.getSampleModel().getNumBands();
        }
        catch (Exception ex) {
            this.rectIter = null;
        }
        this.repaint();
        if (updateTresh && area != null) {
            this.pickerOwner.setPickerValues(this.getValueFromArea(), area);
        }
    }
}

