/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.api.gui.util;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import org.weasis.core.api.gui.util.ActionState;
import org.weasis.core.api.gui.util.ActionW;

public abstract class ToggleButtonListener
implements ActionListener,
ActionState {
    protected final ArrayList<AbstractButton> itemList;
    protected ButtonModel model;
    protected final ActionW action;

    public ToggleButtonListener(ActionW action, boolean selected) {
        this.action = action;
        this.itemList = new ArrayList();
        this.model = new JToggleButton.ToggleButtonModel();
        this.model.setSelected(selected);
        this.model.addActionListener(this);
    }

    @Override
    public void enableAction(boolean enabled) {
        this.model.setEnabled(enabled);
    }

    public String toString() {
        return this.action.getTitle();
    }

    @Override
    public ActionW getActionW() {
        return this.action;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof ButtonModel) {
            this.actionPerformed(this.model.isSelected());
        }
    }

    public abstract void actionPerformed(boolean var1);

    public synchronized void setSelectedWithoutTriggerAction(boolean selected) {
        this.model.setSelected(selected);
    }

    public synchronized void setSelected(boolean selected) {
        boolean oldVal = this.model.isSelected();
        if (oldVal != selected) {
            this.model.setSelected(selected);
            this.actionPerformed(selected);
        }
    }

    public boolean isSelected() {
        return this.model.isSelected();
    }

    public void registerComponent(AbstractButton component) {
        if (!this.itemList.contains(component)) {
            this.itemList.add(component);
            component.setModel(this.model);
        }
    }

    public void unregisterComponent(JComponent component) {
        this.itemList.remove(component);
    }

    public JCheckBoxMenuItem createUnregiteredJCheckBoxMenuItem(String text) {
        JCheckBoxMenuItem checkBoxItem = new JCheckBoxMenuItem(text, null, this.model.isSelected());
        checkBoxItem.setModel(this.model);
        return checkBoxItem;
    }

    public JCheckBox createCheckBox(String title) {
        JCheckBox check = new JCheckBox(title);
        this.registerComponent(check);
        return check;
    }

    public JCheckBoxMenuItem createMenu(String title) {
        JCheckBoxMenuItem menu = new JCheckBoxMenuItem(title);
        this.registerComponent(menu);
        return menu;
    }
}

