/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.api.image;

import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.weasis.core.api.gui.util.GUIEntry;
import org.weasis.core.api.image.LayoutConstraints;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class GridBagLayoutModel
implements GUIEntry {
    private String title;
    private final Icon icon;
    private final LinkedHashMap<LayoutConstraints, JComponent> constraints;

    public GridBagLayoutModel(String title, int rows, int cols, String defaultClass, Icon icon) {
        this.title = title;
        this.icon = icon;
        if (cols < 1) {
            cols = 1;
        }
        if (rows < 1) {
            rows = 1;
        }
        this.constraints = new LinkedHashMap(cols * rows);
        double weightx = 1.0 / (double)cols;
        double weighty = 1.0 / (double)rows;
        for (int y = 0; y < rows; ++y) {
            for (int x = 0; x < cols; ++x) {
                this.constraints.put(new LayoutConstraints(defaultClass, y * cols + cols, x, y, 1, 1, weightx, weighty, 10, 1), null);
            }
        }
    }

    public GridBagLayoutModel(LinkedHashMap<LayoutConstraints, JComponent> constraints, String title, Icon icon) {
        if (constraints == null) {
            throw new IllegalArgumentException("constraints cannot be null");
        }
        this.title = title;
        this.icon = icon;
        this.constraints = constraints;
    }

    public GridBagLayoutModel(InputStream stream, String title, Icon icon) {
        this.title = title;
        this.icon = icon;
        this.constraints = new LinkedHashMap();
        try {
            this.loadXML(stream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
    }

    public String toString() {
        return this.title;
    }

    public LinkedHashMap<LayoutConstraints, JComponent> getConstraints() {
        return this.constraints;
    }

    public void loadXML(InputStream stream) throws IOException, SAXException {
        try {
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            SAXAdapter adapter = new SAXAdapter();
            parser.parse(stream, (DefaultHandler)adapter);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (FactoryConfigurationError e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public Icon getIcon() {
        return this.icon;
    }

    @Override
    public String getUIName() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    private final class SAXAdapter
    extends DefaultHandler {
        private int x;
        private int y;
        private int width;
        private int height;
        private double weightx;
        private double weighty;
        private int position;
        private int expand;
        private String type;
        private final int increment = 0;
        int tag = -1;
        StringBuffer name = new StringBuffer(80);

        private SAXAdapter() {
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.tag != -1) {
                this.name.append(ch, start, length);
            }
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if ("element".equals(qName)) {
                this.type = attributes.getValue("type");
                this.x = Integer.parseInt(attributes.getValue("x"));
                this.y = Integer.parseInt(attributes.getValue("y"));
                this.width = Integer.parseInt(attributes.getValue("width"));
                this.height = Integer.parseInt(attributes.getValue("height"));
                this.weightx = this.getDoubleValue(attributes.getValue("weightx"));
                this.weighty = this.getDoubleValue(attributes.getValue("weighty"));
                this.position = Integer.parseInt(attributes.getValue("position"));
                this.expand = Integer.parseInt(attributes.getValue("expand"));
            } else if (GridBagLayoutModel.this.title == null && "layoutModel".equals(qName)) {
                GridBagLayoutModel.this.title = attributes.getValue("name");
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if ("element".equals(qName)) {
                GridBagLayoutModel.this.constraints.put(new LayoutConstraints(this.type, 0, this.x, this.y, this.width, this.height, this.weightx, this.weighty, this.position, this.expand), null);
                this.name.setLength(0);
                this.tag = -1;
            }
        }

        private double getDoubleValue(String val) {
            if (val.trim().equals("")) {
                return 0.0;
            }
            int index = val.indexOf(47);
            if (index != -1) {
                return (double)Integer.parseInt(val.substring(0, index)) / (double)Integer.parseInt(val.substring(index + 1));
            }
            return Double.parseDouble(val);
        }
    }
}

