/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.api.image;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import javax.media.jai.JAI;
import javax.media.jai.LookupTableJAI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.weasis.core.api.Messages;
import org.weasis.core.api.gui.ImageOperation;
import org.weasis.core.api.gui.util.ActionW;
import org.weasis.core.api.image.AbstractOperation;
import org.weasis.core.api.image.op.ByteLut;
import org.weasis.core.api.image.util.ImageToolkit;

public class PseudoColorOperation
extends AbstractOperation {
    private static final Logger LOGGER = LoggerFactory.getLogger(PseudoColorOperation.class);
    public static final String name = Messages.getString("PseudoColorOperation.title");

    @Override
    public String getOperationName() {
        return name;
    }

    @Override
    public RenderedImage getRenderedImage(RenderedImage source, ImageOperation imageOperation) {
        Boolean invert = (Boolean)imageOperation.getActionValue(ActionW.INVERSELUT.cmd());
        ByteLut lutTable = (ByteLut)imageOperation.getActionValue(ActionW.LUT.cmd());
        if (invert == null) {
            invert = false;
        }
        if (lutTable == null) {
            this.result = source;
            LOGGER.warn("Cannot apply \"{}\" because a parameter is null", (Object)name);
        } else {
            byte[][] lut;
            byte[][] byArray = lut = invert != false ? lutTable.getInvertedLutTable() : lutTable.getLutTable();
            if (lut == null) {
                if (invert.booleanValue()) {
                    ParameterBlock pb = new ParameterBlock();
                    pb.addSource(source);
                    this.result = JAI.create((String)"invert", (ParameterBlock)pb, (RenderingHints)ImageToolkit.NOCACHE_HINT);
                } else {
                    this.result = source;
                }
            } else {
                ParameterBlock pb = new ParameterBlock();
                pb.addSource(source);
                pb.add(new LookupTableJAI(lut));
                this.result = JAI.create((String)"lookup", (ParameterBlock)pb, (RenderingHints)ImageToolkit.NOCACHE_HINT);
            }
        }
        return this.result;
    }

    public static BufferedImage getLUT(byte[][] lut) {
        BufferedImage image = new BufferedImage(20, 256, 1);
        Graphics2D g = image.createGraphics();
        for (int k = 0; k < 256; ++k) {
            g.setPaint(new Color(lut[0][k] & 0xFF, lut[1][k] & 0xFF, lut[2][k] & 0xFF));
            g.fillRect(0, k, 20, 1);
        }
        return image;
    }
}

