/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.api.media.data;

import java.io.File;
import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.weasis.core.api.media.data.MediaReader;
import org.weasis.core.api.media.data.TagW;

public abstract class MediaElement<E> {
    protected final HashMap<TagW, Object> tags;
    protected final MediaReader<E> mediaIO;
    protected final Object key;
    protected boolean localFile;
    protected String name = "";
    protected File file;
    private transient boolean loading = false;

    public MediaElement(MediaReader<E> mediaIO, Object key) {
        if (mediaIO == null) {
            throw new IllegalArgumentException("mediaIO is null");
        }
        this.mediaIO = mediaIO;
        this.key = key;
        HashMap t = mediaIO.getMediaFragmentTags(key);
        this.tags = t == null ? new HashMap() : t;
        URI uri = mediaIO.getMediaFragmentURI(key);
        if (uri == null) {
            this.localFile = false;
        } else {
            boolean bl = this.localFile = uri.toString().startsWith("file:/");
            if (this.localFile) {
                this.file = new File(uri);
                this.name = this.file.getName();
            }
        }
    }

    public MediaReader<E> getMediaReader() {
        return this.mediaIO;
    }

    public void setTag(TagW tag, Object value) {
        if (tag != null) {
            this.tags.put(tag, value);
        }
    }

    public boolean containTagKey(TagW tag) {
        return this.tags.containsKey(tag);
    }

    public Object getTagValue(TagW tag) {
        return this.tags.get(tag);
    }

    public TagW getTagElement(int id) {
        for (TagW e : this.tags.keySet()) {
            if (e.id != id) continue;
            return e;
        }
        return null;
    }

    public Iterator<Map.Entry<TagW, Object>> getTagIterator() {
        return this.tags.entrySet().iterator();
    }

    public void clearAllTags() {
        this.tags.clear();
    }

    public boolean isLocalFile() {
        return this.localFile;
    }

    public abstract void dispose();

    public URI getMediaURI() {
        return this.mediaIO.getMediaFragmentURI(this.key);
    }

    public File getFile() {
        return this.file;
    }

    public String getName() {
        return this.name;
    }

    public Object getKey() {
        return this.key;
    }

    public long getLength() {
        if (this.localFile) {
            return this.file.length();
        }
        return 0L;
    }

    public long getLastModified() {
        if (this.localFile) {
            return this.file.lastModified();
        }
        return 0L;
    }

    public String getMimeType() {
        return this.mediaIO.getMediaFragmentMimeType(this.key);
    }

    protected final synchronized boolean setAsLoading() {
        if (!this.loading) {
            this.loading = true;
            return true;
        }
        return false;
    }

    protected final synchronized void setAsLoaded() {
        this.loading = false;
    }

    public final synchronized boolean isLoading() {
        return this.loading;
    }
}

